/*
 * Decompiled with CFR 0.152.
 */
package nethome.geom.util;

import com.kt.util.Item;
import com.kt.util.RefList;
import java.util.Vector;
import nethome.geom.primitive.GPoint2Df;
import nethome.geom.util.LinkedPoint2Df;
import nethome.geom.util.ToolMath;
import nethome.geom.util.ToolPolygon;
import nethome.geom.util.TotsuHou;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolBooleanPolygon {
    private static final int SHARED = 0;
    private static final int INSIDE = 1;
    private static final int OUTSIDE = 2;

    public static RefList<LinkedPoint2Df> culcAdd(RefList<? extends GPoint2Df> refList, RefList<? extends GPoint2Df> refList2) {
        RefList<LinkedPoint2Df> refList3 = ToolBooleanPolygon.createLinkedList(refList);
        RefList<LinkedPoint2Df> refList4 = ToolBooleanPolygon.createLinkedList(refList2);
        RefList<LinkedPoint2Df> refList5 = null;
        if (ToolBooleanPolygon.preCulcBoolean(refList3, refList4)) {
            refList5 = ToolBooleanPolygon.addition(refList3, refList4);
        }
        refList3.removeAllElements();
        refList4.removeAllElements();
        return refList5;
    }

    public static RefList<RefList<LinkedPoint2Df>> culcSub(RefList<? extends GPoint2Df> refList, RefList<? extends GPoint2Df> refList2) {
        RefList<LinkedPoint2Df> refList3 = ToolBooleanPolygon.createLinkedList(refList);
        RefList<LinkedPoint2Df> refList4 = ToolBooleanPolygon.createLinkedList(refList2);
        RefList refList5 = null;
        if (ToolBooleanPolygon.preCulcBoolean(refList3, refList4)) {
            refList5 = ToolBooleanPolygon.subtraction(refList3, refList4);
        } else {
            boolean bl = ToolBooleanPolygon.checkInclude(refList3, refList4, false);
            boolean bl2 = ToolBooleanPolygon.checkInclude(refList4, refList3, false);
            if (bl && bl2) {
                refList5 = null;
            } else if (!bl && !bl2 || bl) {
                refList5 = new RefList();
                refList5.addElement(refList3);
            } else if (bl2) {
                refList5 = null;
            }
        }
        return refList5;
    }

    private static boolean checkInclude(RefList<LinkedPoint2Df> refList, RefList<LinkedPoint2Df> refList2, boolean bl) {
        for (int i = 0; i < refList.size(); ++i) {
            GPoint2Df gPoint2Df = (GPoint2Df)refList.elementAt(i);
            GPoint2Df gPoint2Df2 = (GPoint2Df)refList.elementAt(i + 1);
            float f = (gPoint2Df.x + gPoint2Df2.x) / 2.0f;
            float f2 = (gPoint2Df.y + gPoint2Df2.y) / 2.0f;
            if (!ToolPolygon.isInnerPolygon(refList2, f, f2)) {
                return false;
            }
            if (!bl || !ToolBooleanPolygon.checkOnEdge(refList2, f, f2)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkOnEdge(RefList<LinkedPoint2Df> refList, float f, float f2) {
        for (int i = 0; i < refList.size(); ++i) {
            GPoint2Df gPoint2Df = (GPoint2Df)refList.elementAt(i);
            GPoint2Df gPoint2Df2 = (GPoint2Df)refList.elementAt(i + 1);
            if (!ToolMath.isOnLimitLinePoint2D(f, f2, gPoint2Df.x, gPoint2Df.y, gPoint2Df2.x, gPoint2Df2.y)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSame(Object object, Object object2) {
        if (object != null && object2 != null && object instanceof GPoint2Df && object2 instanceof GPoint2Df) {
            GPoint2Df gPoint2Df = (GPoint2Df)object;
            GPoint2Df gPoint2Df2 = (GPoint2Df)object2;
            return ToolMath.isSame2D(gPoint2Df.x, gPoint2Df.y, gPoint2Df2.x, gPoint2Df2.y);
        }
        return false;
    }

    private static RefList<LinkedPoint2Df> createLinkedList(RefList<? extends GPoint2Df> refList) {
        RefList refList2 = new RefList();
        for (int i = 0; i < refList.size(); ++i) {
            GPoint2Df gPoint2Df = (GPoint2Df)refList.elementAt(i);
            refList2.addElement((Object)new LinkedPoint2Df(gPoint2Df));
        }
        return refList2;
    }

    private static boolean preCulcBoolean(RefList<LinkedPoint2Df> refList, RefList<LinkedPoint2Df> refList2) {
        ToolPolygon.removeOverlapNode(refList);
        ToolPolygon.removeOverlapNode(refList2);
        ToolBooleanPolygon.initializePolygon(refList);
        ToolBooleanPolygon.initializePolygon(refList2);
        ToolBooleanPolygon.addLink(refList, refList2);
        if (!ToolBooleanPolygon.checkLink(refList)) {
            return false;
        }
        ToolBooleanPolygon.setNodeState(refList, refList2);
        ToolBooleanPolygon.setNodeState(refList2, refList);
        return true;
    }

    private static void initializePolygon(RefList<LinkedPoint2Df> refList) {
        Item item = refList.itemAt(0);
        do {
            ((LinkedPoint2Df)item.getObject()).flag = -1;
            ((LinkedPoint2Df)item.getObject()).mLink = null;
        } while ((item = item.nextItem) != refList.itemAt(0));
    }

    private static boolean checkLink(RefList<LinkedPoint2Df> refList) {
        int n = 0;
        for (int i = 0; i < refList.size(); ++i) {
            if (((LinkedPoint2Df)refList.elementAt((int)i)).mLink == null) continue;
            ++n;
        }
        return n > 1;
    }

    private static void addLink(RefList<LinkedPoint2Df> refList, RefList<LinkedPoint2Df> refList2) {
        Item item = refList.itemAt(0);
        do {
            Item item2 = refList2.itemAt(0);
            do {
                LinkedPoint2Df linkedPoint2Df = (LinkedPoint2Df)item.getObject();
                LinkedPoint2Df linkedPoint2Df2 = (LinkedPoint2Df)item2.getObject();
                if (!(ToolMath.getLength2D(linkedPoint2Df.x, linkedPoint2Df.y, linkedPoint2Df2.x, linkedPoint2Df2.y) < (double)0.001f)) continue;
                linkedPoint2Df.mLink = item2;
                linkedPoint2Df2.mLink = item;
            } while ((item2 = item2.nextItem) != refList2.itemAt(0));
        } while ((item = item.nextItem) != refList.itemAt(0));
    }

    private static void setNodeState(RefList<LinkedPoint2Df> refList, RefList<LinkedPoint2Df> refList2) {
        int n;
        Item item = null;
        for (n = 0; n < refList.size(); ++n) {
            if (((LinkedPoint2Df)refList.elementAt((int)n)).mLink == null) continue;
            item = refList.itemAt(n);
            break;
        }
        if (item == null) {
            return;
        }
        Item item2 = item;
        n = -1;
        do {
            if (((LinkedPoint2Df)item2.getObject()).flag != 2 && ((LinkedPoint2Df)item2.getObject()).flag >= 0) continue;
            Item<LinkedPoint2Df> item3 = ((LinkedPoint2Df)item2.getObject()).mLink;
            Item<LinkedPoint2Df> item4 = ((LinkedPoint2Df)item2.nextItem.getObject()).mLink;
            if (item3 != null && item4 != null && (item3.nextItem == item4 || item4.nextItem == item3)) {
                n = 0;
                ((LinkedPoint2Df)item2.getObject()).flag = 0;
                continue;
            }
            if (item3 != null) {
                LinkedPoint2Df linkedPoint2Df = (LinkedPoint2Df)item2.getObject();
                LinkedPoint2Df linkedPoint2Df2 = (LinkedPoint2Df)item2.nextItem.getObject();
                LinkedPoint2Df linkedPoint2Df3 = (LinkedPoint2Df)item3.prevItem.getObject();
                LinkedPoint2Df linkedPoint2Df4 = (LinkedPoint2Df)item3.nextItem.getObject();
                double d = ToolMath.getAngle2D(linkedPoint2Df.x, linkedPoint2Df.y, linkedPoint2Df4.x, linkedPoint2Df4.y);
                double d2 = ToolMath.getAngle2D(linkedPoint2Df.x, linkedPoint2Df.y, linkedPoint2Df2.x, linkedPoint2Df2.y);
                double d3 = ToolMath.getAngle2D(linkedPoint2Df.x, linkedPoint2Df.y, linkedPoint2Df3.x, linkedPoint2Df3.y);
                if ((d2 = ToolMath.getAngl2PI(d2 - d)) <= (d3 = ToolMath.getAngl2PI(d3 - d))) {
                    n = 1;
                    ((LinkedPoint2Df)item2.getObject()).flag = 1;
                    continue;
                }
                n = 2;
                ((LinkedPoint2Df)item2.getObject()).flag = 2;
                continue;
            }
            ((LinkedPoint2Df)item2.getObject()).flag = n;
        } while ((item2 = item2.nextItem) != item);
    }

    private static boolean isIncludeNode(RefList<RefList<LinkedPoint2Df>> refList, LinkedPoint2Df linkedPoint2Df) {
        if (refList.size() == 0) {
            return false;
        }
        Item item = refList.itemAt(0);
        for (int i = 0; i < refList.size(); ++i) {
            RefList refList2 = (RefList)item.getObject();
            Item item2 = refList2.itemAt(0);
            for (int j = 0; j < refList2.size(); ++j) {
                if (ToolBooleanPolygon.isSame(linkedPoint2Df, item2.getObject())) {
                    return true;
                }
                item2 = item2.nextItem;
            }
            item = item.nextItem;
        }
        return false;
    }

    private static RefList<LinkedPoint2Df> addition(RefList<LinkedPoint2Df> refList, RefList<LinkedPoint2Df> refList2) {
        Item<LinkedPoint2Df> item = ToolBooleanPolygon.serchHead(refList, refList2);
        if (item == null) {
            return null;
        }
        RefList<LinkedPoint2Df> refList3 = ToolBooleanPolygon.gatherAdd(item, refList.size() + refList2.size());
        if (refList3 != null) {
            ToolPolygon.removeOverlapNode(refList3);
        }
        return refList3;
    }

    private static RefList<RefList<LinkedPoint2Df>> subtraction(RefList<LinkedPoint2Df> refList, RefList<LinkedPoint2Df> refList2) {
        RefList refList3 = new RefList();
        Item item = refList.itemAt(0);
        for (int i = 0; i < refList.size(); ++i) {
            LinkedPoint2Df linkedPoint2Df = (LinkedPoint2Df)item.getObject();
            if (linkedPoint2Df.flag == 2 && !ToolBooleanPolygon.isIncludeNode((RefList<RefList<LinkedPoint2Df>>)refList3, linkedPoint2Df)) {
                RefList<LinkedPoint2Df> refList4 = ToolBooleanPolygon.gatherSub((Item<LinkedPoint2Df>)item, refList.size() + refList2.size());
                if (refList4 != null) {
                    ToolPolygon.removeOverlapNode(refList4);
                    refList3.addElement(refList4);
                } else {
                    System.out.println("*** fatal err ***");
                }
            }
            item = item.nextItem;
        }
        if (refList3.size() != 0) {
            return refList3;
        }
        return null;
    }

    private static RefList<LinkedPoint2Df> gatherAdd(Item<LinkedPoint2Df> item, int n) {
        Item<LinkedPoint2Df> item2 = item;
        RefList refList = new RefList();
        refList.addElement((Object)new LinkedPoint2Df((GPoint2Df)item.getObject()));
        do {
            Item<LinkedPoint2Df> item3 = item2;
            if (((LinkedPoint2Df)item3.getObject()).flag == 0 && ((LinkedPoint2Df)item3.getObject()).mLink.nextItem == ((LinkedPoint2Df)item3.nextItem.getObject()).mLink) {
                ((LinkedPoint2Df)((LinkedPoint2Df)item3.getObject()).mLink.getObject()).flag = 0;
            }
            item2 = item2.nextItem;
            if (((LinkedPoint2Df)item2.getObject()).mLink != null) {
                if (((LinkedPoint2Df)((LinkedPoint2Df)item2.getObject()).mLink.prevItem.getObject()).flag == 1) {
                    item2 = ((LinkedPoint2Df)item2.getObject()).mLink;
                } else if (((LinkedPoint2Df)((LinkedPoint2Df)item2.getObject()).mLink.getObject()).flag == 2 || ((LinkedPoint2Df)((LinkedPoint2Df)item2.getObject()).mLink.getObject()).flag == 0) {
                    item2 = ((LinkedPoint2Df)item2.getObject()).mLink;
                }
            }
            if (!ToolBooleanPolygon.isSame(item2.getObject(), item.getObject())) {
                refList.addElement((Object)new LinkedPoint2Df((GPoint2Df)item2.getObject()));
            }
            if (refList.size() <= n) continue;
            return null;
        } while (!ToolBooleanPolygon.isSame(item2.getObject(), item.getObject()));
        return refList;
    }

    private static RefList<LinkedPoint2Df> gatherSub(Item<LinkedPoint2Df> item, int n) {
        Item<LinkedPoint2Df> item2 = item;
        boolean bl = true;
        RefList refList = new RefList();
        GPoint2Df gPoint2Df = (GPoint2Df)item.getObject();
        LinkedPoint2Df linkedPoint2Df = new LinkedPoint2Df(gPoint2Df.x, gPoint2Df.y);
        linkedPoint2Df.flagObj = gPoint2Df.flagObj;
        refList.addElement((Object)linkedPoint2Df);
        do {
            Item<LinkedPoint2Df> item3;
            Item<LinkedPoint2Df> item4 = item3 = bl ? item2 : item2.prevItem;
            if (((LinkedPoint2Df)item3.getObject()).flag == 0 && ((LinkedPoint2Df)item3.getObject()).mLink.nextItem == ((LinkedPoint2Df)item3.nextItem.getObject()).mLink) {
                ((LinkedPoint2Df)((LinkedPoint2Df)item3.getObject()).mLink.getObject()).flag = 0;
            }
            Item<LinkedPoint2Df> item5 = item2 = bl ? item2.nextItem : item2.prevItem;
            if (!bl && ((LinkedPoint2Df)item2.prevItem.getObject()).flagObj != null) {
                ((LinkedPoint2Df)item2.getObject()).flagObj = ((LinkedPoint2Df)item2.prevItem.getObject()).flagObj;
            }
            if (((LinkedPoint2Df)item2.getObject()).mLink != null) {
                if (bl) {
                    if (((LinkedPoint2Df)((LinkedPoint2Df)item2.getObject()).mLink.prevItem.getObject()).flag == 1) {
                        bl = false;
                        item2 = ((LinkedPoint2Df)item2.getObject()).mLink;
                        LinkedPoint2Df linkedPoint2Df2 = (LinkedPoint2Df)item2.getObject();
                        LinkedPoint2Df linkedPoint2Df3 = (LinkedPoint2Df)item2.prevItem.getObject();
                        if (linkedPoint2Df3.flagObj != null) {
                            linkedPoint2Df2.flagObj = linkedPoint2Df3.flagObj;
                            linkedPoint2Df3.flagObj = null;
                        }
                    }
                } else if (((LinkedPoint2Df)((LinkedPoint2Df)item2.getObject()).mLink.getObject()).flag == 2 || ((LinkedPoint2Df)((LinkedPoint2Df)item2.getObject()).mLink.getObject()).flag == 0) {
                    bl = true;
                    item2 = ((LinkedPoint2Df)item2.getObject()).mLink;
                }
            }
            if (!ToolBooleanPolygon.isSame(item2.getObject(), item.getObject())) {
                refList.addElement((Object)new LinkedPoint2Df((GPoint2Df)item2.getObject()));
            }
            if (refList.size() <= n) continue;
            return null;
        } while (!ToolBooleanPolygon.isSame(item2.getObject(), item.getObject()));
        return refList;
    }

    private static Item<LinkedPoint2Df> serchHead(RefList<LinkedPoint2Df> refList, RefList<LinkedPoint2Df> refList2) {
        int n;
        GPoint2Df gPoint2Df;
        int n2;
        Vector<GPoint2Df> vector = new Vector<GPoint2Df>();
        Item item = refList2.itemAt(0);
        for (n2 = 0; n2 < refList2.size(); ++n2) {
            gPoint2Df = (GPoint2Df)item.getObject();
            vector.addElement(new GPoint2Df(gPoint2Df.x, gPoint2Df.y));
            item = item.nextItem;
        }
        item = refList.itemAt(0);
        for (n2 = 0; n2 < refList.size(); ++n2) {
            gPoint2Df = (GPoint2Df)item.getObject();
            n = 0;
            Item item2 = refList2.itemAt(0);
            for (int i = 0; i < refList2.size(); ++i) {
                GPoint2Df gPoint2Df2 = (GPoint2Df)item2.getObject();
                if (ToolBooleanPolygon.isSame(gPoint2Df, gPoint2Df2)) {
                    n = 1;
                    break;
                }
                item2 = item2.nextItem;
            }
            if (n == 0) {
                GPoint2Df gPoint2Df3 = (GPoint2Df)item.getObject();
                vector.addElement(new GPoint2Df(gPoint2Df3.x, gPoint2Df3.y));
            }
            item = item.nextItem;
        }
        Vector<GPoint2Df> vector2 = TotsuHou.getTotshuhou(vector);
        if (vector2 == null) {
            return null;
        }
        for (int i = 0; i < vector2.size(); ++i) {
            item = refList.itemAt(0);
            for (n = 0; n < refList.size(); ++n) {
                if (ToolBooleanPolygon.isSame(vector2.elementAt(i), item.getObject()) && ((LinkedPoint2Df)item.getObject()).flag == 2) {
                    return item;
                }
                item = item.nextItem;
            }
            item = refList2.itemAt(0);
            for (n = 0; n < refList2.size(); ++n) {
                if (ToolBooleanPolygon.isSame(vector2.elementAt(i), item.getObject()) && ((LinkedPoint2Df)item.getObject()).flag == 2) {
                    return item;
                }
                item = item.nextItem;
            }
        }
        return null;
    }
}

