/*
 * Decompiled with CFR 0.152.
 */
package nethome.geom.primitive;

import com.kt.util.RefList;
import com.kt.util.Vector2;
import com.kt.util.tree.ObjectFolder;
import com.kt.util.tree.ObjectNode;
import java.awt.Color;
import jp.kitec.kwt.Area;
import jp.kitec.kwt.IRichGraphics;
import nethome.geom.GeomPerser;
import nethome.geom.LocalAxis2Df;
import nethome.geom.primitive.GPoint2Df;
import nethome.geom.primitive.Geometory;
import nethome.geom.primitive.Primitive;
import nethome.geom.util.ToolMath;
import nethome.geom.util.ToolPolygon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GPolyLine
extends Geometory
implements Primitive {
    private static final String GEOMNAME = "POLYLINE";
    protected RefList<GPoint2Df> mPoints;
    protected RefList<GPoint2Df> _pbuf = new RefList();
    public float mLineWidth;
    public int mType;
    public int mSmooth;

    public GPolyLine() {
        this((RefList<GPoint2Df>)new RefList(), 0, 0);
    }

    public GPolyLine(RefList<GPoint2Df> refList, int n, int n2) {
        this.setGeomName(GEOMNAME);
        this.mGeomColor = Color.black;
        this.mPoints = refList;
        this.mType = n;
        this.mSmooth = n2;
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    public void addPoint(GPoint2Df gPoint2Df) {
        this.mPoints.addElement((Object)gPoint2Df);
        if (this.areaControl != null) {
            this.areaControl.setArea(this.mPoints);
        }
    }

    @Override
    public boolean getSnapNode(float f, float f2, float f3, float f4, float[] fArray, float[] fArray2, float f5, short s) {
        return false;
    }

    @Override
    public void getSnapLoop(Vector2<? super GPoint2Df> vector2) {
        for (int i = 0; i < this.mPoints.size(); ++i) {
            vector2.addElement(this.mPoints.elementAt(i));
        }
    }

    @Override
    public void getCenter(GPoint2Df gPoint2Df) {
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < this.mPoints.size(); ++i) {
            GPoint2Df gPoint2Df2 = (GPoint2Df)this.mPoints.elementAt(i);
            f += gPoint2Df2.x;
            f2 += gPoint2Df2.y;
        }
        gPoint2Df.x = f / (float)this.mPoints.size();
        gPoint2Df.y = f2 / (float)this.mPoints.size();
    }

    @Override
    public GPoint2Df getNearNode(GPoint2Df gPoint2Df, GPoint2Df gPoint2Df2, float f) {
        float f2 = Float.MAX_VALUE;
        GPoint2Df gPoint2Df3 = null;
        for (int i = 0; i < this.mPoints.size(); ++i) {
            float f3;
            GPoint2Df gPoint2Df4 = (GPoint2Df)this.mPoints.elementAt(i);
            float f4 = (float)ToolMath.getLengthLimitLineToPoint2D(gPoint2Df4.x, gPoint2Df4.y, gPoint2Df.x, gPoint2Df.y, gPoint2Df2.x, gPoint2Df2.y);
            if (!(f3 >= 0.0f) || !(f4 < f) || !(f4 < f2)) continue;
            f2 = f4;
            gPoint2Df3 = gPoint2Df4;
        }
        return gPoint2Df3;
    }

    @Override
    public boolean getNearLine(float f, float f2, float f3, GPoint2Df[] gPoint2DfArray) {
        boolean bl = false;
        for (int i = 0; i < this.mPoints.size(); ++i) {
            float f4;
            GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(i);
            GPoint2Df gPoint2Df2 = (GPoint2Df)this.mPoints.elementAt(i + 1);
            float f5 = (float)ToolMath.getLengthLimitLineToPoint2D(f, f2, gPoint2Df.x, gPoint2Df.y, gPoint2Df2.x, gPoint2Df2.y);
            if (!(f4 >= 0.0f) || !(f5 < f3)) continue;
            gPoint2DfArray[0] = gPoint2Df;
            gPoint2DfArray[1] = gPoint2Df2;
            bl = true;
        }
        return bl;
    }

    @Override
    public GPoint2Df getRotbasePoint() {
        return (GPoint2Df)this.mPoints.elementAt(0);
    }

    @Override
    public void updateMinMax(Area area) {
        for (int i = 0; i < this.mPoints.size(); ++i) {
            GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(i);
            area.updateMinMax(gPoint2Df.x, gPoint2Df.y);
        }
    }

    @Override
    public Geometory getCopy() {
        return this.getCopy(new GPolyLine());
    }

    @Override
    protected Geometory getCopy(Geometory geometory) {
        if (geometory == null || !(geometory instanceof GPolyLine)) {
            return null;
        }
        GPolyLine gPolyLine = (GPolyLine)geometory;
        super.getCopy(gPolyLine);
        RefList refList = new RefList();
        for (int i = 0; i < this.mPoints.size(); ++i) {
            refList.addElement((Object)((GPoint2Df)((GPoint2Df)this.mPoints.elementAt(i)).getCopy()));
        }
        gPolyLine.mPoints = refList;
        gPolyLine.mType = this.mType;
        gPolyLine.mSmooth = this.mSmooth;
        gPolyLine.area.maximize();
        gPolyLine.updateMinMax(gPolyLine.area);
        return gPolyLine;
    }

    @Override
    public GPoint2Df getNearNode(float f, float f2) {
        float f3 = Float.MAX_VALUE;
        GPoint2Df gPoint2Df = null;
        for (int i = 0; i < this.mPoints.size(); ++i) {
            GPoint2Df gPoint2Df2 = (GPoint2Df)this.mPoints.elementAt(i);
            float f4 = (float)ToolMath.getLength2D(f, f2, gPoint2Df2.x, gPoint2Df2.y);
            if (!(f4 < f3)) continue;
            f3 = f4;
            gPoint2Df = gPoint2Df2;
        }
        return gPoint2Df;
    }

    @Override
    public float getDistanceToPoint(float f, float f2) {
        float f3 = Float.MAX_VALUE;
        for (int i = 0; i < this.mPoints.size() - 1; ++i) {
            GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(i);
            GPoint2Df gPoint2Df2 = (GPoint2Df)this.mPoints.elementAt(i + 1);
            float f4 = (float)ToolMath.getLengthLimitLineToPoint2D(f, f2, gPoint2Df.x, gPoint2Df.y, gPoint2Df2.x, gPoint2Df2.y);
            if (f4 < 0.0f || !(f4 < f3)) continue;
            f3 = f4;
        }
        return f3;
    }

    @Override
    public void offset(float f, float f2) {
        for (int i = 0; i < this.mPoints.size(); ++i) {
            ((GPoint2Df)this.mPoints.elementAt(i)).offset(f, f2);
        }
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    @Override
    public void rotate(float f, float f2, float f3) {
        for (int i = 0; i < this.mPoints.size(); ++i) {
            ((GPoint2Df)this.mPoints.elementAt(i)).rotate(f, f2, f3);
        }
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    @Override
    public boolean isInner(float f, float f2, float f3, float f4) {
        for (int i = 0; i < this.mPoints.size(); ++i) {
            GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(i);
            GPoint2Df gPoint2Df2 = i == this.mPoints.size() - 1 ? (GPoint2Df)this.mPoints.elementAt(0) : (GPoint2Df)this.mPoints.elementAt(i + 1);
            boolean bl = false;
            boolean bl2 = false;
            if (gPoint2Df.x > f && gPoint2Df.x < f3 && gPoint2Df.y > f2 && gPoint2Df.y < f4) {
                bl = true;
            }
            if (gPoint2Df2.x > f && gPoint2Df2.x < f3 && gPoint2Df2.y > f2 && gPoint2Df2.y < f4) {
                bl2 = true;
            }
            if (bl && bl2) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isInner(RefList<GPoint2Df> refList) {
        for (int i = 0; i < this.mPoints.size(); ++i) {
            GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(i);
            GPoint2Df gPoint2Df2 = i == this.mPoints.size() - 1 ? (GPoint2Df)this.mPoints.elementAt(0) : (GPoint2Df)this.mPoints.elementAt(i + 1);
            boolean bl = ToolPolygon.isInnerPolygon(refList, gPoint2Df.x, gPoint2Df.y);
            boolean bl2 = ToolPolygon.isInnerPolygon(refList, gPoint2Df2.x, gPoint2Df2.y);
            if (bl && bl2) continue;
            return false;
        }
        return true;
    }

    public RefList<GPoint2Df> getPoints() {
        return this.mPoints;
    }

    public static void readData(ObjectFolder objectFolder, Geometory geometory, GeomPerser geomPerser) throws Exception {
        GPolyLine gPolyLine = null;
        if (!(geometory instanceof GPolyLine)) {
            return;
        }
        Geometory.readData(objectFolder, geometory, geomPerser);
        gPolyLine = (GPolyLine)geometory;
        gPolyLine.mPoints = new RefList();
        int n = 0;
        ObjectNode objectNode = objectFolder.getNode("smooth");
        if (objectNode != null) {
            gPolyLine.mSmooth = Integer.valueOf((String)objectNode.getObject());
        }
        if ((objectNode = objectFolder.getNode("type")) != null) {
            gPolyLine.mType = Integer.valueOf((String)objectNode.getObject());
        }
        if ((objectNode = objectFolder.getNode("pointsize")) != null) {
            n = Integer.valueOf((String)objectNode.getObject());
        }
        for (int i = 0; i < n; ++i) {
            float f = 0.0f;
            float f2 = 0.0f;
            objectNode = objectFolder.getNode("x" + (i + 1));
            if (objectNode != null) {
                f = Float.valueOf((String)objectNode.getObject()).floatValue();
            }
            if ((objectNode = objectFolder.getNode("y" + (i + 1))) != null) {
                f2 = Float.valueOf((String)objectNode.getObject()).floatValue();
            }
            gPolyLine.mPoints.addElement((Object)new GPoint2Df(f, f2));
        }
    }

    @Override
    public void save(ObjectFolder objectFolder) {
        if (objectFolder == null) {
            return;
        }
        super.save(objectFolder);
        objectFolder.addChild(new ObjectNode("smooth", (Object)Integer.toString(this.mSmooth)));
        objectFolder.addChild(new ObjectNode("type", (Object)Integer.toString(this.mType)));
        objectFolder.addChild(new ObjectNode("pointsize", (Object)Integer.toString(this.mPoints.size())));
        for (int i = 0; i < this.mPoints.size(); ++i) {
            GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(i);
            objectFolder.addChild(new ObjectNode("x" + (i + 1), (Object)Float.toString(gPoint2Df.x)));
            objectFolder.addChild(new ObjectNode("y" + (i + 1), (Object)Float.toString(gPoint2Df.y)));
        }
    }

    @Override
    public void drawGeom(IRichGraphics iRichGraphics) {
        this.drawGeom(iRichGraphics, null, null);
    }

    @Override
    public void drawGeom(IRichGraphics iRichGraphics, Color color, Color color2) {
        if (color == null) {
            color = this.mGeomColor;
        }
        this.drawAbstDevice(iRichGraphics, color, color2, null);
    }

    @Override
    public void drawHighLight(IRichGraphics iRichGraphics, Color color, boolean bl) {
        if (bl) {
            iRichGraphics.setColor(color);
            iRichGraphics.drawPolyLine(this.mPoints, IRichGraphics.LINE_DASH_1);
        }
        for (int i = 0; i < this.mPoints.size(); ++i) {
            ((GPoint2Df)this.mPoints.elementAt(i)).drawHighLight(iRichGraphics, color, false);
        }
    }

    @Override
    public void drawAlias(IRichGraphics iRichGraphics, Color color, Color color2, LocalAxis2Df localAxis2Df) {
        if (color == null) {
            color = this.mGeomColor;
        }
        this.drawAbstDevice(iRichGraphics, color, color2, localAxis2Df);
    }

    @Override
    public void drawAbstDevice(IRichGraphics iRichGraphics, Color color, Color color2, LocalAxis2Df localAxis2Df) {
        RefList<GPoint2Df> refList = null;
        this._pbuf.removeAllElements();
        if (localAxis2Df != null) {
            for (int i = 0; i < this.mPoints.size(); ++i) {
                GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(i);
                this._pbuf.addElement((Object)new GPoint2Df(localAxis2Df.getGlobalX(gPoint2Df.x, gPoint2Df.y, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY), localAxis2Df.getGlobalY(gPoint2Df.x, gPoint2Df.y, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY)));
            }
            refList = this._pbuf;
        } else {
            refList = this.mPoints;
        }
        iRichGraphics.setColor(color);
        iRichGraphics.drawPolyLine(refList, null);
        this._pbuf.removeAllElements();
    }

    @Override
    public void flipx(float f, float f2) {
        for (int i = 0; i < this.mPoints.size(); ++i) {
            ((GPoint2Df)this.mPoints.elementAt(i)).flipx(f, f2);
        }
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    @Override
    public void flipy(float f, float f2) {
        for (int i = 0; i < this.mPoints.size(); ++i) {
            ((GPoint2Df)this.mPoints.elementAt(i)).flipy(f, f2);
        }
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    @Override
    public void rot(float f, float f2, float f3, float f4) {
        for (int i = 0; i < this.mPoints.size(); ++i) {
            ((GPoint2Df)this.mPoints.elementAt(i)).rot(f, f2, f3, f4);
        }
        this.area.maximize();
        this.updateMinMax(this.area);
    }
}

