/*
 * Decompiled with CFR 0.152.
 */
package nethome.geom;

import com.kt.io.AbstFile;
import com.kt.util.RefList;
import com.kt.util.tree.ObjectFolder;
import java.io.Serializable;
import java.util.StringTokenizer;
import nethome.doc.Document;
import nethome.geom.Ltype;
import nethome.geom.primitive.GLine;
import nethome.lib.Library;
import nethome.lib.ObjectLibrary;
import nethome.ui.MainRuntime;

public class HatchPattern
implements Serializable {
    public static final short MINMAXFIT = 0;
    public static final short INTERVALFIT = 1;
    public static final short SIZEDEPEND = 2;
    public static final short SUBTYPESIZE = 3;
    private String mName;
    private String[] mGroupName;
    public RefList<Float> mInfinityX;
    public RefList<Float> mInfinityY;
    public RefList<GLine> mLines;
    public float mDisplaySize;
    public float mCycleX;
    public float mCycleY;
    public float mMinX;
    public float mMaxX;
    public float mMinY;
    public float mMaxY;
    public short mFitPattern;
    public float mOffsetToInside = 0.0f;
    public boolean mFrameLine = false;
    public Ltype mLtype = null;
    private boolean mSmooth;
    private RefList mSubTypes;

    public HatchPattern(String[] stringArray) {
        this.mGroupName = stringArray;
        this.mMinY = Float.MAX_VALUE;
        this.mMinX = Float.MAX_VALUE;
        this.mMaxY = -3.4028235E38f;
        this.mMaxX = -3.4028235E38f;
        this.mInfinityX = new RefList();
        this.mInfinityY = new RefList();
        this.mLines = new RefList();
        this.mOffsetToInside = 0.0f;
        this.mFrameLine = false;
        this.mSmooth = false;
        this.mDisplaySize = -1.0f;
        this.mSubTypes = new RefList();
    }

    public static HatchPattern readData(AbstFile abstFile, Document document, float f) throws Exception {
        HatchPattern hatchPattern = null;
        String string = abstFile.readLineFromBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        String[] stringArray = null;
        ObjectLibrary objectLibrary = MainRuntime.getInstance().getLibrary("LIBHATCH");
        if (objectLibrary == null || !(objectLibrary instanceof Library)) {
            return null;
        }
        Library library = (Library)objectLibrary;
        if (stringTokenizer.countTokens() > 1) {
            stringArray = new String[stringTokenizer.countTokens()];
        }
        if (stringArray != null) {
            int n = 0;
            while (stringTokenizer.hasMoreElements()) {
                string = (String)stringTokenizer.nextElement();
                stringArray[n++] = string;
            }
            ObjectFolder objectFolder = library.getLibraryTree("hatch");
            for (int i = 0; !(i >= stringArray.length || objectFolder instanceof ObjectFolder && (objectFolder = objectFolder.getNode(stringArray[i])) == null); ++i) {
            }
            if (objectFolder != null) {
                hatchPattern = (HatchPattern)objectFolder.getObject();
            }
        }
        while ((string = abstFile.readLineFromBuffer()) != null && !string.trim().equalsIgnoreCase("</HATCH>")) {
        }
        return hatchPattern;
    }

    public void saveGeom(AbstFile abstFile, String string) throws Exception {
        String string2 = string + " ";
        abstFile.writeStringToBuffer(string + "<HATCH>\r\n");
        String[] stringArray = this.getGroupName();
        abstFile.writeStringToBuffer(string2);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                abstFile.writeStringToBuffer(stringArray[i] + ",");
            }
        }
        abstFile.writeStringToBuffer(this.getName() + "\r\n");
        abstFile.writeStringToBuffer(string + "</HATCH>\r\n");
    }

    public RefList getSubTypes() {
        return this.mSubTypes;
    }

    public void addSubType(int n, int n2, int n3, int n4) {
        int[] nArray = new int[]{n, n2, n3, n4};
        this.mSubTypes.addElement((Object)nArray);
    }

    public void addSubType2(float f, float f2, float f3, float f4) {
        float[] fArray = new float[]{f, f2, f3, f4};
        this.mSubTypes.addElement((Object)fArray);
    }

    public int[] getSubtype(int n, int n2) {
        for (int i = 0; i < this.mSubTypes.size(); ++i) {
            int[] nArray = (int[])this.mSubTypes.elementAt(i);
            if (nArray[0] != n || nArray[1] != n2) continue;
            return nArray;
        }
        return null;
    }

    public float[] getSubtype2(int n, int n2) {
        for (int i = 0; i < this.mSubTypes.size(); ++i) {
            float[] fArray = (float[])this.mSubTypes.elementAt(i);
            if (!(Math.abs(fArray[0] - (float)n) < 0.001f) || !(Math.abs(fArray[1] - (float)n2) < 0.001f)) continue;
            return fArray;
        }
        return null;
    }

    public void setGroup(String[] stringArray) {
        this.mGroupName = stringArray;
    }

    public String[] getGroupName() {
        return this.mGroupName;
    }

    public void setName(String string) {
        this.mName = string;
    }

    public String getName() {
        return this.mName;
    }

    public void setArea(float f) {
        this.mDisplaySize = f;
    }

    public float getArea() {
        return this.mDisplaySize;
    }

    public void setFitPattern(short s) {
        this.mFitPattern = s;
    }

    public void setCycle(float f, float f2) {
        this.mCycleX = f;
        this.mCycleY = f2;
    }

    public void setSmooth(boolean bl) {
        this.mSmooth = bl;
    }

    public boolean getSmooth() {
        return this.mSmooth;
    }

    public void setMinMax(float f, float f2, float f3, float f4) {
        this.mMinX = f;
        this.mMaxX = f3;
        this.mMinY = f2;
        this.mMaxY = f4;
    }

    public void addInfinityX(float f) {
        Float f2 = new Float(f);
        this.mInfinityX.addElement((Object)f2);
    }

    public void addInfinityY(float f) {
        Float f2 = new Float(f);
        this.mInfinityY.addElement((Object)f2);
    }

    public void addLine(float f, float f2, float f3, float f4) {
        this.mLines.addElement((Object)new GLine(f, f2, f3, f4));
    }

    public void addMinMaxLine() {
        this.mLines.addElement((Object)new GLine(this.mMinX, this.mMinY, this.mMaxX, this.mMinY));
        this.mLines.addElement((Object)new GLine(this.mMinX, this.mMinY, this.mMinX, this.mMaxY));
        this.mLines.addElement((Object)new GLine(this.mMinX, this.mMaxY, this.mMaxX, this.mMaxY));
        this.mLines.addElement((Object)new GLine(this.mMaxX, this.mMinY, this.mMaxX, this.mMaxY));
    }
}

