/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.font;

import java.io.IOException;
import option.io.pdfcommon.font.TTFTable;
import option.io.pdfcommon.font.TrueTypeFontFileReader;

public class NameTable
extends TTFTable {
    private int bn;
    private int bo;
    private int bp;
    private int[] bq;
    private int[] aV;
    private int[] br;
    private int[] bs;
    private int[] aX;
    private int[] offsets;
    private String[] names;
    public String copyRightNotice;
    public String familyName;
    public String subFamilyName;
    public String fullName;
    public String fontName;

    public void loadFontData(TrueTypeFontFileReader trueTypeFontFileReader) {
        try {
            trueTypeFontFileReader.seekTable(this);
            this.bn = trueTypeFontFileReader.readUInt16();
            this.bo = trueTypeFontFileReader.readUInt16();
            this.bp = trueTypeFontFileReader.readUInt16();
            this.bq = new int[this.bo];
            this.aV = new int[this.bo];
            this.br = new int[this.bo];
            this.bs = new int[this.bo];
            this.aX = new int[this.bo];
            this.offsets = new int[this.bo];
            this.names = new String[this.bo];
            long l = trueTypeFontFileReader.getFilePointer();
            block9: for (int i = 0; i < this.bo; ++i) {
                trueTypeFontFileReader.seek(l + (long)(i * 12));
                this.bq[i] = trueTypeFontFileReader.readUInt16();
                this.aV[i] = trueTypeFontFileReader.readUInt16();
                this.br[i] = trueTypeFontFileReader.readUInt16();
                this.bs[i] = trueTypeFontFileReader.readUInt16();
                this.aX[i] = trueTypeFontFileReader.readUInt16();
                this.offsets[i] = trueTypeFontFileReader.readUInt16();
                trueTypeFontFileReader.seek(this.offset + (long)this.bp + (long)this.offsets[i]);
                if (this.bq[i] == 1) {
                    this.names[i] = trueTypeFontFileReader.readByteString(this.aX[i]);
                } else if (this.bq[i] == 3) {
                    this.names[i] = trueTypeFontFileReader.readChars(this.aX[i] / 2);
                }
                switch (this.bs[i]) {
                    case 0: {
                        this.copyRightNotice = this.names[i];
                        continue block9;
                    }
                    case 1: {
                        this.familyName = this.names[i];
                        continue block9;
                    }
                    case 2: {
                        this.subFamilyName = this.names[i];
                        continue block9;
                    }
                    case 4: {
                        this.fullName = this.names[i];
                        continue block9;
                    }
                    case 6: {
                        this.fontName = this.names[i];
                    }
                }
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public final String toString() {
        String string = "[  copyRightNotice: " + this.copyRightNotice + "\n" + "  familyName: " + this.familyName + "\n" + "  subFamilyName: " + this.subFamilyName + "\n" + "  fullName: " + this.fullName + "\n" + "  fontName: " + this.fontName + "  ]";
        return string;
    }

    public String getCopyRightNotice() {
        return this.copyRightNotice;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public String getFontName() {
        return this.fontName;
    }

    public int getFormat() {
        return this.bn;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getSubFamilyName() {
        return this.subFamilyName;
    }
}

