/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.searches.cubicsearch;

import jp.kitec.math.searches.cubicsearch.APoint;
import jp.kitec.math.searches.cubicsearch.PointsSupplier;

public class CubicSearchNode {
    private float centerX;
    private float centerY;
    private float centerZ;
    private float radius;

    public CubicSearchNode(PointsSupplier pointsSupplier) {
        APoint aPoint = null;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n = 0;
        aPoint = pointsSupplier.getFirst();
        while (aPoint != null) {
            d += (double)aPoint.x;
            d2 += (double)aPoint.y;
            d3 += (double)aPoint.z;
            aPoint = pointsSupplier.getNext();
            ++n;
        }
        this.centerX = (float)(d / (double)n);
        this.centerY = (float)(d2 / (double)n);
        this.centerZ = (float)(d3 / (double)n);
        this.radius = 0.0f;
        aPoint = pointsSupplier.getFirst();
        while (aPoint != null) {
            d = aPoint.x - this.centerX;
            d2 = aPoint.y - this.centerY;
            d3 = aPoint.z - this.centerZ;
            double d4 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
            if (d4 > (double)this.radius) {
                this.radius = (float)d4;
            }
            aPoint = pointsSupplier.getNext();
            ++n;
        }
    }

    public boolean isOverlap(CubicSearchNode cubicSearchNode, float f, float f2, float f3) {
        float f4 = this.centerX - f;
        float f5 = this.centerY - f2;
        float f6 = this.centerZ - f3;
        double d = Math.sqrt(f4 * f4 + f5 * f5 + f6 * f6);
        f4 = cubicSearchNode.centerX - f;
        f5 = cubicSearchNode.centerY - f2;
        f6 = cubicSearchNode.centerZ - f3;
        double d2 = Math.sqrt(f4 * f4 + f5 * f5 + f6 * f6);
        f4 = this.centerX - cubicSearchNode.centerX;
        f5 = this.centerY - cubicSearchNode.centerY;
        f6 = this.centerZ - cubicSearchNode.centerZ;
        double d3 = this.centerX * cubicSearchNode.centerX + this.centerY * cubicSearchNode.centerY + this.centerZ * cubicSearchNode.centerZ;
        double d4 = d3 / (d * d2);
        double d5 = Math.sqrt(1.0 - d4 * d4);
        if (d4 < 0.0) {
            d5 += 1.0;
        }
        return (double)this.radius / d + (double)cubicSearchNode.radius / d2 > d5;
    }
}

