/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.geom.datapassing.complete;

import java.io.Serializable;
import jp.kitec.math.geom.ToolGeom2D;
import jp.kitec.math.geom.datapassing.ToolFigure2DArc;
import jp.kitec.math.geom.datapassing.ToolPolyline2D;
import jp.kitec.math.geom.datapassing.complete.ToolFigure;

public class ToolArc
extends ToolFigure
implements Serializable,
ToolFigure2DArc {
    private double xc;
    private double yc = Double.MAX_VALUE;
    private double radius = -1.0;

    public ToolArc(ToolPolyline2D toolPolyline2D, int n) {
        super(toolPolyline2D, n);
        this.xc = Double.MAX_VALUE;
    }

    public double getCX() {
        return this.xc;
    }

    public double getCY() {
        return this.yc;
    }

    public double getRadius() {
        return this.radius;
    }

    public boolean isCw() {
        return this.type == 2;
    }

    public void setCX(double d) {
        this.parent.setChangedFlag();
        this.xc = d;
    }

    public void setCY(double d) {
        this.parent.setChangedFlag();
        this.yc = d;
    }

    public void setCw(boolean bl) {
        this.parent.setChangedFlag();
        this.type = (byte)(bl ? 2 : 3);
    }

    public void setRadius(double d) {
        this.parent.setChangedFlag();
        this.radius = d;
        this.adjustArc();
    }

    private boolean adjustArc() {
        if (this.xc != Double.MAX_VALUE && this.yc != Double.MAX_VALUE && this.getX1() != Double.MAX_VALUE && this.getY1() != Double.MAX_VALUE && this.x != Double.MAX_VALUE && this.y != Double.MAX_VALUE) {
            double d;
            double d2 = ToolGeom2D.getDistance(this.getX1(), this.getY1(), this.xc, this.yc);
            if (ToolGeom2D.compareDistance(d2, d = ToolGeom2D.getDistance(this.getX2(), this.getY2(), this.xc, this.yc)) != 0) {
                double d3 = (this.getX1() + this.getX2()) / 2.0;
                double d4 = (this.getY1() + this.getY2()) / 2.0;
                double d5 = this.getX2() - this.getX1();
                double d6 = this.getY2() - this.getY1();
                double d7 = ToolGeom2D.getDistance(this.getX1(), this.getY1(), this.getX2(), this.getY2());
                byte by = ToolGeom2D.getSideOfPointWithLine(this.xc, this.yc, this.getX1(), this.getY1(), this.getX2(), this.getY2());
                double d8 = by == 1 ? d6 : -(d6 *= this.radius / d7);
                double d9 = by == 1 ? -d5 : (d5 *= this.radius / d7);
            } else if (ToolGeom2D.compare(d2, this.radius) != 0) {
                this.radius = (d2 + d) / 2.0;
            }
            return true;
        }
        return false;
    }
}

