/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.richui.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.TextField;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import jp.kitec.richui.table.Cell;
import jp.kitec.richui.table.CellClickAction;
import jp.kitec.richui.table.CellGroup;
import jp.kitec.richui.table.CellType;
import jp.kitec.richui.table.ITableKeyListener;

public class Table
extends JPanel {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    protected static final int CELL_HINSET = 3;
    protected static final int CELL_VINSET = 2;
    protected static final int SIZE_SCROLLBAR = 15;
    protected static final Color COLOR_TABLE_BORDER = new Color(99, 101, 99);
    protected static final Color COLOR_TABLE_BACKGROUND = Color.white;
    protected static final Color COLOR_BUTTON_BACKGROUND = new Color(0.8f, 1.0f, 1.0f);
    protected static final Color COLOR_HEADER_BACKGROUND = new Color(214, 211, 206);
    protected static final Color COLOR_HEADER_LTBACKGROUND = Color.white;
    protected static final Color COLOR_HEADER_TEXT = Color.black;
    protected static final Color COLOR_CELL_BORDER = new Color(156, 154, 156);
    protected static final Color COLOR_CELL_TEXT = Color.black;
    protected static final Color COLOR_SELECTED_ROW = new Color(206, 207, 255);
    protected static final Font DEF_FONT = new Font("Monospaced", 0, 14);
    protected static final Color COLOR_ENABLEDTABLE_BACKGROUND = COLOR_HEADER_BACKGROUND;
    protected int[][] unremovableCellType;
    protected AdjustmentListener mLsnScrollbar;
    protected MouseListener mLsnMouseClick;
    protected MouseMotionListener mLsnMouseDrag;
    protected MouseWheelListener mLsnMouseWheel;
    protected EditorKeyListener mLsnEditorKey;
    protected Dimension mMinimumSize;
    protected Font mFont;
    protected FontMetrics mFontMetrics;
    protected Graphics mOffGraphics;
    protected Image mOffImage;
    protected int mTableWidth;
    protected int mTableHeight;
    protected int mRowHeaderWidth;
    protected int mRowHeight;
    protected int mFirstRow;
    protected int mTotalColumnWidth;
    protected int mHScrollValue;
    protected int mVScrollValue;
    protected List<CellGroup> mCells;
    protected CellGroup mRowHeaders;
    protected CellGroup mColumnHeaders;
    protected int[] mColumnWidths;
    protected int mColumnCount;
    protected int mRowCount;
    protected JScrollBar mSrlHorizontal;
    protected JScrollBar mSrlVertical;
    protected int mHScrollbarWidth;
    protected int mVScrollbarHeight;
    protected int mDraggedX;
    protected int mDraggedColumn;
    protected TextField mEditor;
    protected int mEditorX;
    protected int mEditorY;
    protected int mEditorWidth;
    protected int mSelectedRow;
    protected int mSelectedColumn;
    protected boolean mAutoResizeColumnWidth = true;
    protected boolean mIsResized;
    protected int[] mColumnAlignments;
    protected boolean[] mIsColumnEditables;
    protected boolean mIsRowHeaderShown = true;
    protected ITableKeyListener mKeyHandler = null;
    protected int mHandleRow;
    protected int mHandleCol;
    protected int mHandleKey;

    public void addKeyHandler(int n, int n2, int n3, ITableKeyListener iTableKeyListener) {
        this.mHandleRow = n2;
        this.mHandleCol = n;
        this.mHandleKey = n3;
        this.mKeyHandler = iTableKeyListener;
    }

    public Table() {
        this(true);
    }

    public Table(int[][] nArray) {
        this();
        this.unremovableCellType = nArray;
    }

    public Table(boolean bl) {
        this.setLayout(null);
        this.mSelectedRow = -1;
        this.setFont(DEF_FONT);
        this.unremovableCellType = null;
        this.add(this.createEditor());
        if (bl) {
            this.addScrollbar();
        }
        this.addMouseEventListener();
    }

    public void init() {
        this.mColumnHeaders.removeAllCells();
        this.mCells.clear();
        this.mRowHeaders.removeAllCells();
        this.mTableWidth = 0;
        this.mTableHeight = 0;
        this.mRowHeaderWidth = 0;
        this.mRowHeight = 0;
        this.mFirstRow = 0;
        this.mTotalColumnWidth = 0;
        this.mHScrollValue = 0;
        this.mVScrollValue = 0;
        this.mColumnWidths = null;
        this.mColumnCount = 0;
        this.mRowCount = 0;
        this.mHScrollbarWidth = 0;
        this.mVScrollbarHeight = 0;
        this.mDraggedX = 0;
        this.mDraggedColumn = 0;
        this.mEditorX = 0;
        this.mEditorY = 0;
        this.mEditorWidth = 0;
        this.mSelectedRow = -1;
        this.mSelectedColumn = -1;
        this.mAutoResizeColumnWidth = true;
        this.mIsResized = true;
        this.mColumnAlignments = null;
        this.mIsColumnEditables = null;
        if (this.mSrlHorizontal != null) {
            this.mSrlHorizontal.setValue(0);
        }
        if (this.mSrlVertical != null) {
            this.mSrlVertical.setValue(0);
        }
    }

    protected Component createEditor() {
        this.mEditor = new TextField();
        this.mLsnEditorKey = new EditorKeyListener();
        this.mEditor.addKeyListener(this.mLsnEditorKey);
        this.mEditor.setFont(this.getFont());
        this.mEditor.addFocusListener(new EditorFocusListener());
        return this.mEditor;
    }

    protected void addScrollbar() {
        this.mSrlHorizontal = new JScrollBar(0);
        this.add(this.mSrlHorizontal);
        this.mSrlVertical = new JScrollBar(1);
        this.add(this.mSrlVertical);
        this.mLsnScrollbar = new AdjustmentListenerImpl();
        this.mSrlHorizontal.addAdjustmentListener(this.mLsnScrollbar);
        this.mSrlVertical.addAdjustmentListener(this.mLsnScrollbar);
    }

    protected void addMouseEventListener() {
        this.mLsnMouseClick = new MouseListenerImpl();
        this.addMouseListener(this.mLsnMouseClick);
        this.mLsnMouseDrag = new MouseMotionListenerImpl();
        this.addMouseMotionListener(this.mLsnMouseDrag);
        this.mLsnMouseWheel = new MouseWheelListenerImpl();
        this.addMouseWheelListener(this.mLsnMouseWheel);
    }

    public void dispose() {
        this.disposeOffImage();
        this.mColumnHeaders.removeAllCells();
        this.mColumnHeaders = null;
        this.mCells.clear();
        this.mCells = null;
        this.mRowHeaders.removeAllCells();
        this.mRowHeaders = null;
        this.mColumnWidths = null;
        this.mFontMetrics = null;
        this.mColumnAlignments = null;
        this.mIsColumnEditables = null;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.repaint();
    }

    public Color getTableBackgoundColor() {
        return this.getTableBackgoundColor(CellType.TEXT_FIELD);
    }

    public Color getTableBackgoundColor(int n) {
        if (n == CellType.BUTTON) {
            return this.isEnabled() ? COLOR_BUTTON_BACKGROUND : COLOR_ENABLEDTABLE_BACKGROUND;
        }
        return this.isEnabled() ? COLOR_TABLE_BACKGROUND : COLOR_ENABLEDTABLE_BACKGROUND;
    }

    protected void disposeOffImage() {
        if (this.mOffGraphics != null) {
            this.mOffGraphics.dispose();
            this.mOffGraphics = null;
        }
        if (this.mOffImage != null) {
            this.mOffImage.flush();
            this.mOffImage = null;
        }
    }

    public void setFont(Font font) {
        this.mFont = font;
        this.mFontMetrics = null;
        this.mIsResized = true;
        this.mRowHeight = 0;
        this.repaint();
    }

    public Font getFont() {
        if (this.mFont == null) {
            return super.getFont();
        }
        return new Font(this.mFont.getName(), this.mFont.getStyle(), this.mFont.getSize());
    }

    protected boolean isDragged() {
        return this.getCursor().getType() == 11;
    }

    protected void setDragged(boolean bl) {
        if (bl) {
            this.setCursor(new Cursor(11));
        } else {
            this.setCursor(new Cursor(0));
            this.mDraggedColumn = -1;
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        int n5;
        super.setBounds(n, n2, n3, n4);
        if (this.mSrlHorizontal != null) {
            this.mVScrollbarHeight = this.mSrlHorizontal.getPreferredSize().height;
        }
        if (this.mSrlVertical != null) {
            this.mHScrollbarWidth = this.mSrlVertical.getPreferredSize().width;
        }
        if (this.mVScrollbarHeight == 0) {
            this.mVScrollbarHeight = 15;
        }
        if (this.mHScrollbarWidth == 0) {
            this.mHScrollbarWidth = 15;
        }
        if ((n5 = n3 - this.mHScrollbarWidth) != this.mTableWidth) {
            this.calculateAllColumnWidths();
            this.adjustScroll();
            this.mTableWidth = n5;
        }
        this.mTableHeight = n4 - this.mVScrollbarHeight;
        if (this.mSrlHorizontal != null) {
            this.mSrlHorizontal.setBounds(0, this.mTableHeight, this.mTableWidth, this.mVScrollbarHeight);
        }
        if (this.mSrlVertical != null) {
            this.mSrlVertical.setBounds(this.mTableWidth, 0, this.mHScrollbarWidth, this.mTableHeight);
        }
        this.adjustScroll();
        this.mIsResized = true;
        this.setEditor();
        this.repaint();
    }

    public void setColumnHeader(String[] stringArray) {
        this.mCells = new ArrayList<CellGroup>();
        this.mRowHeaders = new CellGroup();
        this.mColumnCount = stringArray.length;
        this.mColumnHeaders = new CellGroup(stringArray);
        this.mColumnWidths = new int[this.mColumnCount];
        this.mColumnAlignments = new int[this.mColumnCount];
        this.mIsColumnEditables = new boolean[this.mColumnCount];
        for (int i = 0; i < this.mColumnCount; ++i) {
            this.mColumnWidths[i] = 100;
            this.mColumnAlignments[i] = 0;
            this.mIsColumnEditables[i] = false;
        }
        this.mRowCount = 0;
    }

    public String getColumnHeader(int n) {
        return this.mColumnHeaders.getCell(n).getValue();
    }

    public int getRowCount() {
        return this.mRowCount;
    }

    public int getColumnCount() {
        return this.mColumnCount;
    }

    public void addRow(String string, String[] stringArray) {
        if (stringArray.length != this.mColumnCount) {
            return;
        }
        this.mRowHeaders.addCell(string);
        CellGroup cellGroup = new CellGroup();
        for (int i = 0; i < this.mColumnCount; ++i) {
            cellGroup.addCell(new Cell("" + stringArray[i], this.mColumnAlignments[i], this.mIsColumnEditables[i]));
        }
        this.mCells.add(cellGroup);
        ++this.mRowCount;
        this.calculateAllColumnWidths();
        this.adjustScroll();
        this.repaint();
    }

    public void addRow(String[] stringArray) {
        this.addRow("" + (this.mRowCount + 1), stringArray);
    }

    public void insertRow(String[] stringArray, int n) {
        this.insertRow("" + (this.mRowCount + 1), stringArray, n);
    }

    public void insertRow(String[] stringArray, int[] nArray, CellClickAction[] cellClickActionArray, int n) {
        this.insertRow("" + (this.mRowCount + 1), stringArray, nArray, cellClickActionArray, n);
    }

    public void insertRow(String[] stringArray, int n, int n2) {
        this.insertRow("" + (this.mRowCount + 1), stringArray, n, n2);
    }

    public void insertRow(String[] stringArray, int n, int n2, boolean[] blArray) {
        this.insertRow("" + (this.mRowCount + 1), stringArray, n, n2, blArray);
    }

    public void insertRow(String string, String[] stringArray, int n, int n2) {
        this.insertRow(string, stringArray, n, n2, this.mIsColumnEditables);
    }

    public void insertRow(String string, String[] stringArray, int n, int n2, boolean[] blArray) {
        if (stringArray.length != this.mColumnCount) {
            return;
        }
        this.mRowHeaders.addCell(string);
        CellGroup cellGroup = new CellGroup();
        cellGroup.setType(n2);
        for (int i = 0; i < this.mColumnCount; ++i) {
            cellGroup.addCell(new Cell("" + stringArray[i], this.mColumnAlignments[i], blArray[i]));
        }
        this.mCells.add(n, cellGroup);
        ++this.mRowCount;
        this.calculateAllColumnWidths();
        this.adjustScroll();
        this.selectRow(n);
    }

    public void insertRow(String string, String[] stringArray, int n) {
        if (stringArray.length != this.mColumnCount) {
            return;
        }
        this.mRowHeaders.addCell(string);
        CellGroup cellGroup = new CellGroup();
        for (int i = 0; i < this.mColumnCount; ++i) {
            cellGroup.addCell(new Cell("" + stringArray[i], this.mColumnAlignments[i], this.mIsColumnEditables[i]));
        }
        this.mCells.add(n, cellGroup);
        ++this.mRowCount;
        this.calculateAllColumnWidths();
        this.adjustScroll();
        this.selectRow(n);
    }

    public void insertRow(String string, String[] stringArray, int[] nArray, CellClickAction[] cellClickActionArray, int n) {
        if (stringArray.length != this.mColumnCount) {
            return;
        }
        this.mRowHeaders.addCell(string);
        CellGroup cellGroup = new CellGroup();
        for (int i = 0; i < this.mColumnCount; ++i) {
            cellGroup.addCell(new Cell("" + stringArray[i], this.mColumnAlignments[i], nArray[i], cellClickActionArray[i], this.mIsColumnEditables[i]));
        }
        this.mCells.add(n, cellGroup);
        ++this.mRowCount;
        this.calculateAllColumnWidths();
        this.adjustScroll();
        this.selectRow(n);
    }

    public String getValueAt(int n, int n2) {
        return this.getCell(n, n2).getValue();
    }

    public int getRowTypeAt(int n) {
        return this.getRow(n).getType();
    }

    public void setRowTypeAt(int n, int n2) {
        this.getRow(n).setType(n2);
    }

    protected Cell getCell(int n, int n2) {
        return this.getRow(n).getCell(n2);
    }

    public CellGroup getRow(int n) {
        return this.mCells.get(n);
    }

    public void setValueAt(int n, int n2, String string) {
        this.getCell(n, n2).setValue(string);
    }

    public void removeAll() {
        this.mRowCount = 0;
        this.mCells.clear();
        this.calculateAllColumnWidths();
        this.mRowHeaders.removeAllCells();
        this.mFirstRow = 0;
        this.mHScrollValue = 0;
        this.mVScrollValue = 0;
        this.mRowCount = 0;
        this.mDraggedX = 0;
        this.mDraggedColumn = 0;
        this.mEditorX = 0;
        this.mEditorY = 0;
        this.mEditorWidth = 0;
        this.mSelectedRow = -1;
        this.mSelectedColumn = -1;
        if (this.mSrlHorizontal != null) {
            this.mSrlHorizontal.setValue(0);
        }
        if (this.mSrlVertical != null) {
            this.mSrlVertical.setValue(0);
        }
    }

    public void removeRow(int n) {
        if (this.mSelectedRow >= 0) {
            this.clearSelection();
        }
        if (this.unremovableCellType != null) {
            CellGroup cellGroup = this.mCells.get(n);
            for (int i = 0; i < this.unremovableCellType.length; ++i) {
                int[] nArray = this.unremovableCellType[i];
                if (nArray.length == 1 && cellGroup.getType() == nArray[0]) {
                    return;
                }
                if (nArray.length != 2 || cellGroup.getType() < nArray[0] || cellGroup.getType() > nArray[1]) continue;
                return;
            }
        }
        this.mCells.remove(n);
        --this.mRowCount;
        this.renumberRowHeaders();
        this.calculateAllColumnWidths();
        this.adjustScroll();
        this.selectRow(this.mRowCount <= n ? this.mRowCount - 1 : n);
    }

    public void removeColumn(int n) {
        int n2;
        int n3 = this.mSelectedRow;
        if (this.mSelectedRow >= 0) {
            this.clearSelection();
        }
        for (n2 = 0; n2 < this.mRowCount; ++n2) {
            CellGroup cellGroup = this.getRow(n2);
            cellGroup.removeCell(n);
        }
        this.mColumnHeaders.removeCell(n);
        n2 = this.mColumnCount - 1;
        boolean[] blArray = new boolean[n2];
        int[] nArray = new int[n2];
        this.mColumnWidths = new int[n2];
        int n4 = 0;
        for (int i = 0; i < this.mColumnCount; ++i) {
            if (i == n) continue;
            blArray[n4] = this.mIsColumnEditables[i];
            nArray[n4] = this.mColumnAlignments[i];
            this.mColumnWidths[n4] = 100;
            ++n4;
        }
        this.mIsColumnEditables = blArray;
        this.mColumnAlignments = this.mColumnWidths;
        --this.mColumnCount;
        this.calculateAllColumnWidths();
        this.adjustScroll();
        this.selectRow(n3);
    }

    protected void renumberRowHeaders() {
        this.mRowHeaders.removeAllCells();
        for (int i = 1; i <= this.mRowCount; ++i) {
            this.mRowHeaders.addCell("" + i);
        }
    }

    public void setRowIdentify(int n, int n2) {
        this.getRow(n).setIdentify(n2);
    }

    public boolean isEditable(int n, int n2) {
        return this.getCell(n, n2).isEditable();
    }

    public void setEditable(int n, int n2, boolean bl) {
        this.getCell(n, n2).setEditable(bl);
    }

    public void setRowEditable(int n, boolean bl) {
        for (int i = 0; i < this.mColumnCount; ++i) {
            this.setEditable(n, i, bl);
        }
    }

    public void setColumnEditable(int n, boolean bl) {
        if (this.mRowCount <= 0) {
            this.mIsColumnEditables[n] = bl;
        } else {
            for (int i = 0; i < this.mRowCount; ++i) {
                this.setEditable(i, n, bl);
            }
        }
    }

    public void setTableEditable(boolean bl) {
        for (int i = 0; i < this.mColumnCount; ++i) {
            this.setColumnEditable(i, bl);
        }
    }

    public void setAlignment(int n, int n2, int n3) {
        this.getCell(n, n2).setAlignment(n3);
    }

    public void setRowAlignment(int n, int n2) {
        for (int i = 0; i < this.mColumnCount; ++i) {
            this.setAlignment(n, i, n2);
        }
    }

    public void setColumnAlignment(int n, int n2) {
        if (this.mRowCount <= 0) {
            this.mColumnAlignments[n] = n2;
        } else {
            for (int i = 0; i < this.mRowCount; ++i) {
                this.setAlignment(i, n, n2);
            }
        }
    }

    public int getAlignment(int n, int n2) {
        return this.getCell(n, n2).getAlignment();
    }

    public void setColumnWidth(int n, int n2) {
        this.mColumnWidths[n] = n2;
    }

    public int getColumnWidth(int n) {
        return this.mColumnWidths[n];
    }

    public int getSelectedRow() {
        return this.mSelectedRow;
    }

    public int getSelectedColumn() {
        return this.mSelectedColumn;
    }

    public void select(int n, int n2) {
        if (this.mSelectedRow >= 0 && this.mSelectedRow < this.mRowCount && this.mSelectedColumn >= 0 && this.mSelectedColumn < this.mColumnCount) {
            this.setValueAt(this.mSelectedRow, this.mSelectedColumn, this.mEditor.getText());
        }
        this.mSelectedRow = n;
        this.mSelectedColumn = n2;
        if (n < 0 || n >= this.mRowCount || n2 < 0 || n2 >= this.mColumnCount) {
            this.mSelectedRow = -1;
            this.mSelectedColumn = 0;
        }
        this.mEditor.setVisible(false);
        if (this.mSelectedRow >= 0) {
            while (this.mSelectedRow < this.mFirstRow && this.mFirstRow > 0) {
                --this.mFirstRow;
                this.mVScrollValue -= this.mRowHeight;
            }
            while (this.mSelectedRow > this.mFirstRow - 2 + this.mTableHeight / this.mRowHeight && this.mFirstRow < this.mRowCount - 1) {
                ++this.mFirstRow;
                this.mVScrollValue += this.mRowHeight;
            }
            this.calculateEditotPosition();
            if (this.mEditorX > this.mTableWidth) {
                this.mHScrollValue += this.mEditorX - this.mTableWidth;
                this.calculateEditotPosition();
            }
            if (this.mEditorX + this.mEditorWidth > this.mTableWidth) {
                this.mHScrollValue += this.mEditorX + this.mEditorWidth - this.mTableWidth;
                this.calculateEditotPosition();
            }
            if (this.mEditorX < this.mRowHeaderWidth) {
                this.mHScrollValue += this.mEditorX - this.mRowHeaderWidth;
                this.calculateEditotPosition();
            }
            this.mEditor.setText(this.getValueAt(this.mSelectedRow, this.mSelectedColumn));
            this.adjustScroll();
        }
        this.repaint();
    }

    public boolean checkAfterFocusLost(int n, int n2) {
        return false;
    }

    public void selectRow(int n) {
        this.mSelectedColumn = -1;
        this.mEditor.setVisible(false);
        this.mEditorWidth = 0;
        this.mSelectedRow = n;
        this.repaint();
    }

    public void selectColumn(int n) {
        this.mSelectedColumn = n;
        this.mEditor.setVisible(false);
        this.mEditorWidth = 0;
        this.repaint();
    }

    public void clearSelection() {
        this.select(-1, 0);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        if (this.mMinimumSize == null) {
            this.setMinimumSize(new Dimension(this.mTableWidth + this.mRowHeaderWidth + this.mHScrollbarWidth + 2, this.mTableHeight + this.mVScrollbarHeight));
        }
        return this.mMinimumSize;
    }

    public void setMinimumSize(Dimension dimension) {
        this.mMinimumSize = dimension;
    }

    public void setAutoResizeColumnWidth(boolean bl) {
        this.mAutoResizeColumnWidth = bl;
    }

    public boolean isAutoResizeColumnWidth() {
        return this.mAutoResizeColumnWidth;
    }

    public void showRowHeader() {
        this.mIsRowHeaderShown = true;
    }

    public void hideRowHeader() {
        this.mIsRowHeaderShown = false;
        this.mRowHeaderWidth = 0;
    }

    protected void adjustScroll() {
        if (this.mRowHeight == 0) {
            return;
        }
        if (this.mSrlHorizontal != null) {
            this.adjustHorizontalScroll();
        }
        if (this.mSrlVertical != null) {
            this.adjustVerticalScroll();
        }
    }

    protected void adjustHorizontalScroll() {
        this.mTotalColumnWidth = 0;
        for (int i = 0; i < this.mColumnCount; ++i) {
            this.mTotalColumnWidth += this.mColumnWidths[i];
        }
        if (this.mTotalColumnWidth + this.mRowHeaderWidth - this.mTableWidth < 0) {
            this.mSrlHorizontal.setEnabled(false);
            this.mSrlHorizontal.setValue(0);
        } else {
            this.mSrlHorizontal.setEnabled(true);
            this.mSrlHorizontal.setValues(this.mHScrollValue, this.mTableWidth, 0, this.mTotalColumnWidth + this.mRowHeaderWidth);
        }
        this.mHScrollValue = this.mSrlHorizontal.getValue();
    }

    protected void adjustVerticalScroll() {
        int n = this.mTableHeight / this.mRowHeight;
        if (this.mRowCount - n < 0) {
            this.mSrlVertical.setEnabled(false);
            this.mSrlVertical.setValue(0);
        } else {
            this.mSrlVertical.setEnabled(true);
            this.mSrlVertical.setValues(this.mVScrollValue / this.mRowHeight, n, 0, this.mRowCount + 1);
        }
        this.mVScrollValue = this.mSrlVertical.getValue() * this.mRowHeight;
    }

    protected void calculateAllColumnWidths() {
        if (this.mAutoResizeColumnWidth) {
            for (int i = 0; i < this.mColumnCount; ++i) {
                this.calculateColumnWidth(i);
            }
        }
        if (this.mIsRowHeaderShown) {
            this.calculateRowHeaderWidth();
        }
        if (this.mAutoResizeColumnWidth || this.mIsRowHeaderShown) {
            this.adjustAllColumnWidths();
        }
    }

    protected void calculateColumnWidth(int n) {
        if (this.mFontMetrics == null) {
            return;
        }
        int n2 = 10;
        n2 = Math.max(n2, this.mFontMetrics.stringWidth(this.mColumnHeaders.getCell(n).getValue()));
        for (int i = 0; i < this.mRowCount; ++i) {
            n2 = Math.max(n2, this.mFontMetrics.stringWidth(this.getValueAt(i, n)));
        }
        this.mColumnWidths[n] = n2 + 6;
    }

    protected void calculateRowHeaderWidth() {
        if (this.mFontMetrics == null) {
            return;
        }
        this.mRowHeaderWidth = 0;
        for (int i = 0; i < this.mRowCount; ++i) {
            this.mRowHeaderWidth = Math.max(this.mRowHeaderWidth, this.mFontMetrics.stringWidth(this.mRowHeaders.getCell(i).getValue()) + 6);
        }
    }

    protected void adjustAllColumnWidths() {
        int n;
        int n2;
        if (this.mColumnCount <= 0) {
            return;
        }
        Dimension dimension = this.getSize();
        int n3 = this.mRowHeaderWidth - this.mHScrollValue + this.mHScrollbarWidth;
        for (n2 = 0; n2 < this.mColumnCount; ++n2) {
            n3 += this.mColumnWidths[n2];
        }
        n2 = (int)Math.floor((double)(dimension.width - n3) / (double)this.mColumnCount);
        for (n = 0; n < this.mColumnCount; ++n) {
            if (this.mColumnWidths[n] + n2 > 0) continue;
            return;
        }
        n = 0;
        while (n < this.mColumnCount) {
            int n4 = n++;
            this.mColumnWidths[n4] = this.mColumnWidths[n4] + n2;
        }
    }

    protected void calculateEditotPosition() {
        if (this.mSelectedColumn == -1) {
            return;
        }
        int n = -this.mHScrollValue;
        for (int i = 0; i < this.mSelectedColumn; ++i) {
            int n2 = this.mColumnWidths[i];
            n += n2;
        }
        this.mEditorX = n + this.mRowHeaderWidth;
        this.mEditorY = (this.mSelectedRow - this.mFirstRow + 1) * this.mRowHeight;
        this.mEditorWidth = 0;
        if (this.mColumnWidths != null) {
            this.mEditorWidth = this.mColumnWidths[this.mSelectedColumn];
        }
    }

    protected void setEditor() {
        this.calculateEditotPosition();
        int n = this.mEditorX;
        int n2 = this.mEditorY;
        int n3 = this.mEditorWidth;
        n3 = Math.min(n3, this.mTableWidth - n);
        if (n < 0) {
            n3 += n;
            n = 0;
        }
        if (this.mSelectedRow >= 0 && n3 > 0 && n2 >= this.mRowHeight && n2 < this.mTableHeight - this.mRowHeight) {
            if (this.isEditable(this.mSelectedRow, this.mSelectedColumn)) {
                this.mEditor.setBounds(n, n2, n3, this.mRowHeight);
                if (!this.mEditor.isVisible()) {
                    this.mEditor.setVisible(true);
                    this.mEditor.requestFocus();
                    this.mEditor.selectAll();
                }
            } else {
                this.mEditor.setVisible(false);
            }
        } else if (this.mEditor.isVisible()) {
            this.mEditor.setVisible(false);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (graphics == null) {
            return;
        }
        if (this.mTableWidth <= 0 || this.mTableHeight <= 0) {
            return;
        }
        this.createOffImage();
        if (this.mRowHeight == 0) {
            this.mRowHeight = (int)((double)this.mFont.getSize() * 1.25) + 2;
            this.calculateAllColumnWidths();
            this.adjustScroll();
        }
        this.drawTableBackground(this.mOffGraphics);
        this.drawColumnHeader(this.mOffGraphics);
        this.drawRows(this.mOffGraphics);
        this.drawTableAround(this.mOffGraphics);
        if (this.mSrlHorizontal != null && this.mSrlVertical != null) {
            this.drawScrollbarIntersection(graphics);
        }
        graphics.drawImage(this.mOffImage, 0, 0, this);
        this.setEditor();
        this.disposeOffImage();
    }

    protected void createOffImage() {
        if (this.mOffImage == null || this.mIsResized) {
            this.disposeOffImage();
            this.mOffImage = this.createImage(this.mTableWidth, this.mTableHeight);
            this.mOffGraphics = this.mOffImage.getGraphics();
            this.mOffGraphics.setFont(this.mFont);
            if (this.mFontMetrics == null) {
                this.mFontMetrics = this.mOffGraphics.getFontMetrics(this.mFont);
            }
            this.mIsResized = false;
        }
    }

    protected void drawTableBackground(Graphics graphics) {
        graphics.setColor(this.getTableBackgoundColor(CellType.TEXT_FIELD));
        graphics.fillRect(0, 0, this.mTableWidth, this.mTableHeight);
        graphics.setColor(COLOR_TABLE_BORDER);
        graphics.drawLine(0, this.mRowHeight, this.mTableWidth, this.mRowHeight);
    }

    protected void drawColumnHeader(Graphics graphics) {
        this.drawColumnHeader(graphics, 0);
    }

    protected void drawColumnHeader(Graphics graphics, int n) {
        int n2 = this.mRowHeaderWidth - this.mHScrollValue;
        for (int i = 0; i < this.mColumnCount; ++i) {
            int n3 = this.mColumnWidths[i];
            graphics.setColor(COLOR_HEADER_BACKGROUND);
            graphics.fillRect(n2 + 1, n, n3 - 2, this.mRowHeight);
            graphics.setColor(COLOR_HEADER_TEXT);
            String string = this.mColumnHeaders.getCell(i).getValue();
            int n4 = n2 + n3 / 2 - this.mFontMetrics.stringWidth(string) / 2;
            if (n4 < n2 + 3) {
                n4 = n2 + 3;
            }
            graphics.drawString(string, n4, n + this.mRowHeight - 4 + 1);
            graphics.setColor(COLOR_TABLE_BORDER);
            graphics.drawLine(n2 + n3 - 1, n, n2 + n3 - 1, n + this.mRowHeight - 1);
            graphics.setColor(COLOR_HEADER_LTBACKGROUND);
            graphics.drawLine(n2 + n3, n, n2 + n3, n + this.mRowHeight - 1);
            graphics.drawLine(n2, n + 2, n2 + n3 - 2, n + 2);
            n2 += n3;
        }
        graphics.setColor(COLOR_HEADER_BACKGROUND);
        graphics.fillRect(0, n, this.mRowHeaderWidth + 1, this.mRowHeight);
        graphics.fillRect(n2 + 1, n, this.mTableWidth - n2, this.mRowHeight);
        graphics.drawLine(0, n, 0, n + this.mRowHeight - 1);
    }

    protected void drawRows(Graphics graphics) {
        int n;
        int n2 = 0;
        for (n = this.mRowHeight + 1 - this.mVScrollValue; n < this.mRowHeight + 1; n += this.mRowHeight) {
            ++n2;
        }
        this.mFirstRow = n2;
        while (n < this.mTableHeight && n2 < this.mRowCount) {
            int n3 = this.mRowHeaderWidth - this.mHScrollValue;
            for (int i = 0; i < this.mColumnCount; ++i) {
                int n4;
                Cell cell = this.getCell(n2, i);
                Color color = this.mSelectedRow == n2 ? COLOR_SELECTED_ROW : this.getTableBackgoundColor(cell.getType());
                graphics.setColor(color);
                int n5 = this.mColumnWidths[i];
                graphics.fillRect(n3, n, n5 - 1, this.mRowHeight - 1);
                graphics.setColor(COLOR_CELL_TEXT);
                String string = this.getValueAt(n2, i);
                int n6 = this.mFontMetrics.stringWidth(string);
                if (n6 + 6 < n5) {
                    switch (this.getAlignment(n2, i)) {
                        case 1: {
                            n4 = n3 + (n5 - n6) / 2;
                            break;
                        }
                        case 2: {
                            n4 = n3 + n5 - n6 - 3;
                            break;
                        }
                        default: {
                            n4 = n3 + 3;
                            break;
                        }
                    }
                } else {
                    n4 = n3 + 3;
                }
                graphics.drawString(string, n4, n + this.mRowHeight - 4);
                graphics.setColor(COLOR_CELL_BORDER);
                graphics.drawLine(n3 + n5 - 1, n, n3 + n5 - 1, n + this.mRowHeight - 1);
                graphics.drawLine(n3, n + this.mRowHeight - 1, n3 + n5 - 1, n + this.mRowHeight - 1);
                n3 += n5;
            }
            this.drawRowHeader(graphics, this.mRowHeaders.getCell(n2).getValue(), n3, n);
            ++n2;
            n += this.mRowHeight;
        }
    }

    protected void drawRowHeader(Graphics graphics, String string, int n, int n2) {
        graphics.setColor(COLOR_HEADER_BACKGROUND);
        graphics.fillRect(n, n2, this.mTableWidth - n, this.mRowHeight - 1);
        if (this.mRowHeaderWidth != 0) {
            graphics.setColor(COLOR_HEADER_BACKGROUND);
            graphics.fillRect(0, n2, this.mRowHeaderWidth, this.mRowHeight - 1);
            graphics.setColor(COLOR_HEADER_TEXT);
            int n3 = this.mFontMetrics.stringWidth(string);
            int n4 = (this.mRowHeaderWidth - n3) / 2;
            graphics.drawString(string, n4, n2 + this.mRowHeight - 4);
            graphics.setColor(COLOR_TABLE_BORDER);
            graphics.drawLine(0, n2 + this.mRowHeight - 1, this.mRowHeaderWidth - 1, n2 + this.mRowHeight - 1);
            graphics.drawLine(this.mRowHeaderWidth - 1, n2, this.mRowHeaderWidth - 1, n2 + this.mRowHeight - 1);
            graphics.setColor(COLOR_HEADER_LTBACKGROUND);
            graphics.drawLine(0, n2, this.mRowHeaderWidth - 2, n2);
            graphics.drawLine(2, n2, 2, n2 + this.mRowHeight - 2);
            graphics.setColor(COLOR_TABLE_BORDER);
            graphics.drawLine(this.mRowHeaderWidth - 1, 0, this.mRowHeaderWidth - 1, this.mRowHeight);
            graphics.setColor(COLOR_HEADER_LTBACKGROUND);
            graphics.drawLine(this.mRowHeaderWidth, 0, this.mRowHeaderWidth, this.mRowHeight - 1);
            graphics.drawLine(2, 2, this.mRowHeaderWidth - 2, 2);
            graphics.drawLine(2, 2, 2, this.mRowHeight - 1);
        }
    }

    protected void drawTableAround(Graphics graphics) {
        int n = this.mRowHeaderWidth;
        for (int i = 0; i < this.mColumnCount; ++i) {
            n += this.mColumnWidths[i];
        }
        graphics.setColor(this.getTableBackgoundColor(CellType.TEXT_FIELD));
        graphics.fillRect(--n + 1, 0, this.mTableWidth, this.mTableHeight);
        graphics.setColor(COLOR_HEADER_BACKGROUND);
        graphics.drawLine(0, 0, this.mTableWidth, 0);
        graphics.drawLine(0, 0, 0, this.mTableHeight);
        graphics.setColor(COLOR_TABLE_BORDER);
        graphics.drawLine(1, 1, this.mTableWidth, 1);
        graphics.drawLine(1, 1, 1, this.mTableHeight);
    }

    protected void drawScrollbarIntersection(Graphics graphics) {
        graphics.setColor(COLOR_HEADER_BACKGROUND);
        graphics.fillRect(this.mTableWidth, this.mTableHeight, this.mHScrollbarWidth, this.mVScrollbarHeight);
        graphics.setColor(COLOR_TABLE_BORDER);
        graphics.drawLine(this.mTableWidth, this.mTableHeight + this.mVScrollbarHeight - 1, this.mTableWidth + this.mHScrollbarWidth - 1, this.mTableHeight + this.mVScrollbarHeight - 1);
        graphics.drawLine(this.mTableWidth + this.mHScrollbarWidth - 1, this.mTableHeight, this.mTableWidth + this.mHScrollbarWidth - 1, this.mTableHeight + this.mVScrollbarHeight - 1);
    }

    protected class MouseWheelListenerImpl
    implements MouseWheelListener {
        protected MouseWheelListenerImpl() {
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            switch (mouseWheelEvent.getScrollType()) {
                case 0: 
                case 1: {
                    int n = mouseWheelEvent.getWheelRotation() * 2;
                    Table.this.mSrlVertical.setValue(Table.this.mSrlVertical.getValue() + n);
                    Table.this.mVScrollValue = Table.this.mSrlVertical.getValue() * Table.this.mRowHeight;
                    Table.this.adjustScroll();
                    Table.this.repaint();
                }
            }
        }
    }

    protected class MouseMotionListenerImpl
    extends MouseMotionAdapter {
        protected MouseMotionListenerImpl() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (Table.this.mDraggedColumn == -1) {
                return;
            }
            int n = mouseEvent.getX();
            int n2 = n - Table.this.mDraggedX;
            if (n2 < 0) {
                n2 = 0;
            }
            Table.this.mColumnWidths[Table.this.mDraggedColumn] = n2;
            Table.this.adjustScroll();
            Table.this.repaint();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            if (!Table.this.isFocusable()) {
                Table.this.setFocusable(true);
            }
            if (mouseEvent.getY() <= Table.this.mRowHeight) {
                int n2;
                int n3 = n;
                n = n + Table.this.mHScrollValue - Table.this.mTotalColumnWidth - Table.this.mRowHeaderWidth;
                for (n2 = Table.this.mColumnCount - 1; n2 >= 0 && (n <= -7 || n >= 7); n += Table.this.mColumnWidths[n2], --n2) {
                }
                if (n2 >= 0) {
                    if (!Table.this.isDragged()) {
                        Table.this.setDragged(true);
                        Table.this.mDraggedX = n3 - Table.this.mColumnWidths[n2];
                        Table.this.mDraggedColumn = n2;
                    }
                    return;
                }
            }
            Table.this.setDragged(false);
        }
    }

    protected class MouseListenerImpl
    extends MouseAdapter {
        protected int clickCount = 2;

        protected MouseListenerImpl() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            int n2 = mouseEvent.getX();
            int n3 = mouseEvent.getY();
            if (Table.this.mRowHeight == 0 || n2 > Table.this.mTableWidth || n3 > Table.this.mTableHeight) {
                Table.this.mSelectedRow = -1;
                Table.this.clearSelection();
                return;
            }
            n2 += Table.this.mHScrollValue - Table.this.mRowHeaderWidth;
            int n4 = -1;
            for (n = 0; n < Table.this.mColumnCount; ++n) {
                int n5 = Table.this.mColumnWidths[n];
                if (n2 >= 0 && n2 <= n5) {
                    n4 = n;
                    break;
                }
                n2 -= n5;
            }
            if (Table.this.mEditor.isEnabled()) {
                Table.this.select(-1, -1);
            }
            if (n3 < Table.this.mRowHeight) {
                return;
            }
            n = n3 / Table.this.mRowHeight - 1 + Table.this.mFirstRow;
            if (mouseEvent.getX() < Table.this.mRowHeaderWidth && n3 < Table.this.mRowHeight * (Table.this.mRowCount + 1)) {
                Table.this.selectRow(n);
            } else if (n >= 0 && n < Table.this.mRowCount) {
                if (n4 >= 0 && n4 < Table.this.mColumnCount) {
                    Cell cell = Table.this.getCell(n, n4);
                    if (cell.getType() == CellType.BUTTON) {
                        Table.this.select(n, n4);
                        cell.getClickAction().doAction();
                    } else if (mouseEvent.getClickCount() >= this.clickCount) {
                        Table.this.select(n, n4);
                    } else {
                        Table.this.selectRow(n);
                    }
                } else {
                    Table.this.select(n, -1);
                }
            } else {
                Table.this.mSelectedRow = -1;
                Table.this.clearSelection();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getX() > Table.this.mTableWidth) {
                Table.this.setCursor(new Cursor(0));
            }
        }

        public void setClickCount(int n) {
            this.clickCount = n;
        }
    }

    protected class AdjustmentListenerImpl
    implements AdjustmentListener {
        protected AdjustmentListenerImpl() {
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            Table.this.mHScrollValue = Table.this.mSrlHorizontal.getValue();
            Table.this.mVScrollValue = Table.this.mSrlVertical.getValue() * Table.this.mRowHeight;
            Table.this.repaint();
        }
    }

    protected class EditorFocusListener
    extends FocusAdapter {
        protected EditorFocusListener() {
        }

        public void focusLost(FocusEvent focusEvent) {
            int n = Table.this.mSelectedRow;
            int n2 = Table.this.mSelectedColumn;
            Table.this.select(-1, -1);
            if (Table.this.checkAfterFocusLost(n, n2)) {
                Table.this.repaint();
            }
        }
    }

    protected class EditorKeyListener
    extends KeyAdapter {
        protected EditorKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = Table.this.mSelectedRow;
            int n2 = Table.this.mSelectedColumn;
            if (n < 0 || n >= Table.this.mRowCount) {
                return;
            }
            switch (keyEvent.getKeyCode()) {
                case 9: {
                    n2 = (keyEvent.getModifiers() & 1) != 0 ? --n2 : ++n2;
                    if (n2 < 0) {
                        n2 = Table.this.mColumnCount - 1;
                        if (--n < 0) {
                            n = Table.this.mRowCount - 1;
                        }
                    }
                    if (n2 >= Table.this.mColumnCount) {
                        n2 = 0;
                        if (++n >= Table.this.mRowCount) {
                            n = 0;
                        }
                    }
                    Table.this.select(n, n2);
                    break;
                }
                case 10: {
                    int n3 = Table.this.mSelectedRow;
                    int n4 = Table.this.mSelectedColumn;
                    Table.this.select(-1, -1);
                    if (Table.this.checkAfterFocusLost(n3, n4)) {
                        Table.this.repaint();
                    }
                    Table.this.selectRow(n);
                    break;
                }
                case 27: {
                    if (Table.this.mEditor.isVisible()) {
                        Table.this.selectRow(Table.this.getSelectedRow());
                        break;
                    }
                    Table.this.clearSelection();
                }
            }
            if (!(Table.this.mKeyHandler == null || Table.this.mHandleKey != -1 && Table.this.mHandleKey != keyEvent.getKeyCode() || Table.this.mHandleRow != -1 && Table.this.mHandleRow != n || Table.this.mHandleCol != -1 && Table.this.mHandleCol != n2)) {
                Table.this.mKeyHandler.keyPressedAt(keyEvent, n, n2);
            }
        }
    }
}

