/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.kwt.util;

import com.kt.io.AbstFile;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import jp.kitec.kwt.KFont;

public class ImageTool {
    private Container aV;
    public static int mImgDefW = 26;
    public static int mImgDefH = 26;

    public ImageTool(Container container) {
        this.aV = container;
    }

    public Container getObserver() {
        return this.aV;
    }

    public Image changeClear(Image image, int n, int n2, int n3) {
        int[] nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
        try {
            pixelGrabber.grabPixels(1000L);
        }
        catch (Exception exception) {
            return image;
        }
        for (int i = 0; i < n * n2; ++i) {
            if (nArray[i] != n3) continue;
            int n4 = i;
            nArray[n4] = nArray[n4] & 0xFFFFFF;
        }
        Image image2 = this.aV.createImage(new MemoryImageSource(n, n2, nArray, 0, n));
        nArray = null;
        return image2;
    }

    public Image changeDarker(Image image, int n, int n2, int n3, int n4) {
        int[] nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
        try {
            pixelGrabber.grabPixels(1000L);
        }
        catch (Exception exception) {
            return image;
        }
        for (int i = 0; i < n * n2; ++i) {
            if (nArray[i] == n3) {
                int n5 = i;
                nArray[n5] = nArray[n5] & 0xFFFFFF;
                continue;
            }
            int n6 = nArray[i] & 0xFF;
            int n7 = nArray[i] >> 8 & 0xFF;
            int n8 = nArray[i] >> 16 & 0xFF;
            float f = 0.299f * (float)n6 + 0.587f * (float)n7 + 0.114f * (float)n8;
            n7 = n8 = (int)f;
            n6 = n8;
            nArray[i] = n6 | n7 << 8 | n8 << 16 | n4 << 24;
        }
        Image image2 = this.aV.createImage(new MemoryImageSource(n, n2, nArray, 0, n));
        nArray = null;
        return image2;
    }

    public Image createEnableImage(Image image, int n, int n2, int n3) {
        int[] nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
        try {
            pixelGrabber.grabPixels(1000L);
        }
        catch (Exception exception) {
            return image;
        }
        for (int i = 0; i < n * n2; ++i) {
            if ((nArray[i] & 0xFF000000) == 0) continue;
            int n4 = nArray[i] & 0xFF;
            int n5 = nArray[i] >> 8 & 0xFF;
            int n6 = nArray[i] >> 16 & 0xFF;
            float f = 0.299f * (float)n4 + 0.587f * (float)n5 + 0.114f * (float)n6;
            n5 = n6 = (int)f;
            n4 = n6;
            nArray[i] = n4 | n5 << 8 | n6 << 16 | n3 << 24;
        }
        Image image2 = this.aV.createImage(new MemoryImageSource(n, n2, nArray, 0, n));
        nArray = null;
        return image2;
    }

    public static int[] getPix(Image image, int n, int n2) {
        int[] nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
        try {
            pixelGrabber.grabPixels();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return nArray;
    }

    public static Image getImage(AbstFile abstFile, Container container) {
        if (abstFile == null) {
            return null;
        }
        return ImageTool.getImage(abstFile.getData(), container);
    }

    public static Image getImage(byte[] byArray, Container container) {
        if (byArray == null) {
            return null;
        }
        Image image = Toolkit.getDefaultToolkit().createImage(byArray);
        MediaTracker mediaTracker = new MediaTracker(container);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return image;
    }

    public Image createStrImageWide(String string, KFont kFont, Color color, Color color2) {
        return this.createStrImageA(string, kFont, 50, 20, color, color2, 1);
    }

    public Image createStrImage(String string, KFont kFont, Color color, Color color2, int n, int n2, int n3) {
        return this.createStrImageA(string, kFont, kFont.stringWidth(string) + n2, kFont.getHeight() + n3, color, color2, n);
    }

    public Image createStrImageA(String string, KFont kFont, int n, int n2, Color color, Color color2, int n3) {
        String string2 = null;
        String string3 = null;
        String string4 = "";
        for (int i = 0; i < string.length(); ++i) {
            String string5 = string4 = string4 + string.substring(i, i + 1);
            if (kFont.stringWidth(string5) <= n - n3 * 3 * 2) {
                string4 = string5;
                continue;
            }
            if (string2 != null) break;
            string2 = new String(string4);
            string4 = "";
        }
        if (string2 == null) {
            string2 = string4;
        } else if (string4.length() != 0) {
            string3 = string4;
        }
        return this.createStrImageA(new String[]{string2, string3}, kFont, n, n2, color, color2, n3);
    }

    public Image createStrImageA(String[] stringArray, KFont kFont, int n, int n2, Color color, Color color2, int n3) {
        Image image = this.aV.createImage(n, n2);
        Graphics graphics = image.getGraphics();
        if (color2 == null) {
            graphics.setColor(Color.white);
        } else {
            graphics.setColor(color2);
        }
        graphics.fillRect(0, 0, n, n2);
        graphics.setColor(color);
        graphics.setFont(kFont.getFontObject());
        String string = null;
        String string2 = null;
        if (stringArray.length > 0 && stringArray[0] != null) {
            string = stringArray[0];
        }
        if (stringArray.length > 1 && stringArray[1] != null) {
            string2 = stringArray[1];
        }
        if (string != null && string2 != null) {
            int n4 = (n2 - 2) / 2 - n3;
            int n5 = n2 - 2 - n3;
            graphics.drawString(string, (n - kFont.stringWidth(string)) / 2 + n3, n4);
            graphics.drawString(string2, (n - kFont.stringWidth(string2)) / 2 + n3, n5);
        } else if (string != null) {
            int n6 = n2 - (n2 - 0 - kFont.getHeight()) / 2 - kFont.getDescent();
            graphics.drawString(string, (n - kFont.stringWidth(string)) / 2 + n3, n6);
        }
        graphics.dispose();
        if (color2 == null) {
            return this.changeClear(image, n, n2, -1);
        }
        return image;
    }
}

