/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.kwt;

import com.kt.geom.K2DPathFigureArc;
import com.kt.geom.K2DPathFigureLine;
import com.kt.geom.K2DPathFigurePoint;
import com.kt.geom.KLocalAxis;
import com.kt.util.KCollection;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Stroke;
import jp.kitec.kwt.IRichGraphics;
import jp.kitec.kwt.KLineType;
import jp.kitec.kwt.KViewPort;
import jp.kitec.kwt.RichGraphicsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRichGraphics
implements IRichGraphics {
    protected static Stroke LINETYPE_DEF = new BasicStroke(1.0f);
    public float mDotPerLen;
    private KViewPort aj;
    public Dimension mDimension;
    protected static final double RAD = Math.PI / 180;
    protected static final double[] COS_TABLE = new double[360];
    protected static final double[] SIN_TABLE = new double[360];

    public void setViewPort(KViewPort kViewPort) {
        this.aj = kViewPort;
    }

    public KViewPort getViewPort() {
        return this.aj;
    }

    public void setSize(int n, int n2) {
        if (this.mDimension == null) {
            this.mDimension = new Dimension();
        }
        this.mDimension.width = n;
        this.mDimension.height = n2;
    }

    public Dimension getSize() {
        return this.mDimension;
    }

    public void setView(float f, float f2, float f3, float f4) {
        this.setView(f, f2, f3, f4, this.mDimension);
    }

    public void setView(float f, float f2, float f3, float f4, Dimension dimension) {
        KViewPort kViewPort = this.getViewPort();
        kViewPort.x1 = f < f3 ? f : f3;
        kViewPort.x2 = f < f3 ? f3 : f;
        kViewPort.y1 = f2 < f4 ? f2 : f4;
        kViewPort.y2 = f2 < f4 ? f4 : f2;
        kViewPort.cx = (kViewPort.x1 + kViewPort.x2) / 2.0f;
        kViewPort.cy = (kViewPort.y1 + kViewPort.y2) / 2.0f;
        this.updateViewScale(dimension);
    }

    public void setViewCenter(float f, float f2) {
        KViewPort kViewPort = this.getViewPort();
        float f3 = f - kViewPort.cx;
        float f4 = f2 - kViewPort.cy;
        kViewPort.cx += f3;
        kViewPort.cy += f4;
        kViewPort.x1 += f3;
        kViewPort.x2 += f3;
        kViewPort.y1 += f4;
        kViewPort.y2 += f4;
        this.updateViewScale(this.mDimension);
    }

    public int realToDevX(double d2) {
        if (this.mDimension == null) {
            return 0;
        }
        return Math.round((float)((d2 - (double)this.getViewPort().cx) * (double)this.mDotPerLen + (double)(this.mDimension.width / 2)));
    }

    public int realToDevY(double d2) {
        if (this.mDimension == null) {
            return 0;
        }
        return Math.round((float)((double)this.mDimension.height - ((d2 - (double)this.getViewPort().cy) * (double)this.mDotPerLen + (double)(this.mDimension.height / 2))));
    }

    public double realToDevXd(double d2) {
        if (this.mDimension == null) {
            return 0.0;
        }
        return (d2 - (double)this.getViewPort().cx) * (double)this.mDotPerLen + (double)(this.mDimension.width / 2);
    }

    public double realToDevYd(double d2) {
        if (this.mDimension == null) {
            return 0.0;
        }
        return (double)this.mDimension.height - ((d2 - (double)this.getViewPort().cy) * (double)this.mDotPerLen + (double)(this.mDimension.height / 2));
    }

    public float devToRealX(int n) {
        if (this.mDimension == null) {
            return 0.0f;
        }
        return (float)(n - this.mDimension.width / 2) / this.mDotPerLen + this.getViewPort().cx;
    }

    public float devToRealY(int n) {
        if (this.mDimension == null) {
            return 0.0f;
        }
        return (float)(this.mDimension.height / 2 - n) / this.mDotPerLen + this.getViewPort().cy;
    }

    public double devToRealX(double d2) {
        if (this.mDimension == null) {
            return 0.0;
        }
        return (d2 - (double)(this.mDimension.width / 2)) / (double)this.mDotPerLen + (double)this.getViewPort().cx;
    }

    public double devToRealY(double d2) {
        if (this.mDimension == null) {
            return 0.0;
        }
        return ((double)(this.mDimension.height / 2) - d2) / (double)this.mDotPerLen + (double)this.getViewPort().cy;
    }

    public void updateViewScale(Dimension dimension) {
        KViewPort kViewPort = this.getViewPort();
        this.setViewScale(kViewPort.x1, kViewPort.y1, kViewPort.x2, kViewPort.y2, dimension);
    }

    protected void setViewScale(float f, float f2, float f3, float f4, Dimension dimension) {
        if (dimension != null) {
            float f5 = (float)dimension.width / (f3 - f);
            float f6 = (float)dimension.height / (f4 - f2);
            this.mDotPerLen = f5 < f6 ? f5 : f6;
        }
    }

    @Override
    public void drawPolygon(KCollection<? extends K2DPathFigurePoint> kCollection, KLineType kLineType) {
        if (kCollection == null || kCollection.size() == 0) {
            return;
        }
        this.pathInit(0);
        for (int i = 0; i < kCollection.size(); ++i) {
            K2DPathFigurePoint k2DPathFigurePoint = kCollection.elementAt(i);
            if (i == 0) {
                this.pathMoveTo(k2DPathFigurePoint.getX(), k2DPathFigurePoint.getY(), null);
                continue;
            }
            this.pathLineTo(k2DPathFigurePoint.getX(), k2DPathFigurePoint.getY(), null);
        }
        this.pathClose();
        this.drawPath(kLineType);
        this.pathClear();
    }

    @Override
    public void drawFillPolygon(KCollection<? extends K2DPathFigurePoint> kCollection, KLineType kLineType) {
        if (kCollection == null || kCollection.size() == 0) {
            return;
        }
        this.pathInit(0);
        for (int i = 0; i < kCollection.size(); ++i) {
            K2DPathFigurePoint k2DPathFigurePoint = kCollection.elementAt(i);
            if (i == 0) {
                this.pathMoveTo(k2DPathFigurePoint.getX(), k2DPathFigurePoint.getY(), null);
                continue;
            }
            this.pathLineTo(k2DPathFigurePoint.getX(), k2DPathFigurePoint.getY(), null);
        }
        this.pathClose();
        this.fillPath(kLineType);
        this.pathClear();
    }

    @Override
    public void drawPolyLine(KCollection<? extends K2DPathFigurePoint> kCollection, KLineType kLineType) {
        if (kCollection == null || kCollection.size() == 0) {
            return;
        }
        this.pathInit(0);
        for (int i = 0; i < kCollection.size(); ++i) {
            K2DPathFigurePoint k2DPathFigurePoint = kCollection.elementAt(i);
            if (i == 0) {
                this.pathMoveTo(k2DPathFigurePoint.getX(), k2DPathFigurePoint.getY(), null);
                continue;
            }
            this.pathLineTo(k2DPathFigurePoint.getX(), k2DPathFigurePoint.getY(), null);
        }
        this.drawPath(kLineType);
        this.pathClear();
    }

    public boolean isInCanvas(int n, int n2) {
        if (n < 0 || n > this.mDimension.width) {
            return false;
        }
        return n2 >= 0 && n2 <= this.mDimension.height;
    }

    protected float getx(double d2, double d3, KLocalAxis kLocalAxis) {
        double d4 = kLocalAxis == null ? this.realToDevXd(d2) : this.realToDevXd(kLocalAxis.getGlobalX((float)d2, (float)d3));
        return (float)d4;
    }

    protected float gety(double d2, double d3, KLocalAxis kLocalAxis) {
        double d4 = kLocalAxis == null ? this.realToDevYd(d3) : this.realToDevYd(kLocalAxis.getGlobalY((float)d2, (float)d3));
        return (float)d4;
    }

    @Override
    public void pathAdd(KCollection<K2DPathFigureLine> kCollection, KLocalAxis kLocalAxis) {
        float f;
        float f2;
        if (kCollection.size() < 2) {
            return;
        }
        K2DPathFigureLine k2DPathFigureLine = kCollection.elementAt(0);
        K2DPathFigureLine k2DPathFigureLine2 = kCollection.elementAt(1);
        if (RichGraphicsUtil.isSame2D(k2DPathFigureLine.getX1(), k2DPathFigureLine.getY1(), k2DPathFigureLine2.getX1(), k2DPathFigureLine2.getY1()) || RichGraphicsUtil.isSame2D(k2DPathFigureLine.getX1(), k2DPathFigureLine.getY1(), k2DPathFigureLine2.getX2(), k2DPathFigureLine2.getY2())) {
            f2 = (float)k2DPathFigureLine.getX2();
            f = (float)k2DPathFigureLine.getY2();
        } else {
            f2 = (float)k2DPathFigureLine.getX1();
            f = (float)k2DPathFigureLine.getY1();
        }
        this.pathMoveTo(f2, f, kLocalAxis);
        for (int i = 0; i < kCollection.size(); ++i) {
            k2DPathFigureLine = kCollection.elementAt(i);
            k2DPathFigureLine2 = kCollection.elementAt(i + 1);
            boolean bl = false;
            if (RichGraphicsUtil.isSame2D(k2DPathFigureLine.getX1(), k2DPathFigureLine.getY1(), k2DPathFigureLine2.getX1(), k2DPathFigureLine2.getY1()) || RichGraphicsUtil.isSame2D(k2DPathFigureLine.getX1(), k2DPathFigureLine.getY1(), k2DPathFigureLine2.getX2(), k2DPathFigureLine2.getY2())) {
                bl = true;
            }
            if (k2DPathFigureLine instanceof K2DPathFigureArc) {
                float f3;
                K2DPathFigureArc k2DPathFigureArc = (K2DPathFigureArc)k2DPathFigureLine;
                float f4 = (float)k2DPathFigureArc.getRadius();
                float f5 = (float)k2DPathFigureArc.getCX();
                float f6 = (float)k2DPathFigureArc.getCY();
                float f7 = (float)RichGraphicsUtil.getAngle2D(f5, f6, k2DPathFigureArc.getX1(), k2DPathFigureArc.getY1());
                float f8 = (float)RichGraphicsUtil.getAngle2D(f5, f6, k2DPathFigureArc.getX2(), k2DPathFigureArc.getY2());
                for (f3 = f8 - f7; f3 < 0.0f; f3 += 360.0f) {
                }
                if (k2DPathFigureArc.isCw()) {
                    f3 = -(360.0f - f3);
                }
                if (bl) {
                    f3 = -f3;
                }
                this.pathArc(f5, f6, f4, f4, bl ? f8 : f7, f3, kLocalAxis);
                continue;
            }
            if (bl) {
                this.pathLineTo((float)k2DPathFigureLine.getX1(), (float)k2DPathFigureLine.getY1(), kLocalAxis);
                continue;
            }
            this.pathLineTo((float)k2DPathFigureLine.getX2(), (float)k2DPathFigureLine.getY2(), kLocalAxis);
        }
    }

    @Override
    public void pathArc(float f, float f2, float f3, float f4, float f5, KLocalAxis kLocalAxis) {
        this.pathArc(f, f2, f3, f3, f4, f5, kLocalAxis);
    }

    protected void pathArc(float f, float f2, float f3, float f4, float f5, float f6, KLocalAxis kLocalAxis) {
        double d2 = 4.0;
        float f7 = f3 * 2.0f;
        float f8 = f4 * 2.0f;
        double d3 = (double)f6 * Math.PI / 180.0;
        double d4 = d3 / d2;
        double d5 = Math.cos(d4);
        double d6 = Math.sin(d4);
        double[] dArray = new double[4];
        double[] dArray2 = new double[4];
        dArray[1] = 1.0;
        dArray[0] = 1.0;
        dArray2[0] = 0.0;
        dArray[3] = d5;
        dArray2[3] = d6;
        dArray[2] = (8.0 * Math.cos(d4 / 2.0) - (dArray[0] + 3.0 * dArray[1] + dArray[3])) / 3.0;
        dArray2[2] = dArray2[3] - (-dArray[2] + dArray[3]) / -Math.tan(d4);
        dArray2[1] = (8.0 * Math.sin(d4 / 2.0) - (dArray2[0] + 3.0 * dArray2[2] + dArray2[3])) / 3.0;
        double d7 = (double)f5 * Math.PI / 180.0;
        double d8 = Math.cos(d7);
        double d9 = Math.sin(d7);
        double[] dArray3 = new double[4];
        double[] dArray4 = new double[4];
        for (int i = 0; i < 4; ++i) {
            dArray3[i] = dArray[i] * d8 - dArray2[i] * d9;
            dArray4[i] = dArray[i] * d9 + dArray2[i] * d8;
            dArray[i] = dArray3[i];
            dArray2[i] = dArray4[i];
        }
        float f9 = f8 / f7;
        if (Float.isNaN(f9)) {
            f9 = 1.0f;
        }
        this.pathMoveTo((float)((double)f3 * dArray[0]) + f, (float)((double)f3 * dArray2[0]) * f9 + f2, kLocalAxis);
        int n = 0;
        while ((double)n < d2) {
            this.pathCurveTo((float)((double)f3 * dArray[1]) + f, (float)((double)f3 * dArray2[1]) * f9 + f2, (float)((double)f3 * dArray[2]) + f, (float)((double)f3 * dArray2[2]) * f9 + f2, (float)((double)f3 * dArray[3]) + f, (float)((double)f3 * dArray2[3]) * f9 + f2, kLocalAxis);
            for (int i = 1; i < 4; ++i) {
                dArray3[i] = dArray[i] * d5 - dArray2[i] * d6;
                dArray4[i] = dArray[i] * d6 + dArray2[i] * d5;
                dArray[i] = dArray3[i];
                dArray2[i] = dArray4[i];
            }
            ++n;
        }
    }

    static {
        for (int i = 0; i < 360; ++i) {
            AbstractRichGraphics.COS_TABLE[i] = Math.cos((double)i * (Math.PI / 180));
            AbstractRichGraphics.SIN_TABLE[i] = Math.sin((double)i * (Math.PI / 180));
        }
    }
}

