/*
 * Decompiled with CFR 0.152.
 */
package com.kt.util;

import com.kt.annotation.DontObfuscate;
import com.kt.annotation.DontShrink;
import com.kt.annotation.Reflectable;
import com.kt.util.Item;
import com.kt.util.KCollection;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefList<E>
implements KCollection<E>,
Serializable {
    private transient Item<E> N = null;
    private transient int O = 0;

    public RefList() {
    }

    public RefList(String string) {
    }

    public void setHead(Item<E> item) {
        if (!this.a(item)) {
            return;
        }
        this.N = item;
    }

    @Override
    public E firstElement() {
        if (this.O != 0) {
            return this.N.getObject();
        }
        return null;
    }

    @Override
    public E lastElement() {
        if (this.O != 0) {
            return this.N.prevItem.getObject();
        }
        return null;
    }

    @Override
    public E elementAt(int n) {
        return this.itemAt(n).getObject();
    }

    public Item<E> itemAt(int n) {
        Item<E> item = this.N;
        if (n >= 0) {
            for (int i = 0; i < n; ++i) {
                item = item.nextItem;
            }
        } else {
            for (int i = 0; i > n; --i) {
                item = item.prevItem;
            }
        }
        return item;
    }

    public Item<E> itemAt(Object object) {
        Item<E> item = this.N;
        for (int i = 0; i < this.O; ++i) {
            if (item.getObject() == object) {
                return item;
            }
            item = item.nextItem;
        }
        return null;
    }

    @Override
    public int size() {
        return this.O;
    }

    public boolean addElement(E e) {
        if (e == null) {
            return false;
        }
        if (this.N == null) {
            this.insertElementAt(e, this.N);
        } else {
            this.insertElementAt(e, this.N.prevItem);
        }
        return true;
    }

    public void removeAllElements() {
        int n = this.O;
        for (int i = 0; i < n; ++i) {
            this.removeItemAt(this.N);
        }
    }

    public Item<E> removeElement(Object object) {
        Item<E> item = null;
        Item<E> item2 = this.N;
        for (int i = 0; i < this.O; ++i) {
            if (item2.getObject() == object) {
                item = item2;
                break;
            }
            item2 = item2.nextItem;
        }
        if (item != null) {
            return this.removeItemAt(item);
        }
        return null;
    }

    public Item<E> removeItemAt(Item<E> item) {
        Item item2;
        if (item == null || this.N == null || item.nextItem == null) {
            return null;
        }
        if (this.O > 1) {
            if (item == this.N) {
                this.N = item.nextItem;
            }
            item.prevItem.nextItem = item.nextItem;
            item2 = item.nextItem.prevItem = item.prevItem;
            item.prevItem = null;
            item.nextItem = null;
            item = null;
        } else {
            this.N = null;
            item2 = null;
        }
        --this.O;
        return item2;
    }

    public boolean contains(Object object) {
        Item<E> item = this.N;
        for (int i = 0; i < this.O; ++i) {
            if (item.getObject() == object) {
                return true;
            }
            item = item.nextItem;
        }
        return false;
    }

    private boolean a(Item<E> item) {
        Item<E> item2 = this.N;
        for (int i = 0; i < this.O; ++i) {
            if (item == item2) {
                return true;
            }
            item2 = item2.nextItem;
        }
        return false;
    }

    public Item<E> insertElementAt(E e, int n) {
        if (e == null) {
            return null;
        }
        if (n < 0 || n >= this.O) {
            return null;
        }
        Item<E> item = this.N;
        for (int i = 0; i < this.O && i != n; ++i) {
            item = item.nextItem;
        }
        return this.insertElementAt(e, item);
    }

    public Item<E> insertElementAt(E e, Item<E> item) {
        if (item == null && this.N != null || e == null) {
            return null;
        }
        if (!this.a(item) && this.N != null) {
            return null;
        }
        Item<E> item2 = new Item<E>(e);
        if (item == null) {
            item2.prevItem = item2;
            item2.nextItem = item2.prevItem;
            this.N = item2;
        } else {
            item2.prevItem = item;
            item2.nextItem = item.nextItem;
            item.nextItem.prevItem = item2;
            item.nextItem = item2;
        }
        ++this.O;
        return item2;
    }

    public RefList<E> getCopy() {
        RefList<E> refList = new RefList<E>();
        for (int i = 0; i < this.size(); ++i) {
            refList.addElement(this.elementAt(i));
        }
        return refList;
    }

    public <T> void swap(Item<T> item, Item<T> item2) {
        T t = item.getObject();
        item.setObject(item2.getObject());
        item2.setObject(t);
    }

    public boolean deleteAtoB(Item<E> item, Item<E> item2, boolean bl) {
        int n;
        Item<E> item3 = null;
        Item<E> item4 = null;
        Item<E> item5 = this.N;
        if (item == item2 && item != null) {
            this.removeItemAt(item);
            return true;
        }
        for (n = 0; n < this.O; ++n) {
            if (item5 == item) {
                item3 = item5;
            } else if (item5 == item2) {
                item4 = item5;
            }
            if (item3 != null && item4 != null) break;
            item5 = item5.nextItem;
        }
        if (item3 == null || item4 == null) {
            return false;
        }
        n = this.O;
        item5 = item3;
        for (int i = 0; i < n; ++i) {
            Item item6 = bl ? item5.nextItem : item5.prevItem;
            this.removeItemAt(item5);
            if (item5 == item4) break;
            item5 = item6;
        }
        return true;
    }

    public void flip() {
        Item item;
        Item<E> item2 = this.N;
        Item item3 = this.N.nextItem;
        do {
            item = this.N.prevItem;
            this.removeItemAt(item);
            this.insertElementAt(item.getObject(), item2);
            item2 = item2.nextItem;
        } while (item.getObject() != item3.getObject());
    }

    public int hashCode() {
        int n = 1;
        Item<E> item = this.N;
        for (int i = 0; i < this.O; ++i) {
            E e = item.getObject();
            n = 31 * n + (e == null ? 0 : e.hashCode());
            item = item.nextItem;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RefList)) {
            return false;
        }
        RefList refList = (RefList)object;
        if (this.O != refList.O) {
            return false;
        }
        Item<E> item = this.N;
        Item<E> item2 = refList.N;
        for (int i = 0; i < this.O; ++i) {
            E e = item.getObject();
            E e2 = item2.getObject();
            if (!(e != null ? e.equals(e2) : e2 == null)) {
                return false;
            }
            item = item.nextItem;
            item2 = item2.nextItem;
        }
        return true;
    }

    @DontShrink
    @DontObfuscate
    @Reflectable
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.O);
        Item<E> item = this.N;
        if (this.O > 0) {
            for (int i = 0; i < this.O; ++i) {
                objectOutputStream.writeObject(item.getObject());
                item = item.nextItem;
            }
        }
    }

    @DontShrink
    @DontObfuscate
    @Reflectable
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            Object object = objectInputStream.readObject();
            this.addElement(object);
        }
    }
}

