/*
 * Decompiled with CFR 0.152.
 */
package com.kt.util;

import com.kt.io.AbstFile;
import com.kt.util.StringUtil;
import com.kt.util.tree.ObjectFolder;
import com.kt.util.tree.ObjectNode;
import com.kt.util.xml.XMLManager;
import com.kt.util.xml.XMLWriter2;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectFolderUtil {
    protected ObjectFolderUtil() {
    }

    public static Collection<ObjectFolder> collectChildFolders(ObjectFolder objectFolder) {
        return ObjectFolderUtil.collectChildFolders(objectFolder, -1);
    }

    public static Collection<ObjectFolder> collectChildFolders(ObjectFolder objectFolder, int n) {
        ArrayList<ObjectFolder> arrayList = new ArrayList<ObjectFolder>();
        if (n == 0) {
            return arrayList;
        }
        Vector<ObjectNode> vector = objectFolder.getChildlen();
        for (ObjectNode objectNode : vector) {
            if (!(objectNode instanceof ObjectFolder)) continue;
            ObjectFolder objectFolder2 = (ObjectFolder)objectNode;
            arrayList.add(objectFolder2);
            arrayList.addAll(ObjectFolderUtil.collectChildFolders(objectFolder2, n - 1));
        }
        return arrayList;
    }

    public static Collection<ObjectFolder> findChildFolders(ObjectFolder objectFolder, String string) {
        return ObjectFolderUtil.findChildFolders(objectFolder, -1, string);
    }

    public static Collection<ObjectFolder> findChildFolders(ObjectFolder objectFolder, int n, String string) {
        Collection<ObjectFolder> collection = ObjectFolderUtil.collectChildFolders(objectFolder, n);
        ArrayList<ObjectFolder> arrayList = new ArrayList<ObjectFolder>();
        for (ObjectFolder objectFolder2 : collection) {
            if (!objectFolder2.getName().equals(string)) continue;
            arrayList.add(objectFolder2);
        }
        return arrayList;
    }

    public static ObjectNode findChildNode(ObjectFolder objectFolder, String string) {
        String[] stringArray = string.split("/");
        ObjectFolder objectFolder2 = objectFolder;
        block0: for (String string2 : stringArray) {
            if (StringUtil.isEmpty(string2)) continue;
            if (string2.matches("^@.*")) {
                return objectFolder2.findNode(string2.substring(1));
            }
            Collection<ObjectFolder> collection = ObjectFolderUtil.collectChildFolders(objectFolder2, 1);
            for (ObjectFolder objectFolder3 : collection) {
                if (!objectFolder3.getName().equals(string2)) continue;
                objectFolder2 = objectFolder3;
                continue block0;
            }
        }
        return null;
    }

    public static byte[] toByteArray(ObjectFolder objectFolder) {
        PrintStream printStream;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            printStream = new PrintStream((OutputStream)byteArrayOutputStream, false, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        try {
            XMLWriter2.write((ObjectNode)objectFolder, "", printStream, "UTF-8");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static ObjectFolder fromByteArray(byte[] byArray) {
        XMLManager xMLManager = new XMLManager();
        AbstFile abstFile = new AbstFile();
        abstFile.setData(byArray);
        if (xMLManager.load(abstFile, "UTF-8")) {
            return xMLManager.getTree();
        }
        return null;
    }
}

