/*
 * Decompiled with CFR 0.152.
 */
package com.kt.util;

import com.kt.io.FileIOUtil;
import com.kt.util.CompressData;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageUtil {
    private static final Log E = LogFactory.getLog(MessageUtil.class);
    public static final int MAGIC = 1852322869;
    public static final int MAGIC_0 = 110;
    public static final int MAGIC_1 = 104;
    public static final int MAGIC_2 = 52;
    public static final int MAGIC_3 = 53;

    public static byte[] recvData(InputStream inputStream) {
        return MessageUtil.recvData(inputStream, true, true);
    }

    public static byte[] recvData(InputStream inputStream, boolean bl, boolean bl2) {
        byte[] byArray;
        if (bl2) {
            byArray = new byte[4];
            try {
                int n = inputStream.read(byArray);
                if (n != 4) {
                    E.error((Object)("read header error " + n));
                    return null;
                }
            }
            catch (IOException iOException) {
                E.error((Object)"read header error", (Throwable)iOException);
                return null;
            }
            if (byArray[0] != 110 || byArray[1] != 104 || byArray[2] != 52 || byArray[3] != 53) {
                E.error((Object)("bad header:" + Integer.toString(0xFF & byArray[0]) + "/" + Integer.toString(0xFF & byArray[1]) + "/" + Integer.toString(0xFF & byArray[2]) + "/" + Integer.toString(0xFF & byArray[3])));
                return null;
            }
        }
        byArray = FileIOUtil.readBytes(inputStream);
        if (bl) {
            byArray = CompressData.decompress(byArray);
        }
        return byArray;
    }

    public static void sendData(OutputStream outputStream, byte[] byArray) {
        MessageUtil.sendData(outputStream, byArray, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendData(OutputStream outputStream, byte[] byArray, boolean bl, boolean bl2) {
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(outputStream);
            if (bl2) {
                bufferedOutputStream.write(110);
                bufferedOutputStream.write(104);
                bufferedOutputStream.write(52);
                bufferedOutputStream.write(53);
            }
            if (byArray != null) {
                if (bl) {
                    bufferedOutputStream.write(byArray);
                } else {
                    bufferedOutputStream.write(CompressData.compress(byArray));
                }
            }
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
        }
        catch (IOException iOException) {
            try {
                E.error((Object)"", (Throwable)iOException);
            }
            catch (Throwable throwable) {
                FileIOUtil.close(bufferedOutputStream);
                throw throwable;
            }
            FileIOUtil.close(bufferedOutputStream);
        }
        FileIOUtil.close(bufferedOutputStream);
    }

    public static Object recvDataUnsafe(InputStream inputStream) {
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new BufferedInputStream(inputStream));
            Object object = objectInputStream.readObject();
            objectInputStream.close();
            if (object != null && object instanceof byte[]) {
                Object object2 = CompressData.decompressUnsafe(object);
                return object2;
            }
            return object;
        }
        catch (IOException iOException) {
            E.error((Object)"", (Throwable)iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            E.error((Object)"", (Throwable)classNotFoundException);
        }
        return null;
    }

    public static void sendDataUnsafe(OutputStream outputStream, Object object) throws IOException {
        MessageUtil.sendDataUnsafe(outputStream, object, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendDataUnsafe(OutputStream outputStream, Object object, boolean bl) {
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(outputStream));
            if (bl) {
                objectOutputStream.writeObject(object);
            } else {
                objectOutputStream.writeObject(CompressData.compressUnsafe(object));
            }
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            try {
                E.error((Object)"", (Throwable)iOException);
            }
            catch (Throwable throwable) {
                FileIOUtil.close(objectOutputStream);
                throw throwable;
            }
            FileIOUtil.close(objectOutputStream);
        }
        FileIOUtil.close(objectOutputStream);
    }
}

