/*
 * Decompiled with CFR 0.152.
 */
package com.kt.util;

import d.d;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

public class History {
    private int F = 8;
    private Vector<byte[]> G;
    private byte[] H;

    public History(int n) {
        this.setMaxHistory(n);
        this.G = new Vector();
        this.H = null;
    }

    public void setMaxHistory(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.F = n;
    }

    public int getMaxHistory() {
        return this.F;
    }

    public void flushHistory() {
        this.H = null;
        this.G.removeAllElements();
    }

    public int getHistorySize() {
        return this.G.size();
    }

    public void addHistory(Object object) {
        int n;
        byte[] byArray = History.a(object);
        if (byArray == null) {
            return;
        }
        if (this.H != null && (n = this.G.indexOf(this.H)) >= 0 && n < this.G.size() - 1) {
            try {
                while (n + 1 <= this.G.size() - 1) {
                    this.G.removeElementAt(n + 1);
                }
            }
            catch (Exception exception) {
                if (d.d) {
                    System.out.println(n);
                }
                exception.printStackTrace();
            }
        }
        this.H = byArray;
        this.G.addElement(byArray);
        while (this.G.size() > this.F) {
            this.G.removeElementAt(0);
        }
    }

    public boolean hasUndo() {
        if (this.H == null) {
            return false;
        }
        if (this.G.size() == 0) {
            return false;
        }
        int n = this.G.indexOf(this.H);
        return n > 0;
    }

    public boolean hasRedo() {
        if (this.H == null) {
            return false;
        }
        int n = this.G.indexOf(this.H);
        return n >= 0 && n < this.G.size() - 1;
    }

    @Deprecated
    public boolean isHasUndo() {
        return this.hasUndo();
    }

    @Deprecated
    public boolean isHasRedo() {
        return this.hasRedo();
    }

    public Object getLastHistory() {
        if (this.G.size() == 0) {
            return null;
        }
        return this.G.lastElement();
    }

    public Object getCurrentHistory() {
        return this.H;
    }

    public Object undo() {
        if (this.H == null) {
            return null;
        }
        int n = this.G.indexOf(this.H);
        if (n < 0) {
            return null;
        }
        if (n > 0) {
            this.H = this.G.elementAt(n - 1);
            return History.readBytes(this.H);
        }
        return null;
    }

    public Object redo() {
        if (this.H == null) {
            return null;
        }
        int n = this.G.indexOf(this.H);
        if (n < 0) {
            return null;
        }
        if (n >= 0 && n < this.G.size() - 1) {
            this.H = this.G.elementAt(n + 1);
            return History.readBytes(this.H);
        }
        return null;
    }

    private static byte[] a(Object object) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            if (exception instanceof NotSerializableException) {
                NotSerializableException notSerializableException = (NotSerializableException)exception;
                notSerializableException.fillInStackTrace();
            }
            exception.printStackTrace();
            return null;
        }
    }

    public static Object readBytes(byte[] byArray) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Object object = objectInputStream.readObject();
            byteArrayInputStream.close();
            return object;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

