/*
 * Decompiled with CFR 0.152.
 */
package com.kt.util;

import com.kt.io.FileIOUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompressData {
    private static Log E = LogFactory.getLog(CompressData.class);

    public static byte[] compress(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            E.error((Object)"", (Throwable)exception);
            return null;
        }
    }

    public static byte[] compressUnsafe(Object object) {
        if (object == null) {
            return null;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(gZIPOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            E.error((Object)"", (Throwable)exception);
            return null;
        }
    }

    public static byte[] decompress(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            byte[] byArray2 = FileIOUtil.readBytes(gZIPInputStream);
            gZIPInputStream.close();
            byteArrayInputStream.close();
            return byArray2;
        }
        catch (IOException iOException) {
            E.debug((Object)"", (Throwable)iOException);
            return byArray;
        }
        catch (Exception exception) {
            E.error((Object)"", (Throwable)exception);
            return null;
        }
    }

    public static Object decompressUnsafe(Object object) {
        if (object == null || !(object instanceof byte[])) {
            return object;
        }
        byte[] byArray = (byte[])object;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            ObjectInputStream objectInputStream = new ObjectInputStream(gZIPInputStream);
            Object object2 = objectInputStream.readObject();
            objectInputStream.close();
            gZIPInputStream.close();
            byteArrayInputStream.close();
            return object2;
        }
        catch (IOException iOException) {
            E.debug((Object)"", (Throwable)iOException);
            return object;
        }
        catch (Exception exception) {
            E.error((Object)"", (Throwable)exception);
            return null;
        }
    }
}

