/*
 * Decompiled with CFR 0.152.
 */
package com.kt.util;

import com.kt.io.Base64Decoder;
import com.kt.io.Base64Encoder;
import com.kt.util.CompressData;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Base64Util {
    private static Log E = LogFactory.getLog(Base64Util.class);

    protected Base64Util() {
    }

    public static String encodeURLSafe(String string) {
        E.debug((Object)("encodeURLSafeBase64 src[" + string + "]"));
        String string2 = null;
        try {
            string2 = Base64Encoder.encode(string.getBytes("UTF-8"));
            string2 = string2.replaceAll("\r\n", "");
            string2 = string2.replaceAll("\n", "");
            string2 = string2.replaceAll("\r", "");
            string2 = string2.replaceAll("\\/", "\\_");
            string2 = string2.replaceAll("\\+", "\\-");
            E.debug((Object)("encodeURLSafeBase64 tmp[" + string2 + "]"));
        }
        catch (Exception exception) {
            E.error((Object)"", (Throwable)exception);
        }
        E.debug((Object)("encodeURLSafeBase64 dst[" + string2 + "]"));
        return string2;
    }

    public static String decodeURLSafe(String string) {
        E.debug((Object)("decodeURLSafeBase64 src[" + string + "]"));
        String string2 = null;
        try {
            string2 = string.replaceAll("_", "\\/");
            string2 = string2.replaceAll("-", "\\+");
            E.debug((Object)("decodeURLSafeBase64 tmp[" + string2 + "]"));
            if (E.isDebugEnabled()) {
                StringBuilder stringBuilder = new StringBuilder();
                byte[] byArray = Base64Decoder.decode(string2);
                for (int i = 0; i < byArray.length; ++i) {
                    stringBuilder.append(String.format(" %02x", byArray[i]));
                }
                E.debug((Object)("decodeURLSafeBase64 hex[" + stringBuilder.toString().substring(1) + "]"));
            }
            string2 = new String(Base64Decoder.decode(string2), "UTF-8");
        }
        catch (Exception exception) {
            E.error((Object)"", (Throwable)exception);
        }
        E.debug((Object)("decodeURLSafeBase64 dst[" + string2 + "]"));
        return string2;
    }

    public static String encodeAndCompress(String string) {
        return Base64Util.encodeAndCompress(string, "MS932");
    }

    public static String encodeAndCompress(String string, String string2) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            E.error((Object)"", (Throwable)unsupportedEncodingException);
            return null;
        }
        byte[] byArray2 = CompressData.compress(byArray);
        Base64Encoder base64Encoder = new Base64Encoder();
        String string3 = Base64Encoder.encode(byArray2);
        return string3;
    }

    public static String decodeAndDecompress(String string) {
        return Base64Util.decodeAndDecompress(string, "MS932");
    }

    public static String decodeAndDecompress(String string, String string2) {
        Base64Decoder base64Decoder = new Base64Decoder();
        byte[] byArray = Base64Decoder.decode(string);
        byte[] byArray2 = CompressData.decompress(byArray);
        String string3 = null;
        try {
            string3 = new String(byArray2, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            E.error((Object)"", (Throwable)unsupportedEncodingException);
            return null;
        }
        return string3;
    }
}

