/*
 * Decompiled with CFR 0.152.
 */
package com.kt.gui;

import javax.swing.UIManager;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SwingLookAndFeelUtil {
    public static final String METAL = "javax.swing.plaf.metal.MetalLookAndFeel";
    public static final String NIMBUS = "com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel";
    public static final String WINDOWS = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    public static final String WINDOWS_CLASSIC = "com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel";
    public static final String MOTIF = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
    public static final String GTK = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
    public static final String MAC = "com.sun.java.swing.plaf.mac.MacLookAndFeel";
    private static final Log i = LogFactory.getLog(SwingLookAndFeelUtil.class);

    protected SwingLookAndFeelUtil() {
    }

    public static boolean useSystem() {
        return SwingLookAndFeelUtil.useLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    }

    public static boolean useDefaultMetal() {
        MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
        return SwingLookAndFeelUtil.useLookAndFeel(METAL);
    }

    public static boolean useOceanMetal() {
        MetalLookAndFeel.setCurrentTheme(new OceanTheme());
        return SwingLookAndFeelUtil.useLookAndFeel(METAL);
    }

    public static boolean useNimbus() {
        return SwingLookAndFeelUtil.useLookAndFeel(NIMBUS);
    }

    public static boolean useWindows() {
        return SwingLookAndFeelUtil.useLookAndFeel(WINDOWS);
    }

    public static boolean useWindowsClassic() {
        return SwingLookAndFeelUtil.useLookAndFeel(WINDOWS_CLASSIC);
    }

    public static boolean useLookAndFeel(String string) {
        boolean bl = false;
        try {
            UIManager.setLookAndFeel(string);
            bl = true;
        }
        catch (Exception exception) {
            i.error((Object)"", (Throwable)exception);
        }
        return bl;
    }
}

