/*
 * Decompiled with CFR 0.152.
 */
package option.gad.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import option.gad.core.util.SetNotNullDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionUtil {
    protected CollectionUtil() {
    }

    public static int indexOf(Collection<?> collection2, Object object) {
        int n = -1;
        if (collection2 == null) {
            return -1;
        }
        if (object == null) {
            return -1;
        }
        int n2 = 0;
        for (Collection<?> collection2 : collection2) {
            if (collection2 == object) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    public static <T> T get(Collection<T> object, int n) {
        if (object == null) {
            return null;
        }
        if (n < 0 || object.size() <= n) {
            return null;
        }
        T t = null;
        int n2 = 0;
        object = object.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            if (n2 == n) {
                t = (T)e;
                break;
            }
            ++n2;
        }
        return t;
    }

    @Deprecated
    public static <T> T getLeftNextObject(Collection<T> collection, T t) {
        return CollectionUtil.getPrev(collection, t);
    }

    public static <T> T getPrev(Collection<T> collection, T t) {
        if (collection == null) {
            return null;
        }
        if (t == null) {
            return null;
        }
        int n = CollectionUtil.indexOf(collection, t);
        if (n == -1) {
            return null;
        }
        if (n == 0) {
            return null;
        }
        return CollectionUtil.get(collection, n - 1);
    }

    @Deprecated
    public static <T> T getRightNextObject(Collection<T> collection, T t) {
        return CollectionUtil.getNext(collection, t);
    }

    public static <T> T getNext(Collection<T> collection, T t) {
        if (collection == null) {
            return null;
        }
        if (t == null) {
            return null;
        }
        int n = CollectionUtil.indexOf(collection, t);
        if (n == -1) {
            return null;
        }
        if (n == collection.size() - 1) {
            return null;
        }
        return CollectionUtil.get(collection, n + 1);
    }

    @Deprecated
    public static <T> T getFirstObject(Collection<T> collection) {
        return CollectionUtil.getFirst(collection);
    }

    public static <T> T getFirst(Collection<T> collection) {
        if (collection == null) {
            return null;
        }
        return collection.iterator().next();
    }

    @Deprecated
    public static <T> T getLastObject(Collection<T> collection) {
        return CollectionUtil.getLast(collection);
    }

    public static <T> T getLast(Collection<T> collection) {
        if (collection == null) {
            return null;
        }
        return CollectionUtil.get(collection, collection.size() - 1);
    }

    public static <T, U extends T, V extends Collection<U>> V addAll(V object, V ... object2) {
        if (object == null) {
            object = new ArrayList();
        }
        if (object2 == null) {
            return (V)object;
        }
        V[] VArray = object2;
        int n = ((V[])object2).length;
        int n2 = 0;
        while (n2 < n) {
            object2 = VArray[n2];
            object.addAll(object2);
            ++n2;
        }
        return (V)object;
    }

    public static <T, U extends T, V extends Collection<T>> V merge(V ... VArray) {
        return (V)CollectionUtil.addAll(null, VArray);
    }

    public static <T> void sort(Collection<T> collection, Comparator<T> comparator) {
        LinkedList<T> linkedList = new LinkedList<T>(collection);
        Collections.sort(linkedList, comparator);
        collection.clear();
        collection.addAll(linkedList);
    }

    public static <T, U> Collection<T> collect(Collection<U> collection2, Class<T> clazz) {
        SetNotNullDecorator<Collection<U>> setNotNullDecorator = new SetNotNullDecorator<Collection<U>>(new LinkedHashSet());
        for (Collection<U> collection2 : collection2) {
            if (!clazz.isInstance(collection2)) continue;
            setNotNullDecorator.add(collection2);
        }
        return setNotNullDecorator;
    }

    public static <V, T extends Collection<V>> T valueFilter(T object, T t, Object[] objectArray) {
        Iterator<V> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            boolean bl = false;
            Object[] objectArray2 = objectArray;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object2 = objectArray2[n2];
                if (object == object2 || object != null && object.equals(object2)) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (bl) continue;
            t.add(object);
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V, T extends Map<K, V>> T valueFilter(T object2, T t, Object[] objectArray) {
        void var1_3;
        for (Map.Entry entry : object2.entrySet()) {
            void var2_4;
            boolean bl = false;
            void var8_10 = var2_4;
            int n = ((void)var8_10).length;
            int n2 = 0;
            while (n2 < n) {
                void var5_7 = var8_10[n2];
                if (entry.getValue() == var5_7 || entry.getValue() != null && entry.getValue().equals(var5_7)) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (bl) continue;
            var1_3.put(entry.getKey(), entry.getValue());
        }
        return var1_3;
    }
}

