/*
 * Decompiled with CFR 0.152.
 */
package option.gad.core.dao;

import com.kt.io.AbstFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import option.gad.core.io.FileIOUtil;

public class TextDao {
    protected AbstFile mInputAbstFile = null;
    protected OutputStream mOutputStream = null;
    protected AbstFile mOutputAbstFile = null;

    public String load() {
        String string = FileIOUtil.readText(this.mInputAbstFile.getReadInputStreamFromBuffer(), "MS932");
        this.mInputAbstFile.closeReadFileFromBuffer();
        return string;
    }

    public void save(String string) {
        PrintStream printStream = new PrintStream(this.mOutputAbstFile.getOutpuStreamToBuffer());
        printStream.print(string);
        this.mOutputAbstFile.closeNewFileToBuffer();
        this.mOutputAbstFile.BufferToOutputStream(this.mOutputStream);
        FileIOUtil.close(printStream);
        FileIOUtil.close(this.mOutputStream);
    }

    public void setInput(File file) {
        InputStream inputStream;
        try {
            inputStream = new GZIPInputStream(new FileInputStream(file));
        }
        catch (Exception exception) {
            try {
                inputStream = new FileInputStream(file);
            }
            catch (Exception exception2) {
                throw new RuntimeException(exception);
            }
        }
        this.setInput(inputStream);
    }

    public void setInput(InputStream inputStream) {
        AbstFile abstFile = new AbstFile();
        abstFile.inputStreamToBuffer(inputStream, "");
        this.setInput(abstFile);
    }

    public void setInput(AbstFile abstFile) {
        this.mInputAbstFile = abstFile;
    }

    public void setOutput(File file) {
        this.setOutput(file, false);
    }

    public void setOutput(File file, boolean bl) {
        OutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(file);
            if (bl) {
                outputStream = new GZIPOutputStream(outputStream);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        this.setOutput(outputStream);
    }

    public void setOutput(OutputStream outputStream) {
        this.mOutputStream = outputStream;
        outputStream = new AbstFile();
        outputStream.openNewFileToBuffer("");
        this.setOutput((AbstFile)outputStream);
    }

    public void setOutput(AbstFile abstFile) {
        this.mOutputAbstFile = abstFile;
    }
}

