/*
 * Decompiled with CFR 0.152.
 */
package option.gad.core.dao;

import com.kt.annotation.Reflectable;
import com.kt.util.StringUtil;
import com.kt.util.tree.ObjectFolder;
import com.kt.util.tree.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import option.gad.core.annotation.GdPrefix;
import option.gad.core.annotation.GdProperty;
import option.gad.core.annotation.GdVersion;
import option.gad.core.dao.GdSaveFileDao;
import option.gad.core.util.ObjectFolderUtil;
import option.gad.core.util.ObjectNodeUtil;
import option.gad.core.util.ReflectUtil;
import org.apache.commons.lang.math.NumberUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GdAbstractSaveFileDao<IN, OUT, DOC>
implements GdSaveFileDao<IN, OUT, DOC> {
    protected HashMap<SaveFileStatus, List<String>> mMessageListMap = new HashMap();
    protected SaveFileStatus mStatus = SaveFileStatus.NORMAL;

    protected GdAbstractSaveFileDao() {
        this.init();
    }

    protected void init() {
        SaveFileStatus[] saveFileStatusArray = SaveFileStatus.values();
        int n = saveFileStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            SaveFileStatus saveFileStatus = saveFileStatusArray[n2];
            this.mMessageListMap.put(saveFileStatus, new ArrayList());
            ++n2;
        }
    }

    protected <T> void saveFolder(ObjectFolder objectFolder, String string, T t) {
        if (t == null) {
            return;
        }
        objectFolder.addChild((ObjectNode)ObjectFolderUtil.createFolder(t, string, GdProperty.class));
    }

    protected <T> void saveFolders(ObjectFolder objectFolder, String string, String string2, Collection<T> collection2) {
        if (collection2 == null || collection2.isEmpty()) {
            return;
        }
        string = ObjectFolderUtil.createFolder(collection2, string, GdProperty.class);
        for (Collection<T> collection2 : collection2) {
            string.addChild((ObjectNode)ObjectFolderUtil.createFolder(collection2, string2, GdProperty.class), true);
        }
        objectFolder.addChild((ObjectNode)string);
    }

    protected abstract Class<?>[] configLoadClasses();

    protected Class<?> findClass(String string, int n) {
        Class<?> clazz;
        String string2;
        if (n == 0) {
            string2 = string;
        } else {
            clazz = "V" + n;
            string2 = String.valueOf(string) + (String)((Object)clazz);
        }
        clazz = null;
        Class<?>[] classArray = this.configLoadClasses();
        int n2 = classArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Class<?> clazz2 = classArray[n3];
            Object object = clazz2.getAnnotation(Reflectable.class);
            assert (object != null) : "Reflectable not found from " + clazz2.getSimpleName() + ".";
            GdPrefix gdPrefix = clazz2.getAnnotation(GdPrefix.class);
            object = object.name();
            String string3 = string2;
            if (gdPrefix != null) {
                string3 = String.valueOf(gdPrefix.name()) + string2;
            }
            if (string.equals(object)) {
                clazz = clazz2;
                break;
            }
            if (string2.equals(object)) {
                clazz = clazz2;
                break;
            }
            if (string3.equals(object)) {
                clazz = clazz2;
                break;
            }
            ++n3;
        }
        assert (!StringUtil.isEmpty((String)string)) : "clazzName is empty.";
        if (clazz == null) {
            clazz = ReflectUtil.getClass(string);
        }
        return clazz;
    }

    protected <T> T loadFolder(ObjectFolder objectFolder, String string) {
        return this.loadFolder(objectFolder, string, "");
    }

    protected <T> T loadFolder(ObjectFolder objectFolder, String string, Class<?> clazz) {
        Reflectable reflectable = clazz.getAnnotation(Reflectable.class);
        assert (reflectable != null) : "Reflectable not found from " + clazz.getSimpleName() + ".";
        return this.loadFolder(objectFolder, string, reflectable.name());
    }

    protected <T> T loadFolder(ObjectFolder object, String string, String string2) {
        if ((object = ObjectFolderUtil.findChildFolders((ObjectFolder)object, (String)string)).size() != 1) {
            return null;
        }
        object = (ObjectFolder)object.iterator().next();
        return this.createObject((ObjectFolder)object, string, string2);
    }

    protected <T> Collection<T> loadFolders(ObjectFolder objectFolder, String string, String string2) {
        return this.loadFolders(objectFolder, string, string2, "");
    }

    protected <T> Collection<T> loadFolders(ObjectFolder objectFolder, String string, String string2, Class<?> clazz) {
        Reflectable reflectable = clazz.getAnnotation(Reflectable.class);
        assert (reflectable != null) : "Reflectable not found from " + clazz.getSimpleName() + ".";
        return this.loadFolders(objectFolder, string, string2, reflectable.name());
    }

    protected <T> Collection<T> loadFolders(ObjectFolder object4, String string, String object2, String string2) {
        if ((object4 = ObjectFolderUtil.findChildFolders((ObjectFolder)object4, (String)string)).size() != 1) {
            return null;
        }
        Object object3 = ObjectNodeUtil.toString((object4 = (ObjectFolder)object4.iterator().next()).getNode("type"));
        if (StringUtil.isEmpty((String)object3)) {
            object3 = ArrayList.class.getName();
        }
        object3 = (Collection)ReflectUtil.newInstance((String)object3, new Object[0]);
        object4 = ObjectFolderUtil.findChildFolders((ObjectFolder)object4, (String)object2);
        for (Object object4 : object4) {
            object4 = this.createObject((ObjectFolder)object4, string, string2);
            object3.add(object4);
        }
        return object3;
    }

    protected <T> T createObject(ObjectFolder objectFolder, String clazz, String string) {
        String string2 = ObjectNodeUtil.toString(objectFolder.getNode("type"));
        if (StringUtil.isEmpty((String)string2)) {
            string2 = string;
        }
        if (StringUtil.isEmpty((String)string2)) {
            throw new IllegalStateException("type not found from '" + (String)((Object)clazz) + "' node.");
        }
        clazz = null;
        int n = this.getDaoVersion();
        while (n >= 0) {
            try {
                clazz = this.findClass(string2, n);
                if (clazz != null) {
                    break;
                }
            }
            catch (Exception exception) {}
            --n;
        }
        if (clazz == null) {
            if (StringUtil.isEmpty((String)string)) {
                throw new IllegalStateException("default-type not found.");
            }
            clazz = this.findClass(string, 0);
            if (clazz == null) {
                throw new IllegalStateException("class not found from '" + string2 + "' type.");
            }
        }
        return ObjectFolderUtil.createObject(clazz, objectFolder, GdProperty.class);
    }

    protected int getDaoVersion() {
        Object object = this.getClass().getAnnotation(GdVersion.class);
        object = object != null ? object.value().replaceAll("\\.", "") : "";
        return NumberUtils.toInt((String)object, (int)0);
    }

    public String getSaveDataVersion() {
        GdVersion gdVersion = this.getClass().getAnnotation(GdVersion.class);
        return StringUtil.emptyToDefault((String)gdVersion.value(), (String)"Unknown");
    }

    protected Integer getBuildNumber() {
        String string = "0";
        try {
            Properties properties = new Properties();
            properties.load(this.getClass().getClassLoader().getResourceAsStream("buildnumber.properties"));
            string = (String)properties.get("build.number");
        }
        catch (Exception exception) {}
        return Integer.parseInt(string);
    }

    @Deprecated
    public List<String> getMessageList() {
        return this.mMessageListMap.get((Object)SaveFileStatus.NORMAL);
    }

    public List<String> getAllMessageList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        SaveFileStatus[] saveFileStatusArray = SaveFileStatus.values();
        int n = saveFileStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            SaveFileStatus saveFileStatus = saveFileStatusArray[n2];
            arrayList.addAll((Collection<String>)this.mMessageListMap.get((Object)saveFileStatus));
            ++n2;
        }
        return arrayList;
    }

    public Map<SaveFileStatus, List<String>> getMessageListMap() {
        return this.mMessageListMap;
    }

    public void clearAllMessages() {
        SaveFileStatus[] saveFileStatusArray = SaveFileStatus.values();
        int n = saveFileStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            SaveFileStatus saveFileStatus = saveFileStatusArray[n2];
            this.mMessageListMap.get((Object)saveFileStatus).clear();
            ++n2;
        }
    }

    public void setStatus(SaveFileStatus saveFileStatus) {
        this.mStatus = saveFileStatus;
    }

    public void updateStatus(SaveFileStatus saveFileStatus) {
        if (this.mStatus.ordinal() < saveFileStatus.ordinal()) {
            this.mStatus = saveFileStatus;
        }
    }

    public SaveFileStatus getStatus() {
        return this.mStatus;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SaveFileStatus {
        NORMAL,
        WARN,
        ERROR;

    }
}

