/*
 * Decompiled with CFR 0.152.
 */
package sandbox.gui.basic;

import java.awt.AWTEventMulticaster;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;
import sandbox.gui.basic.JImageIcon;

public class JGraphicsButton
extends JComponent {
    public static final int STATE_NORMAL = 1;
    public static final int STATE_PRESSED = 0;
    private int mState = 1;
    protected JImageIcon mForeImage;
    protected JImageIcon mFocusImage;
    private ActionListener mActionListener;
    private boolean mMouseEntered;
    private boolean mMousePressed;

    public JGraphicsButton(String string, Image image, Image image2) {
        this.setName(string);
        if (image != null) {
            this.mForeImage = new JImageIcon(image);
        }
        if (image2 != null) {
            this.mFocusImage = new JImageIcon(image2);
        }
        this.addMouseListener(new ButtonMouseAdapter());
        this.addMouseMotionListener(new ButtonMouseMotionAdapter());
    }

    public int getState() {
        return this.mState;
    }

    public Dimension getPreferredSize() {
        if (this.mForeImage != null) {
            return this.mForeImage.getPreferredSize();
        }
        if (this.mFocusImage != null) {
            return this.mFocusImage.getPreferredSize();
        }
        return super.getPreferredSize();
    }

    protected void setState(int n) {
        if (this.mState == n || n != 1 && n != 0) {
            return;
        }
        this.mState = n;
    }

    public void setEnabled(boolean bl) {
        if (this.isEnabled() == bl) {
            return;
        }
        if (this.mForeImage != null) {
            this.mForeImage.setEnabled(bl);
        }
        super.setEnabled(bl);
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        if (this.mForeImage != null) {
            this.mForeImage.paintComponent(graphics);
        }
        if (!this.isEnabled()) {
            return;
        }
        if (this.mMouseEntered && this.mFocusImage != null) {
            this.mFocusImage.paintComponent(graphics);
        }
    }

    protected void paintButtonNormal() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.getState() == 0) {
            Point point = this.getLocation();
            this.setLocation(point.x - 1, point.y - 1);
        }
        this.setState(1);
    }

    protected void paintButtonPressed() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.getState() == 1) {
            Point point = this.getLocation();
            this.setLocation(point.x + 1, point.y + 1);
        }
        this.setState(0);
    }

    public void addActionListener(ActionListener actionListener) {
        this.mActionListener = AWTEventMulticaster.add(this.mActionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.mActionListener = AWTEventMulticaster.remove(this.mActionListener, actionListener);
    }

    protected void dispatchEvent() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.mActionListener != null) {
            this.mActionListener.actionPerformed(new ActionEvent(this, 1001, "GraphicButton Action"));
        }
    }

    class ButtonMouseMotionAdapter
    extends MouseMotionAdapter {
        ButtonMouseMotionAdapter() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (JGraphicsButton.this.contains(mouseEvent.getX(), mouseEvent.getY())) {
                if (JGraphicsButton.this.mState == 1) {
                    JGraphicsButton.this.paintButtonPressed();
                }
            } else if (JGraphicsButton.this.mState == 0) {
                JGraphicsButton.this.paintButtonNormal();
            }
        }
    }

    class ButtonMouseAdapter
    extends MouseAdapter {
        ButtonMouseAdapter() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            JGraphicsButton.this.paintButtonPressed();
            JGraphicsButton.this.mMousePressed = true;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            JGraphicsButton.this.paintButtonNormal();
            if (JGraphicsButton.this.contains(mouseEvent.getX(), mouseEvent.getY())) {
                this.onButtonDown();
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            JGraphicsButton.this.mMouseEntered = true;
            if (JGraphicsButton.this.mFocusImage != null) {
                JGraphicsButton.this.repaint();
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            JGraphicsButton.this.mMouseEntered = false;
            if (JGraphicsButton.this.mFocusImage != null) {
                JGraphicsButton.this.repaint();
            }
        }

        private void onButtonDown() {
            if (JGraphicsButton.this.mMouseEntered && JGraphicsButton.this.mMousePressed) {
                JGraphicsButton.this.dispatchEvent();
                JGraphicsButton.this.mMousePressed = false;
            }
        }
    }
}

