/*
 * Decompiled with CFR 0.152.
 */
package option.swing.mutable.control;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import option.gad.core.inject.GdInjector;
import option.swing.mutable.control.MtControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MtAbstractControl<CMP extends JComponent>
implements MtControl {
    protected MtControl parent;
    protected List<MtControl> children = new ArrayList<MtControl>();
    protected CMP component;
    protected List<JComponent> additionalComponents = new ArrayList<JComponent>();
    protected boolean isEnabled = true;
    protected boolean isInvokeEvent = true;

    public MtAbstractControl() {
        GdInjector.getInstance().inject((Object)this);
    }

    public MtAbstractControl(CMP CMP) {
        this();
        this.bindComponent(CMP);
        this.initControl(CMP);
    }

    public void bindComponent(CMP CMP) {
        this.component = CMP;
    }

    public void bindAdditionalComponent(JComponent jComponent) {
        this.additionalComponents.add(jComponent);
    }

    protected abstract void initControl(CMP var1);

    @Override
    public void updateScreen() {
        if (this.parent == null) {
            this.updateAllIntereface();
        } else {
            this.parent.updateScreen();
        }
    }

    @Override
    public void updateAllIntereface() {
        this.updateIntereface();
        ((JComponent)this.component).setEnabled(this.isEnabled());
        this.updateAdditiomalIntereface();
        for (MtControl mtControl : this.children) {
            mtControl.updateAllIntereface();
        }
    }

    private void updateIntereface() {
        this.isInvokeEvent = false;
        this.updateIntereface(this.component);
        this.isInvokeEvent = true;
    }

    protected abstract void updateIntereface(CMP var1);

    protected void updateAdditiomalIntereface() {
        boolean bl = this.isEnabled();
        for (JComponent jComponent : this.additionalComponents) {
            jComponent.setEnabled(bl);
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    public void register(MtControl mtControl) {
        this.children.add(mtControl);
        mtControl.setParent(this);
    }

    @Override
    public void setParent(MtControl mtControl) {
        this.parent = mtControl;
    }

    protected String formatFloat(float f) {
        Pattern pattern = Pattern.compile("\\.0*$");
        return pattern.matcher(Float.toString(f)).replaceFirst("");
    }
}

