/*
 * Decompiled with CFR 0.152.
 */
package option.pdf;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.text.AttributedCharacterIterator;
import java.text.DecimalFormat;
import option.pdf.PdfCommand;

public class PdfCommandGraphics
extends Graphics {
    public static final String PATTERN_STAR = "Pt101d";
    public static final String SHADING_TYPE2 = "Sh201d";
    public static final float[] SOLID_LINE = new float[]{0.0f, 0.0f};
    public static final String SPACE_FOR_PITCH = "spaceX";
    public static final String SPACE_FOR_CHAR = "scaleX";
    private static final String SEPARATOR_TEXT = "*";
    public static final String SEPARATOR_GRAPHICS = ",";
    private static final String SEPARATOR_COMMAND = " ";
    private static final String STRING_QUOTAION = "#";
    private static final String CMD_ARC = "arc";
    private static final String CMD_IMAGE = "image";
    private static final String CMD_JPEG = "jpeg";
    private static final String CMD_ITEM_IMAGE = "itemimage";
    private static final String CMD_ITEM_TEXT = "itemtext";
    private static final String CMD_LINE = "line";
    private static final String CMD_LINK = "link";
    private static final String CMD_POLYGON = "polygon";
    private static final String CMD_POLYLINE = "polyline";
    private static final String CMD_RECT = "rect";
    private static final String CMD_TEXT = "text";
    private static final String CMD_GROUP_POLYGON = "grouppolygon";
    private static final String CMD_PATTERN = "pattern";
    private static final String CMD_SHADING = "shading";
    public static final String CMD_CLIP = "clip";
    public static final String CMD_UNCLIP = "unclip";
    private static final String CMD_3D = "3d";
    private static final float FONT_SKEW = 20.0f;
    private static final float PT_TO_MM = 0.35278347f;
    private static final String DRAW = "0";
    private static final String FILL = "1";
    private static final String PLAIN = "0";
    private static final String BOLD = "2";
    private static final String EMBED = "1";
    private static final float TEXT_WIDTH = 0.0f;
    private float mFontSkew = 20.0f;
    private PdfCommand mPdfCmd;
    private Color mColor;
    private float mLineWidth;
    private float[] mLinePattern;
    private String mFontName;
    private int mFontStyle;
    private float mFontSize;
    private boolean mIsFontEmbedded;
    private float mOriginX;
    private float mOriginY;
    private DecimalFormat mFormat;

    protected PdfCommandGraphics(PdfCommand pdfCommand) {
        this.mPdfCmd = pdfCommand;
        this.mFormat = new DecimalFormat("####0.####");
        this.reset();
    }

    protected void reset() {
        this.mColor = new Color(0, 0, 0);
        this.mFontName = "MS GOTHIC";
        this.mFontStyle = 0;
        this.mFontSize = 12.0f;
        this.mLineWidth = 1.0f;
        this.mLinePattern = SOLID_LINE;
        this.mOriginX = 0.0f;
        this.mOriginY = 0.0f;
    }

    public void dispose() {
        this.mPdfCmd.endPage();
        this.reset();
    }

    public void translate(int n, int n2) {
        this.translate((float)n, (float)n2);
    }

    public void translate(float f, float f2) {
        this.mOriginX += f;
        this.mOriginY += f2;
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.setClip((float)n, (float)n2, (float)n3, (float)n4);
    }

    public void setClip(float f, float f2, float f3, float f4) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CMD_CLIP);
        stringBuffer.append(SEPARATOR_COMMAND);
        this.drawRect(f, f2, f3, f4, stringBuffer, SEPARATOR_GRAPHICS);
        this.mPdfCmd.draw(stringBuffer.toString());
    }

    public void releaseClip() {
        this.mPdfCmd.draw(CMD_UNCLIP);
    }

    public Color getColor() {
        return new Color(this.mColor.getRed(), this.mColor.getGreen(), this.mColor.getBlue(), this.mColor.getAlpha());
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new NullPointerException();
        }
        this.mColor = color;
    }

    public Font getFont() {
        return new Font(this.mFontName, this.mFontStyle, (int)this.mFontSize);
    }

    public String getFontName() {
        return this.mFontName;
    }

    public int getFontStyle() {
        return this.mFontStyle;
    }

    public float getFontSize() {
        return this.mFontSize;
    }

    public boolean isFontEmbedded() {
        return this.mIsFontEmbedded;
    }

    public void setFont(Font font) {
        this.setFontName(font.getName());
        this.setFontStyle(font.getStyle());
        this.setFontSize(font.getSize());
    }

    public void setFont(String string, int n, float f) {
        this.setFontName(string);
        this.setFontStyle(n);
        this.setFontSize(f);
    }

    public void setFontName(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.mFontName = string;
    }

    public void setFontStyle(int n) {
        this.mFontStyle = n;
    }

    public void setFontSize(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException();
        }
        this.mFontSize = f;
    }

    public void setFontEmbed(boolean bl) {
        this.mIsFontEmbedded = bl;
    }

    public void setLinePattern(float[] fArray) {
        this.mLinePattern = new float[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            if (fArray[i] < 0.0f) {
                throw new IllegalArgumentException("negative line pattern");
            }
            this.mLinePattern[i] = fArray[i];
        }
    }

    public float[] getLinePattern() {
        float[] fArray = new float[this.mLinePattern.length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = this.mLinePattern[i];
        }
        return fArray;
    }

    public void setLineWidth(float f) {
        if (f <= 0.0f) {
            throw new IllegalArgumentException("negative or 0 line width");
        }
        this.mLineWidth = f;
    }

    public float getLineWidth() {
        return this.mLineWidth;
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.drawArc(n, n2, n3, n4, n5, n6, false);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.drawArc(n, n2, n3, n4, n5, n6, true);
    }

    public void drawArc(float f, float f2, float f3, float f4, float f5, float f6, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CMD_ARC);
        stringBuffer.append(SEPARATOR_COMMAND);
        if (this.mPdfCmd.getUserCoordinateDirectionY() == 1) {
            f2 -= f4;
        }
        this.appendPosition(stringBuffer, SEPARATOR_GRAPHICS, f + f3 / 2.0f, f2 + f4 / 2.0f);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        this.appendSize(stringBuffer, SEPARATOR_GRAPHICS, f3 / 2.0f, f4 / 2.0f);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        stringBuffer.append(this.format(f5));
        stringBuffer.append(SEPARATOR_GRAPHICS);
        stringBuffer.append(this.format(f6));
        stringBuffer.append(SEPARATOR_GRAPHICS);
        this.appendColor(stringBuffer, SEPARATOR_GRAPHICS);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        stringBuffer.append(bl ? "1" : "0");
        stringBuffer.append(SEPARATOR_GRAPHICS);
        this.appendLineWidth(stringBuffer);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        this.appendLinePattern(stringBuffer, SEPARATOR_GRAPHICS);
        this.mPdfCmd.draw(stringBuffer.toString());
    }

    public void drawPatternedGroupPolygon(String string, float[] fArray, float[] fArray2, int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CMD_PATTERN);
        stringBuffer.append(SEPARATOR_COMMAND);
        stringBuffer.append(string);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        this.drawGroupPolygon(stringBuffer, fArray, fArray2, nArray, true);
        this.mPdfCmd.draw(stringBuffer.toString());
    }

    public void drawShadingGroupPolygon(String string, float[] fArray, float[] fArray2, int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CMD_SHADING);
        stringBuffer.append(SEPARATOR_COMMAND);
        stringBuffer.append(string);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        this.drawGroupPolygon(stringBuffer, fArray, fArray2, nArray, true);
        this.mPdfCmd.draw(stringBuffer.toString());
    }

    public void drawGroupPolygon(float[] fArray, float[] fArray2, int[] nArray, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        this.drawGroupPolygon(stringBuffer, fArray, fArray2, nArray, bl);
        this.mPdfCmd.draw(stringBuffer.toString());
    }

    private void drawGroupPolygon(StringBuffer stringBuffer, float[] fArray, float[] fArray2, int[] nArray, boolean bl) {
        stringBuffer.append(CMD_GROUP_POLYGON);
        stringBuffer.append(SEPARATOR_COMMAND);
        this.appendColor(stringBuffer, SEPARATOR_GRAPHICS);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        stringBuffer.append(bl ? "1" : "0");
        stringBuffer.append(SEPARATOR_GRAPHICS);
        stringBuffer.append(nArray.length);
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(SEPARATOR_GRAPHICS);
            stringBuffer.append(nArray[i]);
            int n2 = 0;
            while (n2 < nArray[i]) {
                stringBuffer.append(SEPARATOR_GRAPHICS);
                this.appendPosition(stringBuffer, SEPARATOR_GRAPHICS, fArray[n], fArray2[n]);
                ++n2;
                ++n;
            }
        }
        stringBuffer.append(SEPARATOR_GRAPHICS);
        this.appendLineWidth(stringBuffer);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        this.appendLinePattern(stringBuffer, SEPARATOR_GRAPHICS);
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.drawImage(image, (float)n, (float)n2, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.drawImage(image, (float)n, (float)n2, (float)n3, (float)n4, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        int n9 = Math.abs(n3 - n);
        int n10 = Math.abs(n4 - n2);
        int n11 = n < n3 ? n : n3;
        int n12 = n2 < n4 ? n2 : n4;
        int[] nArray = new int[n9 * n10];
        PixelGrabber pixelGrabber = new PixelGrabber(image, n11, n12, n9, n10, nArray, 0, n9);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("interrupted waiting for pixels");
            return false;
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return false;
        }
        int n13 = n5 < n7 ? n5 : n7;
        int n14 = n6 < n8 ? n6 : n8;
        int n15 = Math.abs(n7 - n5);
        int n16 = Math.abs(n8 - n6);
        return this.drawImage(nArray, (float)n13, (float)n14, (float)n9, (float)n10, (float)n15, (float)n16, 30.0f);
    }

    public boolean drawImage(Image image, float f, float f2, float f3, float f4, ImageObserver imageObserver) {
        if (image == null || imageObserver == null) {
            return false;
        }
        int n = image.getWidth(imageObserver);
        int n2 = image.getHeight(imageObserver);
        return this.drawImage(image, f, f2, (float)n, (float)n2, f3, f4, 0.0f);
    }

    public boolean drawImage(String string, float f, float f2) {
        if (string == null) {
            return false;
        }
        return this.drawImage(string, f, f2, 0.0f, 0.0f);
    }

    public boolean drawImage(String string, float f, float f2, float f3, float f4) {
        if (string == null) {
            return false;
        }
        return this.drawImage(string, f, f2, 0.0f, 0.0f, f3, f4, 0.0f);
    }

    public boolean drawImageAsJpeg(String string, float f, float f2, float f3, float f4) {
        if (string == null) {
            return false;
        }
        return this.drawImage(CMD_JPEG, string, f, f2, 0.0f, 0.0f, f3, f4, 0.0f);
    }

    public boolean drawImage(Image image, float f, float f2, ImageObserver imageObserver) {
        if (image == null || imageObserver == null) {
            return false;
        }
        int n = image.getWidth(imageObserver);
        int n2 = image.getHeight(imageObserver);
        float f3 = (float)n * 0.35278347f;
        float f4 = (float)n2 * 0.35278347f;
        return this.drawImage(image, f, f2, (float)n, (float)n2, f3, f4, 0.0f);
    }

    private boolean drawImage(Image image, float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        int[] nArray = this.toPixels(image, (int)f3, (int)f4);
        if (nArray == null) {
            return false;
        }
        return this.drawImage(nArray, f, f2, f3, f4, f5, f6, f7);
    }

    public boolean drawImageAsJpeg(byte[] byArray, float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        if (!this.drawImage(CMD_JPEG, this.mPdfCmd.getImageName(), f, f2, f3, f4, f5, f6, f7)) {
            return false;
        }
        this.mPdfCmd.draw(byArray);
        return true;
    }

    private boolean drawImage(int[] nArray, float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        if (!this.drawImage(this.mPdfCmd.getImageName(), f, f2, f3, f4, f5, f6, f7)) {
            return false;
        }
        this.mPdfCmd.draw(nArray);
        return true;
    }

    private boolean drawImage(String string, float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CMD_IMAGE);
        stringBuffer.append(SEPARATOR_COMMAND);
        stringBuffer.append(string);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        stringBuffer.append(f3);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        stringBuffer.append(f4);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        float f8 = f2;
        float f9 = f2;
        f9 = this.mPdfCmd.getUserCoordinateDirectionY() == 0 ? (f9 += f6) : (f9 -= f6);
        this.appendPosition(stringBuffer, SEPARATOR_GRAPHICS, f, f8);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        this.appendPosition(stringBuffer, SEPARATOR_GRAPHICS, f + f5, f9);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        stringBuffer.append(f7);
        this.mPdfCmd.draw(stringBuffer.toString());
        return true;
    }

    private boolean drawImage(String string, String string2, float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(SEPARATOR_COMMAND);
        stringBuffer.append(string2);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        stringBuffer.append(f3);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        stringBuffer.append(f4);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        float f8 = f2;
        float f9 = f2;
        f9 = this.mPdfCmd.getUserCoordinateDirectionY() == 0 ? (f9 += f6) : (f9 -= f6);
        this.appendPosition(stringBuffer, SEPARATOR_GRAPHICS, f, f8);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        this.appendPosition(stringBuffer, SEPARATOR_GRAPHICS, f + f5, f9);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        stringBuffer.append(f7);
        this.mPdfCmd.draw(stringBuffer.toString());
        return true;
    }

    private int[] toPixels(Image image, int n, int n2) {
        int[] nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("interrupted waiting for pixels");
            return null;
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return null;
        }
        return nArray;
    }

    public void drawItemImage(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CMD_ITEM_IMAGE);
        stringBuffer.append(SEPARATOR_COMMAND);
        stringBuffer.append(string);
        stringBuffer.append(SEPARATOR_COMMAND);
        stringBuffer.append(string2);
        stringBuffer.append(SEPARATOR_COMMAND);
        stringBuffer.append(string3);
        this.mPdfCmd.draw(stringBuffer.toString());
    }

    public void drawItemString(String string, String string2, String string3) {
        if (string == null || string.length() == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CMD_ITEM_TEXT);
        stringBuffer.append(SEPARATOR_COMMAND);
        stringBuffer.append(STRING_QUOTAION);
        stringBuffer.append(string);
        stringBuffer.append(STRING_QUOTAION);
        stringBuffer.append(string2);
        stringBuffer.append(SEPARATOR_TEXT);
        stringBuffer.append(string3);
        this.mPdfCmd.draw(stringBuffer.toString());
    }

    public void drawLink(String string, float f, float f2, float f3, float f4, float f5) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CMD_LINK);
        stringBuffer.append(SEPARATOR_COMMAND);
        stringBuffer.append(string);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        this.appendPosition(stringBuffer, SEPARATOR_GRAPHICS, f, f2);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        this.appendPosition(stringBuffer, SEPARATOR_GRAPHICS, f3, f4);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        this.appendWidth(stringBuffer, f5);
        this.mPdfCmd.draw(stringBuffer.toString());
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.drawLine((float)n, (float)n2, (float)n3, (float)n4);
    }

    public void drawLine(float f, float f2, float f3, float f4) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CMD_LINE);
        stringBuffer.append(SEPARATOR_COMMAND);
        this.appendPosition(stringBuffer, SEPARATOR_GRAPHICS, f, f2);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        this.appendPosition(stringBuffer, SEPARATOR_GRAPHICS, f3, f4);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        this.appendColor(stringBuffer, SEPARATOR_GRAPHICS);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        this.appendLineWidth(stringBuffer);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        this.appendLinePattern(stringBuffer, SEPARATOR_GRAPHICS);
        this.mPdfCmd.draw(stringBuffer.toString());
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        this.drawOval((float)n, (float)n2, (float)n3, (float)n4);
    }

    public void drawOval(float f, float f2, float f3, float f4) {
        this.drawArc(f, f2, f3, f4, 0.0f, 360.0f, false);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        this.fillOval((float)n, (float)n2, (float)n3, (float)n4);
    }

    public void fillOval(float f, float f2, float f3, float f4) {
        this.drawArc(f, f2, f3, f4, 0.0f, 360.0f, true);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CMD_POLYLINE);
        stringBuffer.append(SEPARATOR_COMMAND);
        this.appendColor(stringBuffer, SEPARATOR_GRAPHICS);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        stringBuffer.append(n);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        this.appendPoints(stringBuffer, SEPARATOR_GRAPHICS, this.toFloatArray(nArray), this.toFloatArray(nArray2), n);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        this.appendLineWidth(stringBuffer);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        this.appendLinePattern(stringBuffer, SEPARATOR_GRAPHICS);
        this.mPdfCmd.draw(stringBuffer.toString());
    }

    public void drawPolyline(float[] fArray, float[] fArray2, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CMD_POLYLINE);
        stringBuffer.append(SEPARATOR_COMMAND);
        this.appendColor(stringBuffer, SEPARATOR_GRAPHICS);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        stringBuffer.append(n);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        this.appendPoints(stringBuffer, SEPARATOR_GRAPHICS, fArray, fArray2, n);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        this.appendLineWidth(stringBuffer);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        this.appendLinePattern(stringBuffer, SEPARATOR_GRAPHICS);
        this.mPdfCmd.draw(stringBuffer.toString());
    }

    public void drawPolygon(Polygon polygon) {
        this.drawPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.drawPolygon(this.toFloatArray(nArray), this.toFloatArray(nArray2), n, false);
    }

    public void fillPolygon(Polygon polygon) {
        this.fillPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.drawPolygon(this.toFloatArray(nArray), this.toFloatArray(nArray2), n, true);
    }

    private float[] toFloatArray(int[] nArray) {
        float[] fArray = new float[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            fArray[i] = nArray[i];
        }
        return fArray;
    }

    public void drawPatternedPolygon(String string, float[] fArray, float[] fArray2, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CMD_PATTERN);
        stringBuffer.append(SEPARATOR_COMMAND);
        stringBuffer.append(string);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        this.drawPolygon(stringBuffer, fArray, fArray2, n, true);
        this.mPdfCmd.draw(stringBuffer.toString());
    }

    public void drawShadingPolygon(String string, float[] fArray, float[] fArray2, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CMD_SHADING);
        stringBuffer.append(SEPARATOR_COMMAND);
        stringBuffer.append(string);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        this.drawPolygon(stringBuffer, fArray, fArray2, n, true);
        this.mPdfCmd.draw(stringBuffer.toString());
    }

    public void drawPolygon(float[] fArray, float[] fArray2, int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        this.drawPolygon(stringBuffer, fArray, fArray2, n, bl);
        this.mPdfCmd.draw(stringBuffer.toString());
    }

    private void drawPolygon(StringBuffer stringBuffer, float[] fArray, float[] fArray2, int n, boolean bl) {
        stringBuffer.append(CMD_POLYGON);
        stringBuffer.append(SEPARATOR_COMMAND);
        this.appendColor(stringBuffer, SEPARATOR_GRAPHICS);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        stringBuffer.append(bl ? "1" : "0");
        stringBuffer.append(SEPARATOR_GRAPHICS);
        stringBuffer.append(n);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        this.appendPoints(stringBuffer, SEPARATOR_GRAPHICS, fArray, fArray2, n);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        this.appendLineWidth(stringBuffer);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        this.appendLinePattern(stringBuffer, SEPARATOR_GRAPHICS);
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        this.drawRect(n, n2, n3, n4, false);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.drawRect(n, n2, n3, n4, true);
    }

    public void drawRect(float f, float f2, float f3, float f4, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CMD_RECT);
        stringBuffer.append(SEPARATOR_COMMAND);
        this.drawRect(f, f2, f3, f4, stringBuffer, SEPARATOR_GRAPHICS);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        this.appendColor(stringBuffer, SEPARATOR_GRAPHICS);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        stringBuffer.append(bl ? "1" : "0");
        stringBuffer.append(SEPARATOR_GRAPHICS);
        this.appendLineWidth(stringBuffer);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        this.appendLinePattern(stringBuffer, SEPARATOR_GRAPHICS);
        this.mPdfCmd.draw(stringBuffer.toString());
    }

    private void drawRect(float f, float f2, float f3, float f4, StringBuffer stringBuffer, String string) {
        this.appendPosition(stringBuffer, string, f, f2);
        stringBuffer.append(string);
        float f5 = f2;
        f5 = this.mPdfCmd.getUserCoordinateDirectionY() == 0 ? (f5 += f4) : (f5 -= f4);
        this.appendPosition(stringBuffer, string, f + f3, f5);
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.drawRoundRect(n, n2, n3, n4, n5, n6, false);
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.drawRoundRect(n, n2, n3, n4, n5, n6, true);
    }

    public void drawRoundRect(float f, float f2, float f3, float f4, float f5, float f6, boolean bl) {
        float f7;
        float f8;
        float f9;
        float f10;
        float f11;
        float f12 = f + f5 / 2.0f;
        float f13 = f + f3 - f5 / 2.0f;
        if (this.mPdfCmd.getUserCoordinateDirectionY() == 0) {
            f11 = f2 + f6 / 2.0f;
            f10 = f2 + f4 - f6 / 2.0f;
            f9 = f2;
            f8 = f2 + f4;
            f7 = f2 + f4 - f6;
        } else {
            f11 = f2 - f6 / 2.0f;
            f10 = f2 - f4 + f6 / 2.0f;
            f9 = f2;
            f8 = f2 - f4;
            f7 = f2 - f4 + f6;
        }
        this.drawArc(f, f2, f5, f6, 90.0f, 180.0f, bl);
        this.drawArc(f + f3 - f5, f2, f5, f6, 0.0f, 90.0f, bl);
        this.drawArc(f, f7, f5, f6, 180.0f, 270.0f, bl);
        this.drawArc(f + f3 - f5, f7, f5, f6, 270.0f, 360.0f, bl);
        if (bl) {
            this.drawRect(f12, f9, f3 - f5, f4, bl);
            this.drawRect(f, f11, f3, f4 - f6, bl);
        } else {
            this.drawLine(f12, f9, f13, f9);
            this.drawLine(f12, f8, f13, f8);
            this.drawLine(f, f11, f, f10);
            this.drawLine(f + f3, f11, f + f3, f10);
        }
    }

    public void drawString(String string, int n, int n2) {
        this.drawString(string, (float)n, (float)n2);
    }

    public void drawString(String string, float f, float f2, boolean bl, float f3) {
        this.drawString(string, f, f2, bl, f3, 0.0f, null);
    }

    public void drawString(String string, float f, float f2, float f3) {
        this.drawString(string, f, f2, false, f3);
    }

    public void drawString(String string, float f, float f2, boolean bl) {
        this.drawString(string, f, f2, bl, 0.0f);
    }

    public void drawString(String string, float f, float f2) {
        this.drawString(string, f, f2, false, 0.0f, 0.0f, null);
    }

    public void drawString(String string, float f, float f2, float f3, String string2) {
        this.drawString(string, f, f2, false, 0.0f, f3, string2);
    }

    public void drawString(String string, float f, float f2, boolean bl, float f3, float f4, String string2) {
        if (string == null || string.length() == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CMD_TEXT);
        stringBuffer.append(SEPARATOR_COMMAND);
        stringBuffer.append(STRING_QUOTAION);
        stringBuffer.append(string);
        stringBuffer.append(STRING_QUOTAION);
        this.appendPosition(stringBuffer, SEPARATOR_TEXT, f, f2);
        stringBuffer.append(SEPARATOR_TEXT);
        this.appendFontNameAndSize(stringBuffer, SEPARATOR_TEXT);
        stringBuffer.append(SEPARATOR_TEXT);
        this.appendColor(stringBuffer, SEPARATOR_TEXT);
        int n = 0;
        if (this.isFontEmbedded()) {
            n += 32;
        }
        if (f4 > 0.0f && string2 != null && (string2.equals(SPACE_FOR_CHAR) || string2.equals(SPACE_FOR_PITCH))) {
            n += 16;
        } else if (f3 != 0.0f) {
            n += 8;
        } else if ((this.getFontStyle() & 2) != 0) {
            n += 4;
        } else if ((this.getFontStyle() & 1) != 0) {
            n += 2;
        } else if (bl) {
            ++n;
        }
        if (n >= 1) {
            stringBuffer.append(SEPARATOR_TEXT);
            if (bl) {
                stringBuffer.append("1");
            } else {
                stringBuffer.append("0");
            }
        }
        if (n >= 2) {
            stringBuffer.append(SEPARATOR_TEXT);
            stringBuffer.append((this.mFontStyle & 1) == 0 ? "0" : BOLD);
        }
        if (n >= 4) {
            stringBuffer.append(SEPARATOR_TEXT);
            stringBuffer.append((this.mFontStyle & 2) == 0 ? 0.0f : this.mFontSkew);
        }
        if (n >= 8) {
            stringBuffer.append(SEPARATOR_TEXT);
            stringBuffer.append(f3);
        }
        if (n >= 16) {
            stringBuffer.append(SEPARATOR_TEXT);
            this.appendStringWidth(stringBuffer, f4);
            stringBuffer.append(SEPARATOR_TEXT);
            stringBuffer.append(string2);
        }
        if (n >= 32) {
            stringBuffer.append(SEPARATOR_TEXT);
            stringBuffer.append("1");
        }
        this.mPdfCmd.draw(stringBuffer.toString());
    }

    public void appendPosition(StringBuffer stringBuffer, String string, float f, float f2) {
        stringBuffer.append(this.format(this.mPdfCmd.userXToPageX(this.mOriginX + f)));
        stringBuffer.append(string);
        stringBuffer.append(this.format(this.mPdfCmd.userYToPageY(this.mOriginY + f2)));
    }

    private void appendPoints(StringBuffer stringBuffer, String string, float[] fArray, float[] fArray2, int n) {
        int n2;
        int n3 = n - 1;
        for (n2 = 0; n2 < n3; ++n2) {
            this.appendPosition(stringBuffer, string, fArray[n2], fArray2[n2]);
            stringBuffer.append(string);
        }
        this.appendPosition(stringBuffer, string, fArray[n2], fArray2[n2]);
    }

    private void appendSize(StringBuffer stringBuffer, String string, float f, float f2) {
        this.appendWidth(stringBuffer, f);
        stringBuffer.append(string);
        this.appendHeight(stringBuffer, f2);
    }

    public void appendColor(StringBuffer stringBuffer, String string) {
        Color color = this.getColor();
        stringBuffer.append(color.getRed());
        stringBuffer.append(string);
        stringBuffer.append(color.getGreen());
        stringBuffer.append(string);
        stringBuffer.append(color.getBlue());
    }

    private void appendFontNameAndSize(StringBuffer stringBuffer, String string) {
        stringBuffer.append(this.mFontName);
        stringBuffer.append(string);
        this.appendWidth(stringBuffer, this.mFontSize);
    }

    private void appendStringWidth(StringBuffer stringBuffer, float f) {
        this.appendWidth(stringBuffer, f);
    }

    public void appendLineWidth(StringBuffer stringBuffer) {
        this.appendWidth(stringBuffer, this.mLineWidth);
    }

    public void appendLinePattern(StringBuffer stringBuffer, String string) {
        int n = this.mLinePattern.length - 1;
        for (int i = 0; i < n; ++i) {
            this.appendWidth(stringBuffer, this.mLinePattern[i]);
            stringBuffer.append(string);
        }
        this.appendWidth(stringBuffer, this.mLinePattern[n]);
    }

    private void appendWidth(StringBuffer stringBuffer, float f) {
        stringBuffer.append(this.format(this.mPdfCmd.userWidthToPageWidth(f)));
    }

    private void appendHeight(StringBuffer stringBuffer, float f) {
        stringBuffer.append(this.format(this.mPdfCmd.userHeightToPageHeight(f)));
    }

    private String format(float f) {
        return this.mFormat.format(f);
    }

    public boolean draw3D(byte[] byArray, float f, float f2, float f3, float f4, float f5) {
        if (byArray == null) {
            return false;
        }
        if (!this.draw3D(this.mPdfCmd.getImageName(), f, f2, f3, f4, f5)) {
            return false;
        }
        this.mPdfCmd.draw(byArray);
        return true;
    }

    private boolean draw3D(String string, float f, float f2, float f3, float f4, float f5) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CMD_3D);
        stringBuffer.append(SEPARATOR_COMMAND);
        stringBuffer.append(string);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        float f6 = f2;
        float f7 = f4;
        stringBuffer.append(this.format(this.mPdfCmd.userXToPageX(this.mOriginX + f)));
        stringBuffer.append(SEPARATOR_GRAPHICS);
        stringBuffer.append(this.format(this.mPdfCmd.userYToPageY(this.mOriginY + f6)));
        stringBuffer.append(SEPARATOR_GRAPHICS);
        stringBuffer.append(this.format(this.mPdfCmd.userXToPageX(this.mOriginX + f3)));
        stringBuffer.append(SEPARATOR_GRAPHICS);
        stringBuffer.append(this.format(this.mPdfCmd.userYToPageY(this.mOriginY + f7)));
        stringBuffer.append(SEPARATOR_GRAPHICS);
        stringBuffer.append(0);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        this.appendColor(stringBuffer, SEPARATOR_GRAPHICS);
        stringBuffer.append(SEPARATOR_GRAPHICS);
        stringBuffer.append(f5);
        this.mPdfCmd.draw(stringBuffer.toString());
        return true;
    }

    private void throwMethodNotSupportedException() {
        throw new InternalError("sorry! this method is not supported");
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        this.throwMethodNotSupportedException();
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.throwMethodNotSupportedException();
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        this.throwMethodNotSupportedException();
    }

    public Graphics create() {
        this.throwMethodNotSupportedException();
        return null;
    }

    public Graphics create(int n, int n2, int n3, int n4) {
        this.throwMethodNotSupportedException();
        return null;
    }

    public void draw3DRect(int n, int n2, int n3, int n4, boolean bl) {
        this.throwMethodNotSupportedException();
    }

    public void drawBytes(byte[] byArray, int n, int n2, int n3, int n4) {
        this.throwMethodNotSupportedException();
    }

    public void drawChars(char[] cArray, int n, int n2, int n3, int n4) {
        this.throwMethodNotSupportedException();
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        this.throwMethodNotSupportedException();
        return false;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        this.throwMethodNotSupportedException();
        return false;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        this.throwMethodNotSupportedException();
        return false;
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this.throwMethodNotSupportedException();
    }

    public void fill3DRect(int n, int n2, int n3, int n4, boolean bl) {
        this.throwMethodNotSupportedException();
    }

    public Shape getClip() {
        this.throwMethodNotSupportedException();
        return null;
    }

    public Rectangle getClipBounds() {
        this.throwMethodNotSupportedException();
        return null;
    }

    public Rectangle getClipBounds(Rectangle rectangle) {
        this.throwMethodNotSupportedException();
        return null;
    }

    public FontMetrics getFontMetrics() {
        this.throwMethodNotSupportedException();
        return null;
    }

    public FontMetrics getFontMetrics(Font font) {
        this.throwMethodNotSupportedException();
        return null;
    }

    public boolean hitClip(int n, int n2, int n3, int n4) {
        this.throwMethodNotSupportedException();
        return false;
    }

    public void setClip(Shape shape) {
        this.throwMethodNotSupportedException();
    }

    public void setPaintMode() {
        this.throwMethodNotSupportedException();
    }

    public void setXORMode(Color color) {
        this.throwMethodNotSupportedException();
    }

    public void draw(String string) {
        this.mPdfCmd.draw(string);
    }
}

