/*
 * Decompiled with CFR 0.152.
 */
package option.misc.gui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import jp.kitec.kwt.KCursor;
import jp.kitec.richui.TipsMessage;

public class GJButton
extends JButton
implements FocusListener,
MouseListener {
    private ActionListener _actionListener;
    private ActionEvent _actionEvent;
    private Image _imageDef;
    private Image _imageActive;
    private Image _imageDisable;
    private Image _imageHilight;
    private Dimension _imageSize;
    private boolean _pressFlag = false;
    private boolean _innerFlag = false;
    private String mTitle;
    private boolean mEnable;
    private boolean mActive = false;
    private boolean mDrawFrame = false;
    private Color _bacColor;
    private Color _activeBacColor;
    private TipsMessage _tipMes;
    private String _tip = null;
    private boolean mIsRadioMode = false;
    private boolean drawImage = true;
    private static KCursor _handCursor = KCursor.getCursor((int)12);
    private static KCursor _defCursor = KCursor.getCursor((int)0);
    private boolean _handMode = false;
    private int _pushOffset = 1;
    private int mSizeOffset = 0;
    private Insets mDefaultInsets = new Insets(0, 0, 0, 0);
    private Insets mInsets;
    private Shape mContaintsArea;

    public GJButton(String string, Image image, Image image2, Image image3, Image image4, Color color, Color color2, Container container, TipsMessage tipsMessage, int n, Shape shape) {
        this(string, image, image2, image3, image4, color, color2, container, tipsMessage, n);
    }

    public GJButton(String string, Image image, Image image2, Image image3, Image image4, Color color, Color color2, Container container, TipsMessage tipsMessage, int n) {
        this._activeBacColor = color2;
        this._bacColor = color;
        this._tipMes = tipsMessage;
        this.mSizeOffset = n;
        this.setBackground(this._bacColor);
        this.mTitle = string;
        this.mEnable = true;
        this.setInsets(n, n, 0, 0);
        this.setImage(image, image2, image3, image4);
        this.addMouseListener(this);
        this.addFocusListener(this);
    }

    public void setImage(Image image, Image image2, Image image3, Image image4) {
        this._imageDef = image;
        this._imageActive = image2 != null ? image2 : this._imageDef;
        this._imageDisable = image3 != null ? image3 : this._imageDef;
        this._imageHilight = image4;
        if (this._imageDef != null && this._imageActive == null) {
            this._imageActive = this._imageDef;
        } else if (this._imageDef == null && this._imageActive != null) {
            this._imageDef = this._imageActive;
        }
        this.setIcon(new ImageIcon(this._imageDef));
        this.setDisabledIcon(new ImageIcon(this._imageDisable));
        this.setRolloverIcon(new ImageIcon(this._imageHilight));
        this.setRolloverSelectedIcon(new ImageIcon(this._imageHilight));
        this.setPressedIcon(new ImageIcon(this._imageHilight));
        this.setSelectedIcon(new ImageIcon(this._imageActive));
        int n = this._imageDef.getWidth(null);
        int n2 = this._imageDef.getHeight(null);
        this._imageSize = new Dimension(n + this.mSizeOffset, n2 + this.mSizeOffset);
        this.updateImage();
        this.repaint();
    }

    public void setDrawImage(boolean bl) {
        this.drawImage = bl;
        this.repaint();
    }

    public void setActiveBacColor(Color color) {
        this._activeBacColor = color;
    }

    public void setRadioMode(boolean bl) {
        this.mIsRadioMode = bl;
    }

    public void setHandMode(boolean bl) {
        this._handMode = bl;
    }

    public void setDrawFrame(boolean bl) {
        this.mDrawFrame = bl;
        this.repaint();
    }

    public void setPushOffset(int n) {
        this._pushOffset = n;
    }

    public void setTip(String string) {
        this._tip = string;
    }

    public Dimension getPreferredSize() {
        return this._imageSize;
    }

    public Dimension getSize() {
        return this._imageSize;
    }

    public String getLabel() {
        return this.mTitle;
    }

    public Insets getInsets() {
        return this.mInsets;
    }

    public void setInsets(int n, int n2, int n3, int n4) {
        this.mDefaultInsets = new Insets(n, n2, n3, n4);
        this.updateImage();
        this.repaint();
    }

    public void setContaintsArea(Shape shape) {
        this.mContaintsArea = shape;
    }

    public void setActive(boolean bl) {
        this.mActive = bl;
        this.updateImage();
        this.repaint();
    }

    public boolean isActive() {
        return this.mActive;
    }

    public void setEnabled1(boolean bl) {
        this.mEnable = bl;
        if (!this.mEnable) {
            if (this._handMode) {
                this.setCursor((Cursor)_defCursor);
            }
            this.mActive = false;
        }
        this.setEnabled(bl);
        this.updateImage();
        this.repaint();
    }

    public boolean isEnabled1() {
        return this.mEnable;
    }

    public void addActionListener(ActionListener actionListener) {
        this._actionEvent = new ActionEvent(this, 0, null);
        this._actionListener = actionListener;
    }

    public void paintComponent(Graphics graphics) {
        if (!this.drawImage) {
            return;
        }
        super.paintComponent(graphics);
        boolean bl = this.mActive || this._pressFlag;
        Color color = this.getBackground();
        if (this.mDrawFrame && this.mEnable) {
            graphics.setColor(color.darker().darker());
            graphics.drawRect(0, 0, this._imageSize.width - 1, this._imageSize.height - 1);
            graphics.setColor(color.brighter());
            graphics.draw3DRect(1, 1, this._imageSize.width - 3, this._imageSize.height - 3, !bl);
        }
    }

    private void updateImage() {
        Image image;
        Color color;
        boolean bl;
        int n = 0;
        boolean bl2 = bl = this.mActive || this._pressFlag;
        if (bl) {
            color = this._activeBacColor;
            image = this._imageActive;
            n = this._pushOffset;
        } else {
            color = this._bacColor;
            image = this.mEnable ? this._imageDef : this._imageDisable;
        }
        if (this._innerFlag && this._imageHilight != null && this.isEnabled1()) {
            image = this._imageHilight;
        }
        this.setBackground(color);
        if (image != null) {
            this.setIcon(new ImageIcon(image));
        }
        this.mInsets = new Insets(this.mDefaultInsets.top + n, this.mDefaultInsets.left + n, this.mDefaultInsets.bottom, this.mDefaultInsets.right);
    }

    private void gogo() {
        if (this.mIsRadioMode) {
            this.setActive(!this.isActive());
            this.repaint();
        }
        if (this._actionListener != null) {
            this._actionListener.actionPerformed(this._actionEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.mEnable || !this.drawImage) {
            return;
        }
        this._pressFlag = true;
        this._innerFlag = true;
        this.updateImage();
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.mEnable || !this.drawImage) {
            return;
        }
        if (!this.contains(mouseEvent.getX(), mouseEvent.getY()) && this._innerFlag) {
            this._innerFlag = false;
            this.repaint();
        } else if (this.contains(mouseEvent.getX(), mouseEvent.getY()) && !this._innerFlag) {
            this._innerFlag = true;
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!(this.mEnable && this.drawImage || this._pressFlag)) {
            return;
        }
        if (this._innerFlag && this._pressFlag) {
            this.gogo();
        }
        this._pressFlag = false;
        this.updateImage();
        this.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this._tipMes != null && this.drawImage) {
            this._tipMes.setMessage(this._tip);
            this._tipMes.update();
        }
        if (this._handMode) {
            if (!this.mEnable || !this.drawImage) {
                this.setCursor((Cursor)_defCursor);
                return;
            }
            this.setCursor((Cursor)_handCursor);
        }
        this._innerFlag = true;
        this.updateImage();
        this.repaint();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseExit();
    }

    protected void mouseExit() {
        if (this._tipMes != null && this.drawImage) {
            this._tipMes.setMessage(null);
            this._tipMes.update();
        }
        if (this._handMode) {
            this.setCursor((Cursor)_defCursor);
        }
        this._innerFlag = false;
        if (!this._pressFlag) {
            this.updateImage();
        }
        this.repaint();
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.mouseExit();
    }

    public boolean contains(int n, int n2) {
        if (this.mContaintsArea == null) {
            return super.contains(n, n2);
        }
        return this.mContaintsArea.contains(n, n2);
    }
}

