/*
 * Decompiled with CFR 0.152.
 */
package option.misc.envcomp;

import com.kt.gui.event.CallBackListener;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jp.kitec.kwt.KLimitedNumberField;
import jp.kitec.kwt.KVFlowLayout;
import jp.kitec.kwtex.EnvComp;
import nethome.geom.primitive.GPoint2Df;

public class EnvCompInputRLength
extends EnvComp
implements AdjustmentListener {
    private KLimitedNumberField mLength;
    private KLimitedNumberField mAngl;
    private Scrollbar mAnglbar;
    private double mOrgX;
    private double mOrgY;

    public EnvCompInputRLength(String string, boolean bl, GPoint2Df gPoint2Df, String string2, String string3, Frame frame, CallBackListener callBackListener) {
        super(frame, callBackListener);
        this.setLayout((LayoutManager)new KVFlowLayout(1, 0));
        this.mOrgX = gPoint2Df.x;
        this.mOrgY = gPoint2Df.y;
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        jPanel.add(new JLabel(string2));
        this.mLength = new KLimitedNumberField(gPoint2Df.x, 1, 500.0, frame);
        jPanel.add(this.mLength);
        this.mLength.setColumns(8);
        this.mLength.setMinMax(0.0, 100000.0);
        this.add(jPanel);
        jPanel = new JPanel(new FlowLayout(0, 0, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        jPanel.add(new Label(string3));
        this.mAnglbar = new Scrollbar(0, 0, 5, -90, 365);
        this.mAnglbar.setBlockIncrement(5);
        this.mAnglbar.setUnitIncrement(5);
        this.mAnglbar.addAdjustmentListener(this);
        jPanel.add(this.mAnglbar);
        this.mAngl = new KLimitedNumberField(gPoint2Df.y, 1);
        this.mAngl.setMinMax(-90.0, 360.0);
        jPanel.add(this.mAngl);
        this.mAngl.setColumns(6);
        this.add(jPanel);
        this.setCallbackListener(callBackListener);
    }

    public void setAngleMinMax(double d, double d2) {
        this.mAngl.setMinMax(d, d2);
    }

    public boolean isContainsEventSource(Object object) {
        return object == this.mLength || object == this.mAngl || object == this.mAnglbar;
    }

    public void setCallbackListener(CallBackListener callBackListener) {
        this.mCallBackListener = callBackListener;
        this.mLength.addCallbackListener(callBackListener);
        this.mAngl.addCallbackListener(callBackListener);
    }

    public void setAnglLength(double d, double d2) {
        this.setAnglLength(d, d2, true);
    }

    public void setAnglLength(double d, double d2, boolean bl) {
        this.mLength.setValue(d2, bl);
        if (d > 270.0) {
            d -= 360.0;
        }
        this.mAnglbar.setValue((int)Math.round(d));
        this.mAngl.setValue(d, bl);
    }

    public double getLength() throws Exception {
        return this.mLength.getValue();
    }

    public double getAngl() throws Exception {
        double d = this.mAngl.getValue();
        if (d < 0.0) {
            d += 360.0;
        }
        return d;
    }

    public boolean isChanged() {
        try {
            return this.mLength.getValue() != this.mOrgX || this.mAngl.getValue() != this.mOrgY;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isCorrect() {
        return true;
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.mAngl.setValue(adjustmentEvent.getValue(), false);
        if (this.mCallBackListener != null) {
            this.mCallBackListener.actionCallBack((Object)this.mAngl);
        }
    }
}

