/*
 * Decompiled with CFR 0.152.
 */
package option.io.jpg;

import java.io.IOException;
import java.io.OutputStream;
import option.io.jpg.BitOutStream;

public class JPEGCoder {
    protected BitOutStream out;
    private int qfactor = 10;
    private static final byte[] qt0 = new byte[]{16, 11, 12, 14, 12, 10, 16, 14, 13, 14, 18, 17, 16, 19, 24, 40, 26, 24, 22, 22, 24, 49, 35, 37, 29, 40, 58, 51, 61, 60, 57, 51, 56, 55, 64, 72, 92, 78, 64, 68, 87, 69, 55, 56, 80, 109, 81, 87, 95, 98, 103, 104, 103, 62, 77, 113, 121, 112, 100, 120, 92, 101, 103, 99};
    private static final byte[] qt1 = new byte[]{17, 18, 18, 24, 21, 24, 47, 26, 26, 47, 99, 66, 56, 66, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99};
    private static final byte[] ht0 = new byte[]{0, 1, 5, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    private static final byte[] hsizeT0 = new byte[]{2, 3, 3, 3, 3, 3, 4, 5, 6, 7, 8, 9};
    private static final short[] hcodeT0 = new short[]{0, 2, 3, 4, 5, 6, 14, 30, 62, 126, 254, 510};
    private static final byte[] ht1 = new byte[]{0, 2, 1, 3, 3, 2, 4, 3, 5, 5, 4, 4, 0, 0, 1, 125, 1, 2, 3, 0, 4, 17, 5, 18, 33, 49, 65, 6, 19, 81, 97, 7, 34, 113, 20, 50, -127, -111, -95, 8, 35, 66, -79, -63, 21, 82, -47, -16, 36, 51, 98, 114, -126, 9, 10, 22, 23, 24, 25, 26, 37, 38, 39, 40, 41, 42, 52, 53, 54, 55, 56, 57, 58, 67, 68, 69, 70, 71, 72, 73, 74, 83, 84, 85, 86, 87, 88, 89, 90, 99, 100, 101, 102, 103, 104, 105, 106, 115, 116, 117, 118, 119, 120, 121, 122, -125, -124, -123, -122, -121, -120, -119, -118, -110, -109, -108, -107, -106, -105, -104, -103, -102, -94, -93, -92, -91, -90, -89, -88, -87, -86, -78, -77, -76, -75, -74, -73, -72, -71, -70, -62, -61, -60, -59, -58, -57, -56, -55, -54, -46, -45, -44, -43, -42, -41, -40, -39, -38, -31, -30, -29, -28, -27, -26, -25, -24, -23, -22, -15, -14, -13, -12, -11, -10, -9, -8, -7, -6};
    private static final byte[] hsizeT1 = new byte[]{4, 2, 2, 3, 4, 5, 7, 8, 10, 16, 16, 4, 5, 7, 9, 11, 16, 16, 16, 16, 16, 5, 8, 10, 12, 16, 16, 16, 16, 16, 16, 6, 9, 12, 16, 16, 16, 16, 16, 16, 16, 6, 10, 16, 16, 16, 16, 16, 16, 16, 16, 7, 11, 16, 16, 16, 16, 16, 16, 16, 16, 7, 12, 16, 16, 16, 16, 16, 16, 16, 16, 8, 12, 16, 16, 16, 16, 16, 16, 16, 16, 9, 15, 16, 16, 16, 16, 16, 16, 16, 16, 9, 16, 16, 16, 16, 16, 16, 16, 16, 16, 9, 16, 16, 16, 16, 16, 16, 16, 16, 16, 10, 16, 16, 16, 16, 16, 16, 16, 16, 16, 10, 16, 16, 16, 16, 16, 16, 16, 16, 16, 11, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 11, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16};
    private static final short[] hcodeT1 = new short[]{10, 0, 1, 4, 11, 26, 120, 248, 1014, -126, -125, 12, 27, 121, 502, 2038, -124, -123, -122, -121, -120, 28, 249, 1015, 4084, -119, -118, -117, -116, -115, -114, 58, 503, 4085, -113, -112, -111, -110, -109, -108, -107, 59, 1016, -106, -105, -104, -103, -102, -101, -100, -99, 122, 2039, -98, -97, -96, -95, -94, -93, -92, -91, 123, 4086, -90, -89, -88, -87, -86, -85, -84, -83, 250, 4087, -82, -81, -80, -79, -78, -77, -76, -75, 504, 32704, -74, -73, -72, -71, -70, -69, -68, -67, 505, -66, -65, -64, -63, -62, -61, -60, -59, -58, 506, -57, -56, -55, -54, -53, -52, -51, -50, -49, 1017, -48, -47, -46, -45, -44, -43, -42, -41, -40, 1018, -39, -38, -37, -36, -35, -34, -33, -32, -31, 2040, -30, -29, -28, -27, -26, -25, -24, -23, -22, -21, -20, -19, -18, -17, -16, -15, -14, -13, -12, 2041, -11, -10, -9, -8, -7, -6, -5, -4, -3, -2};
    private static final byte[] ht2 = new byte[]{0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    private static final byte[] hsizeT2 = new byte[]{2, 2, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    private static final short[] hcodeT2 = new short[]{0, 1, 2, 6, 14, 30, 62, 126, 254, 510, 1022, 2046};
    private static final byte[] ht3 = new byte[]{0, 2, 1, 2, 4, 4, 3, 4, 7, 5, 4, 4, 0, 1, 2, 119, 0, 1, 2, 3, 17, 4, 5, 33, 49, 6, 18, 65, 81, 7, 97, 113, 19, 34, 50, -127, 8, 20, 66, -111, -95, -79, -63, 9, 35, 51, 82, -16, 21, 98, 114, -47, 10, 22, 36, 52, -31, 37, -15, 23, 24, 25, 26, 38, 39, 40, 41, 42, 53, 54, 55, 56, 57, 58, 67, 68, 69, 70, 71, 72, 73, 74, 83, 84, 85, 86, 87, 88, 89, 90, 99, 100, 101, 102, 103, 104, 105, 106, 115, 116, 117, 118, 119, 120, 121, 122, -126, -125, -124, -123, -122, -121, -120, -119, -118, -110, -109, -108, -107, -106, -105, -104, -103, -102, -94, -93, -92, -91, -90, -89, -88, -87, -86, -78, -77, -76, -75, -74, -73, -72, -71, -70, -62, -61, -60, -59, -58, -57, -56, -55, -54, -46, -45, -44, -43, -42, -41, -40, -39, -38, -30, -29, -28, -27, -26, -25, -24, -23, -22, -14, -13, -12, -11, -10, -9, -8, -7, -6};
    private static final byte[] hsizeT3 = new byte[]{2, 2, 3, 4, 5, 5, 6, 7, 9, 10, 12, 4, 6, 8, 9, 11, 12, 16, 16, 16, 16, 5, 8, 10, 12, 15, 16, 16, 16, 16, 16, 5, 8, 10, 12, 16, 16, 16, 16, 16, 16, 6, 9, 16, 16, 16, 16, 16, 16, 16, 16, 6, 10, 16, 16, 16, 16, 16, 16, 16, 16, 7, 11, 16, 16, 16, 16, 16, 16, 16, 16, 7, 11, 16, 16, 16, 16, 16, 16, 16, 16, 8, 16, 16, 16, 16, 16, 16, 16, 16, 16, 9, 16, 16, 16, 16, 16, 16, 16, 16, 16, 9, 16, 16, 16, 16, 16, 16, 16, 16, 16, 9, 16, 16, 16, 16, 16, 16, 16, 16, 16, 9, 16, 16, 16, 16, 16, 16, 16, 16, 16, 11, 16, 16, 16, 16, 16, 16, 16, 16, 16, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 10, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16};
    private static final short[] hcodeT3 = new short[]{0, 1, 4, 10, 24, 25, 56, 120, 500, 1014, 4084, 11, 57, 246, 501, 2038, 4085, -120, -119, -118, -117, 26, 247, 1015, 4086, 32706, -116, -115, -114, -113, -112, 27, 248, 1016, 4087, -111, -110, -109, -108, -107, -106, 58, 502, -105, -104, -103, -102, -101, -100, -99, -98, 59, 1017, -97, -96, -95, -94, -93, -92, -91, -90, 121, 2039, -89, -88, -87, -86, -85, -84, -83, -82, 122, 2040, -81, -80, -79, -78, -77, -76, -75, -74, 249, -73, -72, -71, -70, -69, -68, -67, -66, -65, 503, -64, -63, -62, -61, -60, -59, -58, -57, -56, 504, -55, -54, -53, -52, -51, -50, -49, -48, -47, 505, -46, -45, -44, -43, -42, -41, -40, -39, -38, 506, -37, -36, -35, -34, -33, -32, -31, -30, -29, 2041, -28, -27, -26, -25, -24, -23, -22, -21, -20, 16352, -19, -18, -17, -16, -15, -14, -13, -12, -11, 1018, 32707, -10, -9, -8, -7, -6, -5, -4, -3, -2};
    private static final double iSqrt2 = 1.0 / Math.sqrt(2.0);
    private static final double[][] mCosT = new double[8][8];

    public JPEGCoder(OutputStream outputStream) throws IOException {
        this.out = new BitOutStream(outputStream);
    }

    public void setQFactor(int n) {
        this.qfactor = n;
    }

    public void encodePixels(int[] nArray, int n, int n2) throws IOException {
        byte[] byArray = new byte[]{-1, -40, -1, -32, 0, 16, 74, 70, 73, 70, 0, 1, 1, 1, 0, 72, 0, 72, 0, 0};
        this.out.write(byArray);
        byte[] byArray2 = (byte[])qt0.clone();
        byte[] byArray3 = (byte[])qt1.clone();
        if (this.qfactor != 100) {
            for (int i = 0; i < 64; ++i) {
                byArray2[i] = (byte)Math.max(Math.min(byArray2[i] * this.qfactor / 100, 255), 1);
                byArray3[i] = (byte)Math.max(Math.min(byArray3[i] * this.qfactor / 100, 255), 1);
            }
        }
        this.out.write(255);
        this.out.write(219);
        this.out.write(0);
        this.out.write(132);
        this.out.write(0);
        this.out.write(byArray2);
        this.out.write(1);
        this.out.write(byArray3);
        this.out.write(255);
        this.out.write(196);
        this.out.write(1);
        this.out.write(162);
        this.out.write(0);
        this.out.write(ht0);
        this.out.write(16);
        this.out.write(ht1);
        this.out.write(1);
        this.out.write(ht2);
        this.out.write(17);
        this.out.write(ht3);
        byte[] byArray4 = new byte[]{-1, -64, 0, 17, 8, 0, 0, 0, 0, 3, 0, 34, 0, 1, 17, 1, 2, 17, 1};
        byArray4[5] = (byte)(n2 >>> 8);
        byArray4[6] = (byte)(n2 & 0xFF);
        byArray4[7] = (byte)(n >>> 8);
        byArray4[8] = (byte)(n & 0xFF);
        this.out.write(byArray4);
        byte[] byArray5 = new byte[]{-1, -38, 0, 12, 3, 0, 0, 1, 17, 2, 17, 0, 63, 0};
        this.out.write(byArray5);
        int n3 = (int)Math.ceil((double)n / 16.0);
        int n4 = (int)Math.ceil((double)n2 / 16.0);
        int[] nArray2 = new int[64];
        int[] nArray3 = new int[64];
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n8;
                int n9;
                int n10;
                int n11;
                int n12;
                int n13;
                int n14;
                int n15;
                int n16;
                int n17;
                int n18;
                for (n18 = 0; n18 < 4; ++n18) {
                    n17 = i * 16 + (n18 < 2 ? 0 : 8);
                    n16 = n17 + 8;
                    n15 = j * 16 + (n18 % 2 == 0 ? 0 : 8);
                    n14 = n15 + 8;
                    n13 = 0;
                    for (n12 = n17; n12 < n16; ++n12) {
                        for (n11 = n15; n11 < n14; ++n11) {
                            n10 = nArray[(n12 >= n2 ? n2 - 1 : n12) * n + (n11 >= n ? n - 1 : n11)];
                            n9 = n10 >>> 16 & 0xFF;
                            n8 = n10 >>> 8 & 0xFF;
                            int n19 = n10 & 0xFF;
                            nArray2[n13] = (int)(0.299 * (double)n9 + 0.587 * (double)n8 + 0.114 * (double)n19 - 128.0);
                            ++n13;
                        }
                    }
                    this.dct(nArray2);
                    this.qzn(nArray2, byArray2);
                    this.chf(nArray2, n5, hsizeT0, hcodeT0, hsizeT1, hcodeT1);
                    n5 = nArray2[0];
                }
                n18 = i * 16;
                n17 = n18 + 16;
                n16 = j * 16;
                n15 = n16 + 16;
                n14 = 0;
                for (n13 = n18; n13 < n17; n13 += 2) {
                    for (n12 = n16; n12 < n15; n12 += 2) {
                        n11 = nArray[(n13 >= n2 ? n2 - 1 : n13) * n + (n12 >= n ? n - 1 : n12)];
                        n10 = n11 >>> 16 & 0xFF;
                        n9 = n11 >>> 8 & 0xFF;
                        n8 = n11 & 0xFF;
                        nArray2[n14] = (int)(-0.1687 * (double)n10 - 0.3313 * (double)n9 + 0.5 * (double)n8);
                        nArray3[n14] = (int)(0.5 * (double)n10 - 0.4187 * (double)n9 - 0.0813 * (double)n8);
                        ++n14;
                    }
                }
                this.dct(nArray2);
                this.qzn(nArray2, byArray3);
                this.chf(nArray2, n6, hsizeT2, hcodeT2, hsizeT3, hcodeT3);
                n6 = nArray2[0];
                this.dct(nArray3);
                this.qzn(nArray3, byArray3);
                this.chf(nArray3, n7, hsizeT2, hcodeT2, hsizeT3, hcodeT3);
                n7 = nArray3[0];
            }
        }
        this.out.write(255);
        this.out.write(217);
        this.out.flush();
    }

    private void dct(int[] nArray) {
        int[] nArray2 = new int[64];
        for (int i = 0; i < 8; ++i) {
            double d = i == 0 ? iSqrt2 : 1.0;
            for (int j = 0; j < 8; ++j) {
                double d2 = j == 0 ? iSqrt2 : 1.0;
                double d3 = 0.0;
                for (int k = 0; k < 8; ++k) {
                    for (int i2 = 0; i2 < 8; ++i2) {
                        d3 += (double)nArray[k * 8 + i2] * mCosT[j][i2] * mCosT[i][k];
                    }
                }
                nArray2[i * 8 + j] = (int)(d3 * d2 * d / 4.0);
            }
        }
        int[] nArray3 = new int[]{0, 1, 8, 16, 9, 2, 3, 10, 17, 24, 32, 25, 18, 11, 4, 5, 12, 19, 26, 33, 40, 48, 41, 34, 27, 20, 13, 6, 7, 14, 21, 28, 35, 42, 49, 56, 57, 50, 43, 36, 29, 22, 15, 23, 30, 37, 44, 51, 58, 59, 52, 45, 38, 31, 39, 46, 53, 60, 61, 54, 47, 55, 62, 63};
        for (int i = 0; i < 64; ++i) {
            nArray[i] = nArray2[nArray3[i]];
        }
    }

    private void qzn(int[] nArray, byte[] byArray) {
        for (int i = 0; i < 64; ++i) {
            int n = i;
            nArray[n] = nArray[n] / byArray[i];
        }
    }

    private void chf(int[] nArray, int n, byte[] byArray, short[] sArray, byte[] byArray2, short[] sArray2) throws IOException {
        int n2 = nArray[0] - n;
        int n3 = Math.abs(n2);
        int n4 = 0;
        while (n3 > 0) {
            n3 >>= 1;
            ++n4;
        }
        this.out.writeBits(sArray[n4], byArray[n4]);
        if (n4 != 0) {
            if (n2 < 0) {
                --n2;
            }
            this.out.writeBits(n2, n4);
        }
        int n5 = 0;
        for (int i = 1; i < 64; ++i) {
            int n6 = Math.abs(nArray[i]);
            if (n6 != 0) {
                while (n5 > 15) {
                    this.out.writeBits(sArray2[151], byArray2[151]);
                    n5 -= 16;
                }
                int n7 = 0;
                while (n6 > 0) {
                    n6 >>= 1;
                    ++n7;
                }
                int n8 = n5 * 10 + n7 + (n5 == 15 ? 1 : 0);
                this.out.writeBits(sArray2[n8], byArray2[n8]);
                int n9 = nArray[i];
                if (n9 < 0) {
                    --n9;
                }
                this.out.writeBits(n9, n7);
                n5 = 0;
                continue;
            }
            if (i == 63) {
                this.out.writeBits(sArray2[0], byArray2[0]);
                continue;
            }
            ++n5;
        }
    }

    static {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                JPEGCoder.mCosT[i][j] = Math.cos((2.0 * (double)j + 1.0) * (double)i * Math.PI / 16.0);
            }
        }
    }
}

