/*
 * Decompiled with CFR 0.152.
 */
package option.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JComponentTitledBorder
implements MouseListener,
MouseMotionListener,
PropertyChangeListener,
SwingConstants,
Border,
ChangeListener {
    private int mOffset = 5;
    private final JComponent mTitleComponent;
    private final JComponent mContainer;
    private final Border mBorder;

    public JComponentTitledBorder(JComponent jComponent, JComponent jComponent2, Border border) {
        this.mTitleComponent = jComponent;
        this.mContainer = jComponent2;
        this.mBorder = border;
        this.mTitleComponent.setOpaque(true);
        this.mContainer.addMouseListener(this);
        this.mContainer.addMouseMotionListener(this);
        this.mTitleComponent.addPropertyChangeListener(this);
        if (jComponent instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)jComponent;
            abstractButton.addChangeListener(this);
        }
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public void setOffset(int n) {
        this.mOffset = n;
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Insets insets = this.mBorder.getBorderInsets(component);
        Insets insets2 = this.getBorderInsets(component);
        int n5 = (insets2.top - insets.top) * 2 / 3;
        this.mBorder.paintBorder(component, graphics, n, n2 + n5, n3, n4 - n5);
        Dimension dimension = this.mTitleComponent.getPreferredSize();
        Rectangle rectangle = new Rectangle(this.mOffset, 0, dimension.width, dimension.height);
        SwingUtilities.paintComponent(graphics, this.mTitleComponent, (Container)component, rectangle);
        Rectangle rectangle2 = new Rectangle(this.mOffset, 0, dimension.width, dimension.height);
        this.mTitleComponent.setBounds(rectangle2);
    }

    public Insets getBorderInsets(Component component) {
        Dimension dimension = this.mTitleComponent.getPreferredSize();
        Insets insets = this.mBorder.getBorderInsets(component);
        insets.top = Math.max(insets.top, dimension.height);
        return insets;
    }

    private void dispatchEvent(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        this.mTitleComponent.dispatchEvent(SwingUtilities.convertMouseEvent(component, mouseEvent, this.mTitleComponent));
        component.repaint();
    }

    private void dispatchEvent(PropertyChangeEvent propertyChangeEvent) {
        this.mContainer.repaint();
    }

    private void dispatchEvent(ChangeEvent changeEvent) {
        this.mContainer.validate();
        this.mContainer.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.dispatchEvent(propertyChangeEvent);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.dispatchEvent(changeEvent);
    }
}

