/*
 * Decompiled with CFR 0.152.
 */
package option.gui;

import java.awt.AWTEventMulticaster;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;

public class GDeformedButton
extends Container {
    private ActionListener actionListener;
    private String mTitle;
    private Color mFontColor;
    private Color mActiveColor;
    private Color mInActiveColor;
    private Color mDisableColor;
    private boolean mActive = false;
    protected boolean pressed = false;
    protected boolean entered = false;
    private GeneralPath mShape;
    public static GeneralPath NEXT;
    public static GeneralPath PREV;
    private static int mWidth;
    private static int mHeight;

    public static int getW() {
        return mWidth;
    }

    public static int getH() {
        return mHeight;
    }

    public GDeformedButton() {
        this("");
    }

    public GDeformedButton(String string) {
        this.mTitle = string;
        this.setFont(new Font("Monospaced", 0, 12));
        this.enableEvents(16L);
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            }
        });
    }

    public String getLabel() {
        return this.mTitle;
    }

    public void setShape(GeneralPath generalPath) {
        this.mShape = generalPath;
    }

    public void setLabel(String string) {
        this.mTitle = string;
        this.invalidate();
        this.repaint();
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = Math.min(this.getSize().width - 1, this.getSize().height - 1);
        if (this.pressed && this.entered) {
            graphics2D.setColor(Color.WHITE);
        } else {
            graphics2D.setColor(this.getBackground());
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.fill(this.mShape);
        graphics2D.setColor(this.getBackground().darker());
        graphics2D.draw(this.mShape);
        Font font = this.getFont();
        if (font != null) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawString(this.mTitle, n / 2 - fontMetrics.stringWidth(this.mTitle) / 2 + 6, n / 2 + fontMetrics.getMaxDescent() + 2);
        }
    }

    private void drawGradation(Graphics2D graphics2D, GeneralPath generalPath, int n, int n2, float f) {
        graphics2D.setColor(Color.DARK_GRAY);
        AffineTransform affineTransform = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, n, n2);
        Shape shape = generalPath.createTransformedShape(affineTransform);
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, f);
        graphics2D.setComposite(alphaComposite);
        graphics2D.draw(shape);
    }

    public void repaint() {
        super.repaint();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public Dimension getPreferredSize() {
        return new Dimension(mWidth, mHeight);
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, 100);
    }

    public Dimension getSize() {
        return new Dimension(mWidth, mHeight);
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
        this.enableEvents(16L);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public boolean contains(int n, int n2) {
        return this.mShape.contains(n, n2);
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: {
                this.pressed = true;
                this.entered = true;
                this.repaint();
                break;
            }
            case 502: {
                if (this.actionListener != null && this.entered) {
                    this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.mTitle));
                    this.entered = false;
                }
                if (!this.pressed) break;
                this.pressed = false;
                this.repaint();
                break;
            }
            case 504: {
                this.entered = true;
                break;
            }
            case 505: {
                this.entered = false;
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    static {
        mWidth = 50;
        mHeight = 44;
        float f = 0.6f;
        float f2 = 0.29545453f;
        GeneralPath generalPath = new GeneralPath(0);
        generalPath.moveTo(mWidth, (float)mHeight * f2);
        generalPath.append(new Line2D.Float(mWidth, (float)mHeight * f2, (float)mWidth * f, (float)mHeight * f2), true);
        generalPath.append(new Line2D.Float((float)mWidth * f, (float)mHeight * f2, (float)mWidth * f, 0.0f), true);
        generalPath.append(new Line2D.Float((float)mWidth * f, 0.0f, 0.0f, mHeight / 2), true);
        generalPath.append(new Line2D.Float(0.0f, mHeight / 2, (float)mWidth * f, mHeight), true);
        generalPath.append(new Line2D.Float((float)mWidth * f, mHeight, (float)mWidth * f, (float)mHeight * (1.0f - f2)), true);
        generalPath.append(new Line2D.Float((float)mWidth * f, (float)mHeight * (1.0f - f2), mWidth, (float)mHeight * (1.0f - f2)), true);
        generalPath.append(new Line2D.Float(mWidth, (float)mHeight * (1.0f - f2), mWidth, (float)mHeight * f2), true);
        generalPath.closePath();
        PREV = generalPath;
        f = 1.0f - f;
        generalPath = new GeneralPath(0);
        generalPath.moveTo(0.0f, (float)mHeight * f2);
        generalPath.append(new Line2D.Float(0.0f, (float)mHeight * f2, 0.0f, (float)mHeight * (1.0f - f2)), true);
        generalPath.append(new Line2D.Float(0.0f, (float)mHeight * (1.0f - f2), (float)mWidth * f, (float)mHeight * (1.0f - f2)), true);
        generalPath.append(new Line2D.Float((float)mWidth * f, (float)mHeight * (1.0f - f2), (float)mWidth * f, mHeight), true);
        generalPath.append(new Line2D.Float((float)mWidth * f, mHeight, mWidth, mHeight / 2), true);
        generalPath.append(new Line2D.Float(mWidth, mHeight / 2, (float)mWidth * f, 0.0f), true);
        generalPath.append(new Line2D.Float((float)mWidth * f, 0.0f, (float)mWidth * f, (float)mHeight * f2), true);
        generalPath.append(new Line2D.Float((float)mWidth * f, (float)mHeight * f2, 0.0f, (float)mHeight * f2), true);
        generalPath.closePath();
        NEXT = generalPath;
    }
}

