/*
 * Decompiled with CFR 0.152.
 */
package option.gui;

import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import option.gui.Calc;

public class ExpressionParser {
    private static final String plus = "\\Q+\\E";
    private static final String minus = "\\Q-\\E";
    private static final String multi = "\\Q*\\E";
    private static final String div = "\\Q/\\E";
    private static final String bra = "(";
    private static final String ket = ")";
    private static final String PLUS = "+";
    private static final String MINUS = "-";
    private static final String DIV = "/";
    private static final String MULTI = "*";
    private static final String operator = "\\Q+\\E|\\Q-\\E|\\Q*\\E|\\Q/\\E";
    private static final String other = "([\\Q+\\E|\\Q-\\E|\\Q*\\E|\\Q/\\E]){1}+";
    private static String regex = "([\\Q+\\E|\\Q-\\E|\\Q*\\E|\\Q/\\E]){1}+|([^\\Q+\\E|\\Q-\\E|\\Q*\\E|\\Q/\\E]*)";
    private static Pattern pattern = Pattern.compile(regex);

    public static float parseFloat(String string) throws NumberFormatException {
        if (string.equals("")) {
            throw new NumberFormatException();
        }
        string = string.trim();
        float f = 0.0f;
        try {
            f = Float.parseFloat(string);
            return f;
        }
        catch (NumberFormatException numberFormatException) {
            Vector<String> vector = new Vector<String>();
            Matcher matcher = pattern.matcher(string);
            while (matcher.find()) {
                for (int i = 1; i <= matcher.groupCount(); ++i) {
                    String string2;
                    if (matcher.group(i) == null || (string2 = matcher.group(i)).length() == 0) continue;
                    vector.addElement(string2);
                }
            }
            if (vector.size() == 0) {
                throw new NumberFormatException();
            }
            float f2 = 0.0f;
            boolean bl = false;
            Vector<Calc> vector2 = new Vector<Calc>();
            Calc calc = null;
            String string3 = (String)vector.elementAt(0);
            if (string3.equals(PLUS) || string3.equals(MINUS)) {
                bl = true;
                calc = new Calc(true, ExpressionParser.getMode(string3));
                vector2.addElement(calc);
            } else {
                try {
                    f2 = f = Float.parseFloat(string3);
                    calc = new Calc(false, f);
                    vector2.addElement(calc);
                }
                catch (NumberFormatException numberFormatException2) {
                    throw new NumberFormatException();
                }
            }
            for (int i = 1; i < vector.size(); ++i) {
                String string4 = (String)vector.elementAt(i);
                if (string4.length() == 0) continue;
                if (bl) {
                    try {
                        f = Float.parseFloat(string4);
                        bl = false;
                        calc = new Calc(false, f);
                        vector2.addElement(calc);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException3) {
                        throw new NumberFormatException();
                    }
                }
                if ((string4.equals(PLUS) || string4.equals(MINUS) || string4.equals(DIV) || string4.equals(MULTI)) && i != vector.size() - 1) {
                    bl = true;
                    calc = new Calc(true, ExpressionParser.getMode(string4));
                    vector2.addElement(calc);
                    continue;
                }
                throw new NumberFormatException();
            }
            f2 = Calc.calc(vector2);
            return f2;
        }
    }

    private static int getMode(String string) {
        if (string.equals(MINUS)) {
            return 1;
        }
        if (string.equals(PLUS)) {
            return 0;
        }
        if (string.equals(MULTI)) {
            return 2;
        }
        if (string.equals(DIV)) {
            return 3;
        }
        return -1;
    }

    public static void main(String[] stringArray) {
        String string = "-9*10f+2000f+6*2/3";
        try {
            float f = ExpressionParser.parseFloat(string);
            System.out.println(f);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("ERROR");
        }
    }
}

