/*
 * Decompiled with CFR 0.152.
 */
package option.gad.toex.client.service.estimate;

import java.awt.Font;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import nethome.doc.Layer;
import option.gad.client.pdf.GdPdfUtil;
import option.gad.toex.client.service.estimate.GdAbstractEstimatePdfCommon;
import option.gad.toex.client.service.estimate.GdEstimatePdfUtil;
import option.gad.toex.client.service.estimate.GdEstimateRow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GdAbstractEstimatePdfSheet<T extends Layer>
extends GdAbstractEstimatePdfCommon<T> {
    private static final int DEF_INDEX_CODE = 0;
    private static final int DEF_INDEX_NAME_1 = 1;
    private static final int DEF_INDEX_NAME_2 = 2;
    private static final int DEF_INDEX_QUANTITY = 3;
    private static final int DEF_INDEX_UNITPRICE = 4;
    private static final int DEF_INDEX_AMOUNT = 5;
    private static final int[] DEFAULT_ROW_XS = new int[]{13, 45, 45, 149, 174, 197};
    private static final int DEFAULT_ROW_Y = 36;
    private static final int DEFAULT_ROW_PITCH = 8;
    protected static final NumberFormat FORMAT = new DecimalFormat("###,###,###");
    protected int mMaxRow = 0;
    protected int[] mRowXs = DEFAULT_ROW_XS;
    protected int mRowY = 36;
    protected int mRowPitch = 8;
    protected List<GdEstimateRow> mRowList = new ArrayList<GdEstimateRow>();
    protected int mRowCount = 1;
    protected int mTotalAmount;
    protected String[] mRemarks;

    public GdAbstractEstimatePdfSheet(int n, int n2, String string) {
        super(n, n2, string);
    }

    @Override
    protected void setUp() {
    }

    @Override
    protected void tearDown() {
    }

    @Override
    protected void drawHeader() {
    }

    @Override
    protected void drawBody() {
        for (GdEstimateRow gdEstimateRow : this.mRowList) {
            this.drawRow(gdEstimateRow);
            ++this.mRowCount;
        }
    }

    @Override
    protected void drawFooter() {
    }

    protected void drawRow(GdEstimateRow gdEstimateRow) {
        this.mPdfGraphics.setFont(GdEstimatePdfUtil.getFont(1));
        if (gdEstimateRow.mCode != null) {
            this.drawDetailAsLeftAlign(gdEstimateRow.mCode, 0);
        }
        if (gdEstimateRow.mQuantity != null) {
            this.drawDetailAsRightAlign(gdEstimateRow.mQuantity, 3);
        }
        if (gdEstimateRow.mPrice != null) {
            this.drawDetailAsRightAlign(gdEstimateRow.mPrice, 4);
        }
        if (gdEstimateRow.mAmount != null) {
            this.drawDetailAsRightAlign(gdEstimateRow.mAmount, 5);
        }
        Font font = gdEstimateRow.mFont == null ? GdEstimatePdfUtil.getFont(0) : gdEstimateRow.mFont;
        this.mPdfGraphics.setFont(font);
        this.drawName(gdEstimateRow.mName);
    }

    protected void drawName(String string) {
        if (string == null) {
            return;
        }
        char[] cArray = string.toCharArray();
        float f = 0.0f;
        int n = cArray.length;
        for (int i = 0; i < cArray.length; ++i) {
            if (!((f += GdPdfUtil.isZenkaku(cArray[i]) ? 1.0f : 0.6f) > 30.0f)) continue;
            n = i;
            break;
        }
        this.drawDetailAsLeftAlign(string.substring(0, n), 1);
        if (n < cArray.length) {
            this.drawDetailAsLeftAlign(string.substring(n, string.length()), 2);
        }
    }

    private void drawDetailAsLeftAlign(String string, int n) {
        this.mPdfGraphics.drawString(string, this.getX(n), this.getY(n));
    }

    private void drawDetailAsRightAlign(int n, int n2) {
        this.drawDetailAsRightAlign(FORMAT.format(n), n2);
    }

    private void drawDetailAsRightAlign(String string, int n) {
        GdPdfUtil.drawStringAsRightAlign(this.mPdfGraphics, string, this.getX(n), this.getY(n));
    }

    private int getX(int n) {
        return DEFAULT_ROW_XS[n];
    }

    private int getY(int n) {
        int n2 = this.mRowY;
        if (n == 1) {
            n2 -= 2;
        } else if (n == 2) {
            ++n2;
        }
        return n2 + this.mRowCount * this.mRowPitch;
    }

    public void setRowY(int n) {
        this.mRowY = n;
    }

    public void setRowPitch(int n) {
        this.mRowPitch = n;
    }

    public void setRemarks(String[] stringArray) {
        this.mRemarks = stringArray;
    }

    public void setTotalAmount(int n) {
        this.mTotalAmount = n;
    }

    public void setMaxRow(int n) {
        this.mMaxRow = n;
    }

    public void addRow(GdEstimateRow gdEstimateRow) {
        this.mRowList.add(gdEstimateRow);
    }

    public void setRows(Collection<GdEstimateRow> collection) {
        for (GdEstimateRow gdEstimateRow : collection) {
            this.addRow(gdEstimateRow);
        }
    }
}

