/*
 * Decompiled with CFR 0.152.
 */
package option.gad.toex.client.gui.step;

import com.kt.io.FileSystem;
import com.kt.io.FileSystem2;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import jp.kitec.richui.GButton;
import jp.kitec.richui.TipsMessage;
import nethome.NethomeLookAndFeel;
import nethome.NethomeResource;
import nethome.ui.MainComponent;
import option.gad.client.util.NetHomeUtil;
import option.gad.toex.client.service.step.GdStep;
import option.gad.toex.client.service.step.GdStepState;
import option.gui.GSpacer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GdNavigationBar
extends JPanel {
    protected List<IStepButton> mStepButtonList = new ArrayList<IStepButton>();

    public GdNavigationBar() {
        this.setLayout(new FlowLayout(0, 0, 0));
    }

    public List<IStepButton> getButtons() {
        return this.mStepButtonList;
    }

    public void create(GdStep[] gdStepArray, ActionListener actionListener) {
        MainComponent mainComponent = NetHomeUtil.getMainComponent();
        FileSystem2 fileSystem2 = mainComponent.getApplication().getFileSystem();
        Frame frame = mainComponent.getParentFrame();
        this.mStepButtonList.clear();
        Color color = NethomeLookAndFeel.TOOLBAR_BACK_DEF_COLOR;
        GSpacer gSpacer = new GSpacer(false, 12);
        this.add(gSpacer);
        for (int i = 0; i < gdStepArray.length; ++i) {
            GdStep gdStep = gdStepArray[i];
            Image image = NethomeResource.getImage((FileSystem)fileSystem2, (String)gdStep.image1Name, (Container)frame);
            Image image2 = NethomeResource.getImage((FileSystem)fileSystem2, (String)gdStep.image2Name, (Container)frame);
            Image image3 = gdStepArray.length > 2 ? NethomeResource.getImage((FileSystem)fileSystem2, (String)gdStep.image3Name, (Container)frame) : image;
            StepButton stepButton = new StepButton(gdStep.state.getName(), image2, image, image3, image, color, color, frame, mainComponent.getTipsMessage(), 1);
            stepButton.setStepState(gdStep.state);
            stepButton.addActionListener(actionListener);
            this.mStepButtonList.add(stepButton);
            this.add((Component)((Object)stepButton));
        }
    }

    public GdStepState getSelected() {
        for (IStepButton iStepButton : this.mStepButtonList) {
            if (!iStepButton.isActive()) continue;
            return iStepButton.getStepState();
        }
        return null;
    }

    public void setState(GdStepState gdStepState, boolean bl, boolean bl2) {
        for (IStepButton iStepButton : this.mStepButtonList) {
            GdStepState gdStepState2 = iStepButton.getStepState();
            if (gdStepState != gdStepState2) continue;
            iStepButton.setActive(bl);
            iStepButton.setEnabled1(bl2);
            return;
        }
    }

    protected static class StepButton
    extends GButton
    implements IStepButton {
        private GdStepState mStepState;

        public StepButton(String string, Image image, Image image2, Image image3, Image image4, Color color, Color color2, Container container, TipsMessage tipsMessage, int n) {
            super(string, image, image2, image3, image4, color, color2, container, tipsMessage, n);
        }

        public GdStepState getStepState() {
            return this.mStepState;
        }

        public void setStepState(GdStepState gdStepState) {
            this.mStepState = gdStepState;
        }
    }

    public static interface IStepButton {
        public GdStepState getStepState();

        public void setStepState(GdStepState var1);

        public boolean isActive();

        public void setActive(boolean var1);

        public void setEnabled1(boolean var1);
    }
}

