/*
 * Decompiled with CFR 0.152.
 */
package option.gad.toex.client.gui.estimate;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import nethome.doc.Document;
import option.gad.core.util.ObjectUtil;
import option.gad.ext.lixil.estsys.entity.Customer;
import option.gad.toex.client.gui.estimate.CompanySuffixType;

public abstract class CustomerComponent
extends JPanel {
    private static final int FIELD_SIZE = 60;
    protected JTextField mTxfEstimateNo;
    protected JTextField mTxfCmCompany;
    protected JTextField mTxfCmChargePerson;
    protected JTextField mTxfCreateDate;
    protected JTextField mTxfSubject;
    protected JTextField mTxfSubjectPlace;
    protected JTextField mTxfDueEstimateDate;
    protected JTextField mTxfPaymentCondition;
    protected JTextField mTxfDueDate;
    protected JTextField mTxfDeliveryPlace;
    protected JTextField mTxfEtCompany;
    protected JTextField mTxfEtBranch;
    protected JTextField mTxfEtDepartment;
    protected JTextField mTxfEtChargeParson;
    protected JTextField mTxfEtPostCode;
    protected JTextField mTxfEtAddress;
    protected JTextField mTxfEtTel;
    protected JTextField mTxfEtFax;
    protected JRadioButton mChBoxCompanySuffixOnchu;
    protected JRadioButton mChBoxCompanySuffixSamatei;

    public CustomerComponent() {
        this.initInterface();
    }

    protected void initInterface() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.createEditComoponent(), "Center");
        jPanel.add((Component)this.createButtons(), "South");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        jPanel2.add(jPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel2, "Center");
    }

    protected JComponent createEditComoponent() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 3, 1, 3);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        JLabel jLabel = this.createDefaultLabel("\u898b\u7a4d\u756a\u53f7");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridx = 1;
        this.mTxfEstimateNo = this.createDefaultTextField(60);
        gridBagLayout.setConstraints(this.mTxfEstimateNo, gridBagConstraints);
        jPanel.add(this.mTxfEstimateNo);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        jLabel = this.createDefaultLabel("\u304a\u5ba2\u69d8\u30fb\u4f1a\u793e\u540d(\u90b8\u540d)");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 1;
        this.mTxfCmCompany = this.createDefaultTextField(60);
        gridBagLayout.setConstraints(this.mTxfCmCompany, gridBagConstraints);
        jPanel.add(this.mTxfCmCompany);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.mChBoxCompanySuffixOnchu = new JRadioButton(CompanySuffixType.ONCHU.mName, true);
        this.mChBoxCompanySuffixSamatei = new JRadioButton(CompanySuffixType.SAMATEI.mName, false);
        buttonGroup.add(this.mChBoxCompanySuffixOnchu);
        buttonGroup.add(this.mChBoxCompanySuffixSamatei);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx += gridBagConstraints.gridwidth;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.mChBoxCompanySuffixOnchu, gridBagConstraints);
        jPanel.add(this.mChBoxCompanySuffixOnchu);
        gridBagConstraints.gridx += gridBagConstraints.gridwidth;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.mChBoxCompanySuffixSamatei, gridBagConstraints);
        jPanel.add(this.mChBoxCompanySuffixSamatei);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        jLabel = this.createDefaultLabel("\u304a\u5ba2\u69d8\u30fb\u62c5\u5f53\u8005\u540d(\u304a\u65bd\u4e3b\u69d8\u540d)");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridx = 1;
        this.mTxfCmChargePerson = this.createDefaultTextField(60);
        gridBagLayout.setConstraints(this.mTxfCmChargePerson, gridBagConstraints);
        jPanel.add(this.mTxfCmChargePerson);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        jLabel = this.createDefaultLabel("\u4f5c\u6210\u65e5");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridx = 1;
        this.mTxfCreateDate = this.createDefaultTextField(60);
        gridBagLayout.setConstraints(this.mTxfCreateDate, gridBagConstraints);
        jPanel.add(this.mTxfCreateDate);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        jLabel = this.createDefaultLabel("\u5de5\u4e8b\u540d");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridx = 1;
        this.mTxfSubject = this.createDefaultTextField(60);
        gridBagLayout.setConstraints(this.mTxfSubject, gridBagConstraints);
        jPanel.add(this.mTxfSubject);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        jLabel = this.createDefaultLabel("\u5de5\u4e8b\u5834\u6240");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridx = 1;
        this.mTxfSubjectPlace = this.createDefaultTextField(60);
        gridBagLayout.setConstraints(this.mTxfSubjectPlace, gridBagConstraints);
        jPanel.add(this.mTxfSubjectPlace);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        jLabel = this.createDefaultLabel("\u898b\u7a4d\u671f\u9650");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridx = 1;
        this.mTxfDueEstimateDate = this.createDefaultTextField(60);
        gridBagLayout.setConstraints(this.mTxfDueEstimateDate, gridBagConstraints);
        jPanel.add(this.mTxfDueEstimateDate);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        jLabel = this.createDefaultLabel("\u652f\u6255\u6761\u4ef6");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridx = 1;
        this.mTxfPaymentCondition = this.createDefaultTextField(60);
        gridBagLayout.setConstraints(this.mTxfPaymentCondition, gridBagConstraints);
        jPanel.add(this.mTxfPaymentCondition);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        jLabel = this.createDefaultLabel("\u7d0d\u671f");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridx = 1;
        this.mTxfDueDate = this.createDefaultTextField(60);
        gridBagLayout.setConstraints(this.mTxfDueDate, gridBagConstraints);
        jPanel.add(this.mTxfDueDate);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        jLabel = this.createDefaultLabel("\u53d7\u6e21\u5834\u6240");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridx = 1;
        this.mTxfDeliveryPlace = this.createDefaultTextField(60);
        gridBagLayout.setConstraints(this.mTxfDeliveryPlace, gridBagConstraints);
        jPanel.add(this.mTxfDeliveryPlace);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        jLabel = this.createDefaultLabel("\u898b\u7a4d\u5074\u30fb\u4f1a\u793e\u540d");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridx = 1;
        this.mTxfEtCompany = this.createDefaultTextField(60);
        gridBagLayout.setConstraints(this.mTxfEtCompany, gridBagConstraints);
        jPanel.add(this.mTxfEtCompany);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        jLabel = this.createDefaultLabel("\u898b\u7a4d\u5074\u30fb\u55b6\u696d\u6240\u540d");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridx = 1;
        this.mTxfEtBranch = this.createDefaultTextField(60);
        gridBagLayout.setConstraints(this.mTxfEtBranch, gridBagConstraints);
        jPanel.add(this.mTxfEtBranch);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        jLabel = this.createDefaultLabel("\u898b\u7a4d\u5074\u30fb\u90e8\u8ab2\u540d");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridx = 1;
        this.mTxfEtDepartment = this.createDefaultTextField(60);
        gridBagLayout.setConstraints(this.mTxfEtDepartment, gridBagConstraints);
        jPanel.add(this.mTxfEtDepartment);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        jLabel = this.createDefaultLabel("\u898b\u7a4d\u5074\u30fb\u62c5\u5f53\u8005\u540d");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridx = 1;
        this.mTxfEtChargeParson = this.createDefaultTextField(60);
        gridBagLayout.setConstraints(this.mTxfEtChargeParson, gridBagConstraints);
        jPanel.add(this.mTxfEtChargeParson);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        jLabel = this.createDefaultLabel("\u898b\u7a4d\u5074\u30fb\u90f5\u4fbf\u756a\u53f7");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridx = 1;
        this.mTxfEtPostCode = this.createDefaultTextField(60);
        gridBagLayout.setConstraints(this.mTxfEtPostCode, gridBagConstraints);
        jPanel.add(this.mTxfEtPostCode);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        jLabel = this.createDefaultLabel("\u898b\u7a4d\u5074\u30fb\u4f4f\u6240");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridx = 1;
        this.mTxfEtAddress = this.createDefaultTextField(60);
        gridBagLayout.setConstraints(this.mTxfEtAddress, gridBagConstraints);
        jPanel.add(this.mTxfEtAddress);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        jLabel = this.createDefaultLabel("\u898b\u7a4d\u5074\u30fb\u96fb\u8a71\u756a\u53f7");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridx = 1;
        this.mTxfEtTel = this.createDefaultTextField(60);
        gridBagLayout.setConstraints(this.mTxfEtTel, gridBagConstraints);
        jPanel.add(this.mTxfEtTel);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        jLabel = this.createDefaultLabel("\u898b\u7a4d\u5074\u30fbFAX \u756a\u53f7");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridx = 1;
        this.mTxfEtFax = this.createDefaultTextField(60);
        gridBagLayout.setConstraints(this.mTxfEtFax, gridBagConstraints);
        jPanel.add(this.mTxfEtFax);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        return jPanel;
    }

    protected JComponent createButtons() {
        JPanel jPanel = new JPanel(new FlowLayout(1, 15, 5));
        JButton jButton = new JButton("\u304a\u5ba2\u69d8\u60c5\u5831\u306e\u8aad\u8fbc");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Customer customer = (Customer)ObjectUtil.shallowCopy((Object)CustomerComponent.this.getCustomer());
                CustomerComponent.this.loadCustomerFromFile();
                ObjectUtil.shallowCopy((Object)customer, (Object)CustomerComponent.this.getCustomer());
            }
        });
        jPanel.add(jButton);
        jButton = new JButton("\u304a\u5ba2\u69d8\u60c5\u5831\u306e\u4fdd\u5b58");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomerComponent.this.updateCustomer();
                CustomerComponent.this.saveCustomerToFile();
            }
        });
        jPanel.add(jButton);
        return jPanel;
    }

    public void loadCustomer() {
        this.loadCustomer(this.getCustomer());
    }

    public void loadCustomer(Document document) {
        this.loadCustomer(this.getCustomer(document));
    }

    public void loadCustomer(Customer customer) {
        this.mTxfEstimateNo.setText(customer.mEstimateNo);
        this.mTxfCmCompany.setText(customer.mCmCompany);
        this.mChBoxCompanySuffixOnchu.setSelected(CompanySuffixType.ONCHU.mName.equals(customer.mCmCompanySuffix));
        this.mChBoxCompanySuffixSamatei.setSelected(CompanySuffixType.SAMATEI.mName.equals(customer.mCmCompanySuffix));
        this.mTxfCmChargePerson.setText(customer.mCmChargePerson);
        this.mTxfCreateDate.setText(customer.mCreateDate);
        this.mTxfSubject.setText(customer.mSubject);
        this.mTxfSubjectPlace.setText(customer.mSubjectPlace);
        this.mTxfDueEstimateDate.setText(customer.mDueEstimateDate);
        this.mTxfPaymentCondition.setText(customer.mPaymentCondition);
        this.mTxfDueDate.setText(customer.mDueDate);
        this.mTxfDeliveryPlace.setText(customer.mDeliveryPlace);
        this.mTxfEtCompany.setText(customer.mEtCompany);
        this.mTxfEtBranch.setText(customer.mEtBranch);
        this.mTxfEtDepartment.setText(customer.mEtDepartment);
        this.mTxfEtChargeParson.setText(customer.mEtChargeParson);
        this.mTxfEtPostCode.setText(customer.mEtPostCode);
        this.mTxfEtAddress.setText(customer.mEtAddress);
        this.mTxfEtTel.setText(customer.mEtTel);
        this.mTxfEtFax.setText(customer.mEtFax);
    }

    public void saveCustomer() {
        this.saveCustomer(this.getCustomer());
    }

    public void saveCustomer(Document document) {
        this.saveCustomer(this.getCustomer(document));
    }

    public void saveCustomer(Customer customer) {
        customer.mEstimateNo = this.mTxfEstimateNo.getText();
        customer.mCmCompany = this.mTxfCmCompany.getText();
        customer.mCmCompanySuffix = this.mChBoxCompanySuffixOnchu.isSelected() ? CompanySuffixType.ONCHU.mName : CompanySuffixType.SAMATEI.mName;
        customer.mCmChargePerson = this.mTxfCmChargePerson.getText();
        customer.mCreateDate = this.mTxfCreateDate.getText();
        customer.mSubject = this.mTxfSubject.getText();
        customer.mSubjectPlace = this.mTxfSubjectPlace.getText();
        customer.mDueEstimateDate = this.mTxfDueEstimateDate.getText();
        customer.mPaymentCondition = this.mTxfPaymentCondition.getText();
        customer.mDueDate = this.mTxfDueDate.getText();
        customer.mDeliveryPlace = this.mTxfDeliveryPlace.getText();
        customer.mEtCompany = this.mTxfEtCompany.getText();
        customer.mEtBranch = this.mTxfEtBranch.getText();
        customer.mEtDepartment = this.mTxfEtDepartment.getText();
        customer.mEtChargeParson = this.mTxfEtChargeParson.getText();
        customer.mEtPostCode = this.mTxfEtPostCode.getText();
        customer.mEtAddress = this.mTxfEtAddress.getText();
        customer.mEtTel = this.mTxfEtTel.getText();
        customer.mEtFax = this.mTxfEtFax.getText();
    }

    protected abstract JLabel createDefaultLabel(String var1);

    protected abstract JTextField createDefaultTextField(int var1);

    protected abstract void loadCustomerFromFile();

    protected abstract void saveCustomerToFile();

    protected abstract void updateCustomer();

    protected abstract Customer getCustomer();

    protected abstract Customer getCustomer(Document var1);
}

