/*
 * Decompiled with CFR 0.152.
 */
package option.gad.client.startup;

import com.kt.util.CompressData;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import option.gad.client.startup.GdObjectRequestAdapter;
import option.gad.core.io.FileIOUtil;
import option.gad.core.util.TimeUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetryableObjectRequestAdapter
implements GdObjectRequestAdapter {
    protected static Log mLog = LogFactory.getLog(RetryableObjectRequestAdapter.class);
    protected Future<Object> mResultFuture;
    protected String mContextPath;
    protected Object mRequest;
    protected URL mCodebase;
    protected Object mKeepResource;
    protected int mConnectTimeOut = 60000;
    protected int mReadTimeOut = 60000;
    protected int mRetryTimeOut = 180000;
    protected int mRetryInterval = 10000;
    protected int mRetryCount = 0;

    public byte[] doRequest(String string, Object object, URL uRL) {
        this.mContextPath = string;
        this.mRequest = object;
        this.mCodebase = uRL;
        this.mKeepResource = null;
        Object object2 = null;
        Exception exception = null;
        long l = System.currentTimeMillis();
        this.mRetryCount = 0;
        while (true) {
            long l2;
            if ((l2 = System.currentTimeMillis()) - l > (long)this.mRetryTimeOut) {
                mLog.error((Object)("resource request failure contextPath[" + this.mContextPath + "] time[" + (l2 - l) + "]ms retry[" + this.mRetryCount + "]"));
                throw new RuntimeException(exception);
            }
            try {
                this.requestThread();
                object2 = this.getResult();
            }
            catch (Exception exception2) {
                exception = exception2;
                TimeUtil.sleep((long)this.mRetryInterval);
                ++this.mRetryCount;
                continue;
            }
            break;
        }
        return (byte[])object2;
    }

    protected void requestThread() {
        ThreadFactory threadFactory = new ThreadFactory(){

            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setPriority(1);
                return thread;
            }
        };
        ExecutorService executorService = Executors.newCachedThreadPool(threadFactory);
        this.mResultFuture = executorService.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return RetryableObjectRequestAdapter.this.request();
            }
        });
    }

    protected Object request() {
        byte[] byArray = null;
        ObjectOutputStream objectOutputStream = null;
        ObjectInputStream objectInputStream = null;
        URL uRL = null;
        try {
            uRL = new URL(this.mCodebase, this.mContextPath);
            mLog.debug((Object)("url[" + uRL + "]"));
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setConnectTimeout(this.mConnectTimeOut);
            uRLConnection.setReadTimeout(this.mReadTimeOut);
            uRLConnection.setDoOutput(true);
            uRLConnection.setDoInput(true);
            uRLConnection.setUseCaches(false);
            uRLConnection.setRequestProperty("Content-type", "application/octet-stream");
            objectOutputStream = new ObjectOutputStream(uRLConnection.getOutputStream());
            byte[] byArray2 = CompressData.compressUnsafe((Object)this.mRequest);
            objectOutputStream.writeObject(byArray2);
            objectInputStream = new ObjectInputStream(uRLConnection.getInputStream());
            byte[] byArray3 = (byte[])objectInputStream.readObject();
            byArray = byArray3 == null ? null : CompressData.decompress((byte[])byArray3);
        }
        catch (Exception exception) {
            try {
                mLog.debug((Object)("urlconnection failure url[" + uRL + "]"), (Throwable)exception);
                throw new RuntimeException(exception);
            }
            catch (Throwable throwable) {
                FileIOUtil.close(objectInputStream);
                FileIOUtil.close(objectOutputStream);
                throw throwable;
            }
        }
        FileIOUtil.close((InputStream)objectInputStream);
        FileIOUtil.close((OutputStream)objectOutputStream);
        return byArray;
    }

    protected Object getResult() {
        Object object = this.mKeepResource;
        if (object == null) {
            this.mKeepResource = object = this.loadResource();
        }
        return object;
    }

    protected <R> R loadResource() {
        long l = System.currentTimeMillis();
        mLog.info((Object)("loading start contextPath[" + this.mContextPath + "] retry[" + this.mRetryCount + "]"));
        if (this.mResultFuture == null) {
            mLog.warn((Object)("loading failure contextPath[" + this.mContextPath + "] retry[" + this.mRetryCount + "]"));
            throw new IllegalStateException("resultFuture is null");
        }
        Object object = null;
        try {
            object = this.mResultFuture.get();
        }
        catch (Exception exception) {
            long l2 = System.currentTimeMillis();
            mLog.warn((Object)("loading failure contextPath[" + this.mContextPath + "] time[" + (l2 - l) + "]ms retry[" + this.mRetryCount + "]"), (Throwable)exception);
            throw new RuntimeException(exception);
        }
        long l3 = System.currentTimeMillis();
        if (object == null) {
            mLog.warn((Object)("loading failure contextPath[" + this.mContextPath + "] time[" + (l3 - l) + "]ms retry[" + this.mRetryCount + "]"));
            throw new IllegalStateException("resource is null");
        }
        mLog.info((Object)("loading completion contextPath[" + this.mContextPath + "] time[" + (l3 - l) + "]ms retry[" + this.mRetryCount + "]"));
        return (R)object;
    }

    @Override
    public void setConnectTimeout(int n) {
        this.mConnectTimeOut = n;
    }

    @Override
    public void setReadTimeout(int n) {
        this.mReadTimeOut = n;
    }

    @Override
    public void setRetryTimeout(int n) {
        this.mRetryTimeOut = n;
    }

    @Override
    public void setRetryInterval(int n) {
        this.mRetryInterval = n;
    }
}

