/*
 * Decompiled with CFR 0.152.
 */
package option.gad.client.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.swing.JDialog;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GdProgressDialog<R>
extends JDialog {
    private static final Log log = LogFactory.getLog(GdProgressDialog.class);
    protected FutureTask<R> result;
    protected boolean canceled;

    public GdProgressDialog(Frame frame, String string, Callable<R> callable) throws HeadlessException {
        super(frame, string, true);
        this.initialize(frame);
        CallableHandler callableHandler = new CallableHandler(callable);
        Callable callable2 = (Callable)Proxy.newProxyInstance(Callable.class.getClassLoader(), new Class[]{Callable.class}, (InvocationHandler)callableHandler);
        this.result = new FutureTask(callable2);
        new Thread(this.result).start();
        this.setVisible(true);
    }

    private void initialize(Frame frame) {
        Container container = this.getContentPane();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        container.setLayout(new GridBagLayout());
        container.setBackground(new Color(0xD0D0D0));
        container.add((Component)this.createProgressBar(), gridBagConstraints);
        this.pack();
        this.setLocationRelativeTo(frame);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (GdProgressDialog.this.result != null) {
                    GdProgressDialog.this.cancel();
                }
            }
        });
    }

    private JProgressBar createProgressBar() {
        JProgressBar jProgressBar = new JProgressBar();
        jProgressBar.setIndeterminate(true);
        jProgressBar.setPreferredSize(new Dimension(260, 15));
        return jProgressBar;
    }

    public synchronized boolean isCanceled() {
        return this.canceled;
    }

    public synchronized void cancel() {
        if (this.result != null) {
            this.result.cancel(true);
        }
        this.setVisible(false);
        this.canceled = true;
    }

    public R getResult() throws InterruptedException, ExecutionException {
        return this.result.get();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CallableHandler
    implements InvocationHandler {
        private Callable<R> call;

        public CallableHandler(Callable<R> callable) {
            this.call = callable;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            Exception exception = null;
            Object object2 = null;
            try {
                object2 = method.invoke(this.call, objectArray);
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            if ("call".equals(method.getName())) {
                log.debug((Object)"call is finished");
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        GdProgressDialog.this.setVisible(false);
                    }
                });
            }
            if (exception != null) {
                throw exception;
            }
            return object2;
        }
    }
}

