/*
 * Decompiled with CFR 0.152.
 */
package option.gad.client.gui;

import com.kt.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import nethome.NethomeLookAndFeel;
import option.gad.client.gui.GdAbstractConfigItemComponent;
import option.gad.client.util.NetHomeUtil;
import option.gad.client.util.SwingUtil;
import option.gad.core.inject.GdInjector;
import option.gad.core.util.Closure;
import option.misc.envdialog.NethomeCommonDialog2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GdAbstractConfigDialog<INFO>
extends NethomeCommonDialog2 {
    protected boolean mInitCompleted = false;
    protected ArrayList<GdAbstractConfigItemComponent<?, INFO>> mRegistCompList = new ArrayList();
    protected Component owner = this;
    protected JComponent mCenterComponent;
    protected JTextArea mRemarkComponent;
    protected JScrollPane mRemarkScrollPane;
    protected JButton mOkButton;
    protected JButton mCancelButton;
    protected INFO mConfigInfo;

    public GdAbstractConfigDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        GdInjector.getInstance().inject((Object)this);
    }

    public GdAbstractConfigDialog(Frame frame, String string, boolean bl, INFO INFO) {
        super(frame, string, bl);
        GdInjector.getInstance().inject((Object)this);
        this.mConfigInfo = INFO;
    }

    public GdAbstractConfigDialog(Dialog dialog, String string, boolean bl) {
        super(dialog, string, bl);
        GdInjector.getInstance().inject((Object)this);
    }

    public GdAbstractConfigDialog(Dialog dialog, String string, boolean bl, INFO INFO) {
        super(dialog, string, bl);
        GdInjector.getInstance().inject((Object)this);
        this.mConfigInfo = INFO;
    }

    @Override
    public void setVisible(boolean bl, Component component, int n) {
        if (!this.mInitCompleted) {
            this.initComponents();
            this.setConfigInfo(this.mConfigInfo);
            this.initValues();
        }
        for (GdAbstractConfigItemComponent<?, INFO> gdAbstractConfigItemComponent : this.mRegistCompList) {
            gdAbstractConfigItemComponent.setVisible(bl);
        }
        this.pack();
        super.setVisible(bl, component, n);
    }

    protected void initComponents() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(this.createRootComponents(), "Center");
        this.settingConfirmButtons();
        this.setUI(jPanel);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GdAbstractConfigDialog.this.windowCloseAction();
            }
        });
        this.initEnterKeyAction();
        List<GdAbstractConfigItemComponent> list = SwingUtil.findManyComponent(this, GdAbstractConfigItemComponent.class);
        for (GdAbstractConfigItemComponent gdAbstractConfigItemComponent : list) {
            gdAbstractConfigItemComponent.addListener((Closure<Object, Void>)new Closure<Void, Void>(){

                public Void execute(Void void_) {
                    GdAbstractConfigDialog.this.updateRootComponents(GdAbstractConfigDialog.this.mConfigInfo);
                    return null;
                }
            });
            gdAbstractConfigItemComponent.addKeyListener((Closure<Object, Void>)new Closure<Void, Void>(){

                public Void execute(Void void_) {
                    GdAbstractConfigDialog.this.updateRootComponents(GdAbstractConfigDialog.this.mConfigInfo);
                    return null;
                }
            });
            this.mRegistCompList.add(gdAbstractConfigItemComponent);
        }
        this.mInitCompleted = true;
        this.updateComponents(this.mConfigInfo);
        this.pack();
        this.updateUI();
    }

    protected void initEnterKeyAction() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0, false);
        this.getRootPane().getInputMap(2).put(keyStroke, "ENTER");
        this.getRootPane().getActionMap().put("ENTER", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                GdAbstractConfigDialog.this.enterKeyClickAction();
            }
        });
    }

    protected void initValues() {
    }

    protected Component createRootComponents() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.mCenterComponent = this.createCenterComponent();
        jPanel.add((Component)this.mCenterComponent, gridBagConstraints);
        return jPanel;
    }

    protected abstract JComponent createCenterComponent();

    protected JComponent createRemarkComponent() {
        this.mRemarkComponent = new JTextArea();
        this.mRemarkComponent.setForeground(Color.RED);
        this.mRemarkComponent.setEditable(false);
        this.mRemarkScrollPane = new JScrollPane(this.mRemarkComponent);
        this.mRemarkScrollPane.setBorder(new TitledBorder("\u5099\u8003"));
        this.mRemarkScrollPane.setVisible(false);
        return this.mRemarkScrollPane;
    }

    protected void settingConfirmButtons() {
        this.mButtonExec = this.mControl.addButton("OK", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GdAbstractConfigDialog.this.okButtonClickAction();
            }
        });
        this.mButtonCancel = this.mControl.addButton("\u30ad\u30e3\u30f3\u30bb\u30eb", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GdAbstractConfigDialog.this.cancelButtonClickAction();
            }
        });
        this.mControl.setEnableComp(this.mButtonExec, true);
        this.mOkButton = (JButton)this.mButtonExec;
        this.mCancelButton = (JButton)this.mButtonCancel;
    }

    protected void windowCloseAction() {
        this.cancelButtonClickAction();
    }

    protected void enterKeyClickAction() {
        this.okButtonClickAction();
    }

    protected void okButtonClickAction() {
        this.decide();
        this.setVisible(false);
    }

    protected void cancelButtonClickAction() {
        this.mChanged = false;
        this.setVisible(false);
    }

    protected void setRemark(String string) {
        if (!this.mInitCompleted) {
            return;
        }
        if (this.mRemarkComponent == null) {
            return;
        }
        if (StringUtil.isEmpty((String)string)) {
            this.mRemarkComponent.setText("");
            this.mRemarkComponent.setForeground(NethomeLookAndFeel.DIALOG_INNER_COLOR);
            this.mRemarkComponent.setBackground(NethomeLookAndFeel.DIALOG_INNER_COLOR);
            this.mRemarkScrollPane.setVisible(false);
        } else {
            this.mRemarkComponent.setText(string);
            this.mRemarkComponent.setForeground(Color.RED);
            this.mRemarkScrollPane.setVisible(true);
            this.mRemarkScrollPane.validate();
        }
    }

    protected void updateUI() {
        NetHomeUtil.repaintCanvas();
    }

    protected void decide() {
        this.updateConfigInfo(this.mConfigInfo);
        this.mChanged = true;
        this.updateUI();
    }

    protected boolean validateValues() {
        boolean bl = true;
        for (GdAbstractConfigItemComponent<?, INFO> gdAbstractConfigItemComponent : this.mRegistCompList) {
            if (gdAbstractConfigItemComponent.isValueValid()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    protected void updateRootComponents(INFO INFO) {
        this.mOkButton.setEnabled(this.validateValues());
    }

    protected abstract void updateComponents(INFO var1);

    protected abstract void updateConfigInfo(INFO var1);

    public void setConfigInfo(INFO INFO) {
        this.mConfigInfo = INFO;
        for (GdAbstractConfigItemComponent<?, INFO> gdAbstractConfigItemComponent : this.mRegistCompList) {
            gdAbstractConfigItemComponent.setConfigInfo(INFO);
        }
    }
}

