/*
 * Decompiled with CFR 0.152.
 */
package option.gad.client.dao;

import com.kt.util.StringUtil;
import com.kt.util.tree.ObjectNode;
import java.util.Collection;
import nethome.geom.primitive.Geometory;
import option.gad.client.util.GdGeomUtil;
import option.gad.core.dxo.TypeConvertUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializeDaoUtil {
    private static final Log mLog = LogFactory.getLog(SerializeDaoUtil.class);

    protected SerializeDaoUtil() {
    }

    public static ObjectNode convertNode(String string, Object object) {
        return new ObjectNode(string, (Object)SerializeDaoUtil.convertString(object));
    }

    public static String convertString(Object object) {
        if (object == null) {
            return null;
        }
        String string = null;
        if (object instanceof Boolean) {
            string = SerializeDaoUtil.convertString((Boolean)object);
        } else if (object instanceof Byte) {
            string = TypeConvertUtil.convertString((Object)object);
        } else if (object instanceof Integer) {
            string = TypeConvertUtil.convertString((Integer)((Integer)object));
        } else if (object instanceof Long) {
            string = TypeConvertUtil.convertString((Object)object);
        } else if (object instanceof Float) {
            string = TypeConvertUtil.convertString((Float)((Float)object));
        } else if (object instanceof Double) {
            string = TypeConvertUtil.convertString((Object)object);
        } else if (object instanceof String) {
            string = TypeConvertUtil.convertString((String)((String)object));
        } else if (object.getClass().isEnum()) {
            string = TypeConvertUtil.convertString((Enum)((Enum)object));
        } else if (object instanceof Geometory) {
            Geometory geometory = (Geometory)object;
            string = TypeConvertUtil.convertString((Integer)geometory.getID());
        }
        return string;
    }

    public static String convertString(Boolean bl) {
        return bl == null ? null : bl.toString();
    }

    public static <T> T convertObject(Class<T> clazz, ObjectNode objectNode) {
        if (objectNode == null) {
            return null;
        }
        Object object = objectNode.getObject();
        if (object == null) {
            return null;
        }
        String string = object.toString();
        return SerializeDaoUtil.convertObject(clazz, string);
    }

    public static <T> T convertObject(Class<T> clazz, String string) {
        Object object = null;
        if (clazz == Boolean.class) {
            object = TypeConvertUtil.convertBoolean((String)string);
        } else if (clazz == Byte.class) {
            object = TypeConvertUtil.convertByte((String)string);
        } else if (clazz == Integer.class) {
            object = TypeConvertUtil.convertInteger((String)string);
        } else if (clazz == Long.class) {
            object = TypeConvertUtil.convertLong((String)string);
        } else if (clazz == Float.class) {
            object = TypeConvertUtil.convertFloat((String)string);
        } else if (clazz == Double.class) {
            object = TypeConvertUtil.convertDouble((String)string);
        } else if (clazz == String.class) {
            object = TypeConvertUtil.convertString((String)string);
        } else if (clazz.isEnum()) {
            object = TypeConvertUtil.convertEnum(clazz, (String)string);
        } else if (Geometory.class.isAssignableFrom(clazz)) {
            throw new IllegalStateException("Geometry is not supported.");
        }
        return (T)object;
    }

    public static <T extends Geometory> T convertObject(Class<T> clazz, Collection<Geometory> collection, ObjectNode objectNode) {
        if (objectNode == null) {
            return null;
        }
        if (objectNode.getObject() == null) {
            return null;
        }
        int n = ObjectNode.getNodeInt((ObjectNode)objectNode);
        return GdGeomUtil.findGeometry(collection, n);
    }

    public static <T extends Geometory> T convertObject(Class<T> clazz, Collection<Geometory> collection, String string) {
        if (StringUtil.isEmpty((String)string)) {
            return null;
        }
        int n = Integer.parseInt(string);
        return SerializeDaoUtil.convertObject(clazz, collection, n);
    }

    public static <T extends Geometory> T convertObject(Class<T> clazz, Collection<Geometory> collection, int n) {
        return GdGeomUtil.findGeometry(collection, n);
    }
}

