/*
 * Decompiled with CFR 0.152.
 */
package option.gad.client.dao;

import com.kt.io.AbstFile;
import com.kt.util.StringUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import option.gad.client.dao.Section;
import option.gad.client.dao.SectionManager;
import option.gad.core.dao.GdDao;
import option.gad.core.dxo.TypeConvertUtil;
import option.gad.core.entity.GdEntity;
import option.gad.core.io.FileIOUtil;
import option.gad.core.util.ClassInfo;
import option.gad.core.util.ClassInfoManager;
import option.gad.core.util.NameUtil;
import option.gad.core.util.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractKitecFormatDao<E> {
    protected String mResourceName = null;
    protected ClassInfo mEntityClazzInfo = null;
    protected String mSectionName = null;
    protected SectionManager mSectionManager = null;
    protected AbstFile mAbstFile = null;
    protected File mFile = null;
    protected OutputStream mOutputStream = null;

    protected AbstractKitecFormatDao() {
        this.init();
    }

    private void init() {
        ClassInfo classInfo = ClassInfoManager.getInstance().getClassInfo(this.getClass());
        GdDao gdDao = classInfo.getType().getAnnotation(GdDao.class);
        if (gdDao == null) {
            throw new IllegalStateException("GdDao is not defined in " + classInfo.getType().getName() + ".");
        }
        this.mEntityClazzInfo = ClassInfoManager.getInstance().getClassInfo(gdDao.entity());
        GdEntity gdEntity = this.mEntityClazzInfo.getType().getAnnotation(GdEntity.class);
        if (gdEntity == null) {
            throw new IllegalStateException("GdEntity is not defined in " + this.mEntityClazzInfo.getType().getName() + ".");
        }
        this.mSectionName = gdEntity.sectionName();
    }

    public E findOne() {
        Section section;
        if (this.mFile == null) {
            return null;
        }
        if (!this.mFile.exists()) {
            return null;
        }
        if (!this.mFile.canRead()) {
            return null;
        }
        if (!this.mAbstFile.InputStreamToBuffer(this.mFile)) {
            throw new RuntimeException();
        }
        if (this.mAbstFile.openReadFileFromBuffer() == null) {
            throw new RuntimeException();
        }
        if (this.mSectionManager == null) {
            this.loadResource();
        }
        if ((section = this.mSectionManager.searchSection(this.mSectionName)) == null) {
            section = this.mSectionManager.searchSection("anonymous");
        }
        if (section == null) {
            throw new RuntimeException("SectionName not found.");
        }
        E e = this.createEntity();
        this.settingDataToEntity(e, section);
        return e;
    }

    private E createEntity() {
        return (E)ReflectUtil.newInstance((Class)this.mEntityClazzInfo.getType(), (Object[])new Object[0]);
    }

    private void settingDataToEntity(E e, Section section) {
        int n = section.getDataCount();
        for (int i = 0; i < n; ++i) {
            String string = section.getData(i);
            String[] stringArray = StringUtil.split((String)string, (String)",", (String)"\"");
            String string2 = NameUtil.addPrefix((String)stringArray[0], (char)'m');
            String string3 = null;
            if (stringArray.length > 1) {
                string3 = stringArray[1];
            }
            ReflectUtil.setFieldValue(e, (String)string2, (Object)string3);
        }
    }

    protected abstract void loadResource();

    public void regist(E e) {
        this.mAbstFile.openNewFileToBuffer("");
        if (!StringUtil.isEmpty((String)this.mSectionName)) {
            this.mAbstFile.writeStringToBufferln("[" + this.mSectionName + "]");
        }
        this.settingEntityToAbstFile(e, this.mAbstFile);
        if (this.mFile != null) {
            this.write(this.mAbstFile, this.mFile);
        }
        if (this.mOutputStream != null) {
            this.mAbstFile.closeNewFileToBuffer();
            this.mAbstFile.BufferToOutputStream(this.mOutputStream);
        }
    }

    private void settingEntityToAbstFile(Object object, AbstFile abstFile) {
        for (Field field : ReflectUtil.getFields(object.getClass())) {
            String string = NameUtil.removePrefix((String)field.getName());
            Object object2 = ReflectUtil.getFieldValue((Object)object, (Field)field);
            String string2 = (String)TypeConvertUtil.convert(String.class, (Object)object2);
            string2 = StringUtil.emptyToZeroString((String)string2);
            abstFile.writeStringToBufferln(string + ",\"" + string2 + "\"");
        }
    }

    private void write(AbstFile abstFile, File file) {
        FileOutputStream fileOutputStream = null;
        try {
            if (file.exists() && !file.canWrite()) {
                throw new RuntimeException("can't write " + file.getName() + ".");
            }
            abstFile.closeNewFileToBuffer();
            fileOutputStream = new FileOutputStream(file);
            abstFile.BufferToOutputStream((OutputStream)fileOutputStream);
        }
        catch (Exception exception) {
            try {
                throw new RuntimeException(exception);
            }
            catch (Throwable throwable) {
                FileIOUtil.close(fileOutputStream);
                throw throwable;
            }
        }
        FileIOUtil.close((OutputStream)fileOutputStream);
    }
}

