/*
 * Decompiled with CFR 0.152.
 */
package option.gad.client.command;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JScrollBar;
import jp.kitec.kwt.Area;
import jp.kitec.kwt.KColor;
import jp.kitec.kwt.KKeyEvent;
import jp.kitec.kwt.KMouseEvent;
import jp.kitec.kwt.KViewPort;
import jp.kitec.richui.AScrollBar;
import nethome.NethomeLookAndFeel;
import nethome.ui.Canvas2D;
import nethome.ui.MainComponent;
import nethome.ui.command.ICommandInfo;
import option.gad.client.command.CanvasRedrawTimer;
import option.gad.client.command.GdCommand;
import option.gad.client.util.NetHomeUtil;

public class GdComViewControl
extends GdCommand
implements ActionListener,
AdjustmentListener,
KeyListener,
MouseListener {
    public JScrollBar mVert;
    public JScrollBar mHor;
    public AScrollBar mZoom;
    private boolean mIsUpdateNow = false;
    private short mFinalMode = (short)-1;
    private CanvasRedrawTimer mTimer = null;
    private float mZoomMin = 0.0f;
    private float mZoomMax = 0.0f;

    public void doPlay() {
    }

    public void doUpdateInterface() {
        Area area = this.mLayer.getWorkSheet().getArea();
        KViewPort kViewPort = this.mCan.mAbstCanvas.getViewPort();
        int n = 30;
        int n2 = this.mHor.getSize().width;
        int n3 = this.mVert.getSize().height;
        int n4 = Math.round((area.maxX - area.minX) * (float)n / (float)n2 / (float)(1 - n / n2));
        int n5 = Math.round((area.maxY - area.minY) * (float)n / (float)n3 / (float)(1 - n / n3));
        int n6 = Math.round(kViewPort.cx);
        int n7 = Math.round(area.maxY - kViewPort.cy);
        if ((float)n6 > area.maxX) {
            n6 = (int)area.maxX;
        } else if ((float)n6 < area.minX) {
            n6 = (int)area.minX;
        }
        if ((float)n7 > area.maxY) {
            n7 = (int)area.maxY;
        } else if ((float)n7 < area.minY) {
            n7 = (int)area.minY;
        }
        this.mIsUpdateNow = true;
        this.mVert.setValues(n7, n5, (int)area.minY, (int)(area.maxY + (float)n5));
        this.mHor.setValues(n6, n4, (int)area.minX, (int)(area.maxX + (float)n4));
        this.mIsUpdateNow = false;
        this.mZoom.setValues(this.mZoomMin, this.mZoomMax, (float)this.mCan.getZoomRatio());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object t = NetHomeUtil.getActiveCanvas();
        if (t == null) {
            return;
        }
        if (this.mFinalMode < 0) {
            this.mFinalMode = t.getDrawMode();
        }
        if (actionEvent.getSource() == this.mZoom) {
            if (actionEvent.getActionCommand() == "DRAG") {
                t.setDrawMode((short)2);
            }
            t.setZoomAsScale(this.mZoom.getValue());
        }
        if (actionEvent.getActionCommand() != null && actionEvent.getActionCommand().equalsIgnoreCase("FINAL")) {
            t.setDrawMode(this.mFinalMode);
            this.mFinalMode = (short)-1;
        } else {
            t.setDrawMode((short)2);
        }
        t.forceImageUpdate();
        t.repaint();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (this.mIsUpdateNow) {
            return;
        }
        Object t = NetHomeUtil.getActiveCanvas();
        if (t == null) {
            return;
        }
        if (adjustmentEvent.getSource() == this.mHor || adjustmentEvent.getSource() == this.mVert) {
            if (adjustmentEvent.getSource() == this.mHor) {
                if (this.mHor.getValueIsAdjusting()) {
                    t.setDrawMode((short)2);
                } else {
                    t.setDrawMode((short)0);
                }
            } else if (this.mVert.getValueIsAdjusting()) {
                t.setDrawMode((short)2);
            } else {
                t.setDrawMode((short)0);
            }
            float f = this.mHor.getValue();
            float f2 = this.mVert.getMaximum() - this.mVert.getValue() - this.mVert.getVisibleAmount();
            ((Canvas2D)t).mAbstCanvas.setViewCenter(f, f2);
            Graphics graphics = t.getGraphics();
            t.forceImageUpdate();
            t.update(graphics);
            graphics.dispose();
        }
    }

    public Component createComponent(ICommandInfo iCommandInfo) {
        super.createComponent(iCommandInfo);
        MainComponent mainComponent = NetHomeUtil.getMainComponent();
        this.mZoomMin = 50.0f;
        this.mZoomMax = 500.0f;
        this.mZoom = new AScrollBar(AScrollBar.MODE_HOR, true, false, mainComponent.getApplication().getImageObserver(), KColor.lightGray2, true, mainComponent.getTipsMessage());
        this.mZoom.setBackground(NethomeLookAndFeel.TOOLBAR_BACK_DEF_COLOR);
        this.mZoom.setPrefSize(150, 26);
        this.mZoom.setInterval(100.0f, 100.0f, "%");
        this.mHor = new JScrollBar(0);
        this.mHor.addAdjustmentListener(this);
        this.mHor.addMouseListener(this);
        this.mHor.setBlockIncrement(500);
        this.mHor.setUnitIncrement(500);
        this.mVert = new JScrollBar(1);
        this.mVert.addAdjustmentListener(this);
        this.mVert.addMouseListener(this);
        this.mVert.setBlockIncrement(500);
        this.mVert.setUnitIncrement(500);
        this.mZoom.setOffset(25.0f, 0.0f);
        this.mZoom.addActionListener((ActionListener)this);
        this.updateInterface();
        return null;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void doWheelUp(int n, int n2, int n3) {
        this.mCan.setDrawMode((short)2);
        this.mIsUpdateNow = true;
        this.timerSet(this.mCan);
        float f = this.mCan.mAbstCanvas.getViewPort().cx;
        float f2 = this.mCan.mAbstCanvas.getViewPort().cy;
        if (KMouseEvent.isCtrlButtonMask((int)n3)) {
            float f3 = this.mCan.mAbstCanvas.devToRealX(n);
            float f4 = this.mCan.mAbstCanvas.devToRealY(n2);
            this.mZoom.inc();
            this.mCan.setZoomAsScale(this.mZoom.getValue());
            float f5 = this.mCan.mAbstCanvas.devToRealX(n);
            float f6 = this.mCan.mAbstCanvas.devToRealY(n2);
            this.mCan.mAbstCanvas.setViewCenter(f += f3 - f5, f2 += f4 - f6);
        } else if (KMouseEvent.isShiftButtonMask((int)n3)) {
            this.updown(this.mHor, -1);
        } else {
            this.updown(this.mVert, 1);
        }
        this.mIsUpdateNow = false;
        this.mCan.forceImageUpdate();
        this.mCan.updateViewControl();
        this.mCan.repaint();
        this.mMc.updateUserInterface();
    }

    public void doWheelDown(int n, int n2, int n3) {
        this.mIsUpdateNow = true;
        this.mCan.setDrawMode((short)2);
        this.timerSet(this.mCan);
        float f = this.mCan.mAbstCanvas.getViewPort().cx;
        float f2 = this.mCan.mAbstCanvas.getViewPort().cy;
        if (KMouseEvent.isCtrlButtonMask((int)n3)) {
            float f3 = this.mCan.mAbstCanvas.devToRealX(n);
            float f4 = this.mCan.mAbstCanvas.devToRealY(n2);
            this.mZoom.dec();
            this.mCan.setZoomAsScale(this.mZoom.getValue());
            float f5 = this.mCan.mAbstCanvas.devToRealX(n);
            float f6 = this.mCan.mAbstCanvas.devToRealY(n2);
            this.mCan.mAbstCanvas.setViewCenter(f += f3 - f5, f2 += f4 - f6);
        } else if (KMouseEvent.isShiftButtonMask((int)n3)) {
            this.updown(this.mHor, 1);
        } else {
            this.updown(this.mVert, -1);
        }
        this.mIsUpdateNow = false;
        this.mCan.forceImageUpdate();
        this.mCan.updateViewControl();
        this.mCan.repaint();
        this.mMc.updateUserInterface();
    }

    public boolean doKeyPress(int n, int n2) {
        if (KKeyEvent.isMutchKey((int)n, (String)"UP")) {
            this.updown(this.mVert, 1);
        } else if (KKeyEvent.isMutchKey((int)n, (String)"DOWN")) {
            this.updown(this.mVert, -1);
        } else if (KKeyEvent.isMutchKey((int)n, (String)"LEFT")) {
            this.updown(this.mHor, -1);
        } else if (KKeyEvent.isMutchKey((int)n, (String)"RIGHT")) {
            this.updown(this.mHor, 1);
        } else if (KKeyEvent.isMutchKey((int)n, (String)"PAGE_UP")) {
            this.mZoom.inc();
            this.mCan.setZoomAsScale(this.mZoom.getValue());
        } else if (KKeyEvent.isMutchKey((int)n, (String)"PAGE_DOWN")) {
            this.mZoom.dec();
            this.mCan.setZoomAsScale(this.mZoom.getValue());
        } else if (KKeyEvent.isMutchKey((int)n, (String)"HOME")) {
            this.mCan.resetView();
        } else {
            return false;
        }
        this.mCan.updateViewControl();
        this.mCan.forceImageUpdate();
        this.mCan.repaint();
        return true;
    }

    private void updown(Object object, int n) {
        Object t = NetHomeUtil.getActiveCanvas();
        KViewPort kViewPort = ((Canvas2D)t).mAbstCanvas.getViewPort();
        float f = kViewPort.cx;
        float f2 = kViewPort.cy;
        if (object == this.mVert) {
            if (n > 0) {
                this.mVert.setValue(this.mVert.getValue() - this.mVert.getBlockIncrement());
                ((Canvas2D)t).mAbstCanvas.setViewCenter(f, (float)(this.mVert.getMaximum() - this.mVert.getValue() - this.mVert.getVisibleAmount()));
            } else {
                this.mVert.setValue(this.mVert.getValue() + this.mVert.getBlockIncrement());
                ((Canvas2D)t).mAbstCanvas.setViewCenter(f, (float)(this.mVert.getMaximum() - this.mVert.getValue() - this.mVert.getVisibleAmount()));
            }
        } else if (object == this.mHor) {
            if (n > 0) {
                this.mHor.setValue(this.mHor.getValue() + this.mHor.getBlockIncrement());
                ((Canvas2D)t).mAbstCanvas.setViewCenter((float)this.mHor.getValue(), f2);
            } else {
                this.mHor.setValue(this.mHor.getValue() - this.mHor.getBlockIncrement());
                ((Canvas2D)t).mAbstCanvas.setViewCenter((float)this.mHor.getValue(), f2);
            }
        }
    }

    private void timerSet(Canvas2D canvas2D) {
        if (this.mTimer != null) {
            if (this.mTimer.isRunning()) {
                this.mTimer.setCount(2);
            } else {
                this.mTimer = null;
            }
        }
        if (this.mTimer == null) {
            this.mTimer = new CanvasRedrawTimer(canvas2D, 200);
            this.mTimer.setCount(2);
            this.mTimer.start();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.keyPress(keyEvent.getKeyCode(), keyEvent.getModifiers());
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void doInitInterface() {
        this.mZoom.setOffset(10.0f, 0.0f);
    }

    public void setSize(int n, int n2) {
        this.mZoom.setPrefSize(n, n2);
    }

    public void setZoomMin(float f) {
        this.mZoomMin = f;
    }

    public void setZoomMax(float f) {
        this.mZoomMax = f;
    }
}

