/*
 * Decompiled with CFR 0.152.
 */
package option.gad.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import option.gad.core.util.SetNotNullDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionUtil {
    protected CollectionUtil() {
    }

    public static int indexOf(Collection<?> object, Object object2) {
        int n = -1;
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return -1;
        }
        int n2 = 0;
        object = object.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            if (e == object2) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    public static <T> T get(Collection<T> object, int n) {
        if (object == null) {
            return null;
        }
        if (n < 0 || object.size() <= n) {
            return null;
        }
        T t = null;
        int n2 = 0;
        object = object.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            if (n2 == n) {
                t = (T)e;
                break;
            }
            ++n2;
        }
        return t;
    }

    @Deprecated
    public static <T> T getLeftNextObject(Collection<T> collection, T t) {
        return CollectionUtil.getPrev(collection, t);
    }

    public static <T> T getPrev(Collection<T> collection, T t) {
        if (collection == null) {
            return null;
        }
        if (t == null) {
            return null;
        }
        int n = CollectionUtil.indexOf(collection, t);
        if (n == -1) {
            return null;
        }
        if (n == 0) {
            return null;
        }
        return CollectionUtil.get(collection, n - 1);
    }

    @Deprecated
    public static <T> T getRightNextObject(Collection<T> collection, T t) {
        return CollectionUtil.getNext(collection, t);
    }

    public static <T> T getNext(Collection<T> collection, T t) {
        if (collection == null) {
            return null;
        }
        if (t == null) {
            return null;
        }
        int n = CollectionUtil.indexOf(collection, t);
        if (n == -1) {
            return null;
        }
        if (n == collection.size() - 1) {
            return null;
        }
        return CollectionUtil.get(collection, n + 1);
    }

    @Deprecated
    public static <T> T getFirstObject(Collection<T> collection) {
        return CollectionUtil.getFirst(collection);
    }

    public static <T> T getFirst(Collection<T> collection) {
        if (collection == null) {
            return null;
        }
        return collection.iterator().next();
    }

    @Deprecated
    public static <T> T getLastObject(Collection<T> collection) {
        return CollectionUtil.getLast(collection);
    }

    public static <T> T getLast(Collection<T> collection) {
        if (collection == null) {
            return null;
        }
        return CollectionUtil.get(collection, collection.size() - 1);
    }

    public static <T, U extends T> void addAll(Collection<T> collection, U[] UArray) {
        if (collection == null) {
            return;
        }
        for (U u : UArray) {
            collection.add(u);
        }
    }

    public static <T, U extends T, TC extends Collection<T>, UC extends Collection<U>> TC addAll(TC object, UC ... UCArray) {
        if (object == null) {
            object = new ArrayList();
        }
        if (UCArray == null) {
            return (TC)object;
        }
        for (UC UC : UCArray) {
            object.addAll(UC);
        }
        return (TC)object;
    }

    public static <T, U extends T, V extends Collection<U>> V merge(V ... VArray) {
        ArrayList arrayList = new ArrayList();
        return (V)CollectionUtil.addAll(arrayList, VArray);
    }

    public static <T> void sort(Collection<T> collection, Comparator<T> comparator) {
        LinkedList<T> linkedList = new LinkedList<T>(collection);
        Collections.sort(linkedList, comparator);
        collection.clear();
        collection.addAll(linkedList);
    }

    public static <T, U> Collection<T> collect(Collection<U> object, Class<T> clazz) {
        SetNotNullDecorator setNotNullDecorator = new SetNotNullDecorator(new LinkedHashSet());
        object = object.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            if (!clazz.isInstance(e)) continue;
            setNotNullDecorator.add(e);
        }
        return setNotNullDecorator;
    }

    public static <V, T extends Collection<V>> T valueFilter(T object, T t, Object[] objectArray) {
        object = object.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            boolean bl = false;
            Object[] objectArray2 = objectArray;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object object2 = objectArray2[i];
                if (e != object2 && (e == null || !e.equals(object2))) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            t.add(e);
        }
        return t;
    }

    public static <K, V, T extends Map<K, V>> T valueFilter(T object, T t, Object[] objectArray) {
        for (Map.Entry entry : object.entrySet()) {
            boolean bl = false;
            Object[] objectArray2 = objectArray;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object object2 = objectArray2[i];
                if (entry.getValue() != object2 && (entry.getValue() == null || !entry.getValue().equals(object2))) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            t.put(entry.getKey(), entry.getValue());
        }
        return t;
    }
}

