/*
 * Decompiled with CFR 0.152.
 */
package option.gad.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import option.gad.core.util.NameUtil;
import option.gad.core.util.ReflectUtil;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectUtil {
    private static final Log b = LogFactory.getLog(ObjectUtil.class);

    protected ObjectUtil() {
    }

    public static boolean isLangType(Object object) {
        return ObjectUtil.isLangType(object.getClass());
    }

    public static boolean isLangType(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        boolean bl = false;
        if (clazz == Boolean.TYPE) {
            bl = true;
        } else if (clazz == Byte.TYPE) {
            bl = true;
        } else if (clazz == Integer.TYPE) {
            bl = true;
        } else if (clazz == Long.TYPE) {
            bl = true;
        } else if (clazz == Float.TYPE) {
            bl = true;
        } else if (clazz == Double.TYPE) {
            bl = true;
        } else if (Boolean.class.isAssignableFrom(clazz)) {
            bl = true;
        } else if (Byte.class.isAssignableFrom(clazz)) {
            bl = true;
        } else if (Integer.class.isAssignableFrom(clazz)) {
            bl = true;
        } else if (Long.class.isAssignableFrom(clazz)) {
            bl = true;
        } else if (Float.class.isAssignableFrom(clazz)) {
            bl = true;
        } else if (Double.class.isAssignableFrom(clazz)) {
            bl = true;
        } else if (String.class.isAssignableFrom(clazz)) {
            bl = true;
        } else if (clazz.isEnum()) {
            bl = true;
        }
        return bl;
    }

    public static <T> T shallowCopy(T t) {
        Object obj = ReflectUtil.newInstance(t.getClass(), new Object[0]);
        ObjectUtil.shallowCopy(t, obj);
        return (T)obj;
    }

    public static <T> void shallowCopy(T t, T t2) {
        for (Field field : ReflectUtil.getFields(t)) {
            try {
                Field field2 = ReflectUtil.getField(t2, field.getName());
                ReflectUtil.setFieldValue(t2, field2, field.get(t));
            }
            catch (Exception exception) {}
        }
    }

    public static <T> void shallowCopyChangePrefix(Object object, Object object2, char c, char c2) {
        for (Field field : ReflectUtil.getFields(object)) {
            Object object3;
            try {
                String string;
                object3 = ReflectUtil.getFieldValue(object, field);
                String string2 = string = field.getName();
                if (c2 == '+') {
                    string2 = NameUtil.addPrefix(string, c);
                } else if (c2 == '-') {
                    string2 = NameUtil.removePrefix(string, c);
                }
                if (!ReflectUtil.existField(object2.getClass(), string2)) continue;
                ReflectUtil.setFieldValue(object2, string2, object3);
            }
            catch (Exception exception) {
                object3 = exception;
                exception.printStackTrace();
            }
        }
    }

    public static <T> Collection<T> shallowCopy(Collection<T> collection) {
        Collection collection2 = (Collection)ReflectUtil.newInstance(collection.getClass(), new Object[0]);
        return ObjectUtil.shallowCopy(collection, collection2);
    }

    public static <T> Collection<T> shallowCopy(Collection<T> collection, Collection<T> collection2) {
        for (Object object : collection) {
            object = ReflectUtil.newInstance(object.getClass(), new Object[0]);
            ObjectUtil.shallowCopy(collection, object);
            collection2.add(object);
        }
        return collection2;
    }

    public static <T> void shallowCopy(T[] TArray, T[] TArray2) {
        int n = 0;
        T[] TArray3 = TArray;
        int n2 = TArray.length;
        for (int i = 0; i < n2; ++i) {
            Object object = TArray3[i];
            object = ReflectUtil.newInstance(object.getClass(), new Object[0]);
            ObjectUtil.shallowCopy(TArray, object);
            TArray2[n++] = object;
        }
    }

    public static <T extends Serializable> T deepCopy(T object) {
        if (object == null) {
            return null;
        }
        Serializable serializable = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            object = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            object = new ObjectInputStream((InputStream)object);
            serializable = (Serializable)((ObjectInputStream)object).readObject();
        }
        catch (Exception exception) {
            b.debug((Object)"", (Throwable)exception);
        }
        return (T)serializable;
    }

    public static String toString(Object object) {
        if (object == null) {
            return "null";
        }
        ToStringBuilder toStringBuilder = new ToStringBuilder(object);
        for (Field field : ReflectUtil.getFields(object)) {
            toStringBuilder.append(ReflectUtil.getFieldValue(object, field));
        }
        return toStringBuilder.toString();
    }

    public static String[] toStringArray(Object object) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object2 = ReflectUtil.getFields(object);
        object2 = object2.iterator();
        while (object2.hasNext()) {
            Object object3 = (Field)object2.next();
            if ((object3 = ReflectUtil.getFieldValue(object, (Field)object3)) == null) continue;
            arrayList.add(object3.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static boolean equals(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object != null && object2 == null) {
            return false;
        }
        if (object == null && object2 != null) {
            return false;
        }
        return object.equals(object2);
    }

    public static boolean equalFields(Object object, Object object2) {
        for (Field field : ReflectUtil.getFields(object)) {
            String string = field.getName();
            Object object3 = ReflectUtil.getFieldValue(object, string);
            Object object32 = ReflectUtil.getFieldValue(object2, string);
            if (object3 == null && object32 == null) continue;
            if (object3 == null && object32 != null) {
                return false;
            }
            if (object3 != null && object32 == null) {
                return false;
            }
            if (object3.equals(object32)) continue;
            return false;
        }
        return true;
    }
}

