/*
 * Decompiled with CFR 0.152.
 */
package option.gad.core.util;

import java.math.BigDecimal;

public class MathUtil {
    public static final double PI = Math.PI;
    public static final double E = Math.E;

    private MathUtil() {
    }

    public static double nextAfter(double d, double d2) {
        long l;
        long l2;
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return Double.NaN;
        }
        if (d == d2) {
            return d2;
        }
        if (Double.isInfinite(d)) {
            if (d < 0.0) {
                return -1.7976931348623157E308;
            }
            return Double.MAX_VALUE;
        }
        if (d == 0.0) {
            if (d2 < 0.0) {
                return -4.9E-324;
            }
            return Double.MIN_VALUE;
        }
        if (d2 < d ^ (l2 = (l = Double.doubleToRawLongBits(d)) & Long.MIN_VALUE) == 0L) {
            return Double.longBitsToDouble(l2 | (l & Long.MAX_VALUE) + 1L);
        }
        return Double.longBitsToDouble(l2 | (l & Long.MAX_VALUE) - 1L);
    }

    public static float nextAfter(float f, double d) {
        int n;
        int n2;
        if (Double.isNaN(f) || Double.isNaN(d)) {
            return Float.NaN;
        }
        if ((double)f == d) {
            return (float)d;
        }
        if (Float.isInfinite(f)) {
            if (f < 0.0f) {
                return -3.4028235E38f;
            }
            return Float.MAX_VALUE;
        }
        if (f == 0.0f) {
            if (d < 0.0) {
                return -1.4E-45f;
            }
            return Float.MIN_VALUE;
        }
        if (d < (double)f ^ (n2 = (n = Float.floatToIntBits(f)) & Integer.MIN_VALUE) == 0) {
            return Float.intBitsToFloat(n2 | (n & Integer.MAX_VALUE) + 1);
        }
        return Float.intBitsToFloat(n2 | (n & Integer.MAX_VALUE) - 1);
    }

    public static double floor(double d) {
        if (d != d) {
            return d;
        }
        if (d >= 4.503599627370496E15 || d <= -4.503599627370496E15) {
            return d;
        }
        long l = (long)d;
        if (d < 0.0 && (double)l != d) {
            --l;
        }
        if (l == 0L) {
            return d * (double)l;
        }
        return l;
    }

    public static double ceil(double d) {
        if (d != d) {
            return d;
        }
        double d2 = MathUtil.floor(d);
        if (d2 == d) {
            return d2;
        }
        if ((d2 += 1.0) == 0.0) {
            return d * d2;
        }
        return d2;
    }

    public static double rint(double d) {
        double d2;
        double d3 = MathUtil.floor(d);
        double d4 = d - d3;
        if (d2 > 0.5) {
            if (d3 == -1.0) {
                return -0.0;
            }
            return d3 + 1.0;
        }
        if (d4 < 0.5) {
            return d3;
        }
        long l = (long)d3;
        if ((l & 1L) == 0L) {
            return d3;
        }
        return d3 + 1.0;
    }

    public static long round(double d) {
        return (long)MathUtil.floor(d + 0.5);
    }

    public static int round(float f) {
        return (int)MathUtil.floor(f + 0.5f);
    }

    public static double round(double d, int n) {
        return MathUtil.round(d, n, 4);
    }

    public static double round(double d, int n, int n2) {
        try {
            return new BigDecimal(Double.toString(d)).setScale(n, n2).doubleValue();
        }
        catch (NumberFormatException numberFormatException) {
            if (Double.isInfinite(d)) {
                return d;
            }
            return Double.NaN;
        }
    }

    public static float round(float f, int n) {
        return MathUtil.round(f, n, 4);
    }

    /*
     * Handled duff style switch with additional control
     * Enabled aggressive block sorting
     */
    public static float round(float f, int n, int n2) {
        float f2 = MathUtil.copySign(1.0f, f);
        float f3 = (float)Math.pow(10.0, n) * f2;
        int n3 = n2;
        double d = f2;
        double d2 = f * f3;
        int n4 = Integer.MIN_VALUE;
        block10: do {
            switch (n4 == Integer.MIN_VALUE ? n3 : n4) {
                case 2: {
                    if (d == -1.0) {
                        d2 = MathUtil.floor(MathUtil.nextAfter(d2, Double.NEGATIVE_INFINITY));
                        return (float)d2 / f3;
                    }
                    d2 = MathUtil.ceil(MathUtil.nextAfter(d2, Double.POSITIVE_INFINITY));
                    return (float)d2 / f3;
                }
                case 1: {
                    d2 = MathUtil.floor(MathUtil.nextAfter(d2, Double.NEGATIVE_INFINITY));
                    return (float)d2 / f3;
                }
                case 3: {
                    n4 = 0;
                    if (d == -1.0) continue block10;
                    d2 = MathUtil.floor(MathUtil.nextAfter(d2, Double.NEGATIVE_INFINITY));
                    return (float)d2 / f3;
                }
                case 5: {
                    double d3;
                    d2 = MathUtil.nextAfter(d2, Double.NEGATIVE_INFINITY);
                    double d4 = d2 - MathUtil.floor(d2);
                    if (d3 > 0.5) {
                        d2 = MathUtil.ceil(d2);
                        return (float)d2 / f3;
                    }
                    d2 = MathUtil.floor(d2);
                    return (float)d2 / f3;
                }
                case 6: {
                    double d5;
                    double d6 = d2 - MathUtil.floor(d2);
                    if (d5 > 0.5) {
                        d2 = MathUtil.ceil(d2);
                        return (float)d2 / f3;
                    }
                    if (d6 < 0.5) {
                        d2 = MathUtil.floor(d2);
                        return (float)d2 / f3;
                    }
                    if (MathUtil.floor(d2) / 2.0 == MathUtil.floor(Math.floor(d2) / 2.0)) {
                        d2 = MathUtil.floor(d2);
                        return (float)d2 / f3;
                    }
                    d2 = MathUtil.ceil(d2);
                    return (float)d2 / f3;
                }
                case 4: {
                    double d7;
                    d2 = MathUtil.nextAfter(d2, Double.POSITIVE_INFINITY);
                    double d8 = d2 - MathUtil.floor(d2);
                    if (d7 >= 0.5) {
                        d2 = MathUtil.ceil(d2);
                        return (float)d2 / f3;
                    }
                    d2 = MathUtil.floor(d2);
                    return (float)d2 / f3;
                }
                case 7: {
                    if (d2 == MathUtil.floor(d2)) return (float)d2 / f3;
                    throw new RuntimeException();
                }
                case 0: {
                    d2 = MathUtil.ceil(MathUtil.nextAfter(d2, Double.POSITIVE_INFINITY));
                    return (float)d2 / f3;
                }
            }
            return (float)d2 / f3;
        } while (true);
        return (float)d2 / f3;
    }

    public static double copySign(double d, double d2) {
        long l;
        long l2 = Double.doubleToRawLongBits(d);
        if ((l2 ^ (l = Double.doubleToRawLongBits(d2))) >= 0L) {
            return d;
        }
        return -d;
    }

    public static float copySign(float f, float f2) {
        int n;
        int n2 = Float.floatToRawIntBits(f);
        if ((n2 ^ (n = Float.floatToRawIntBits(f2))) >= 0) {
            return f;
        }
        return -f;
    }
}

