/*
 * Decompiled with CFR 0.152.
 */
package option.gad.core.inject;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import option.gad.core.inject.GdInject;
import option.gad.core.inject.GdInstanceFactory;
import option.gad.core.util.ReflectUtil;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GdInjector {
    private static GdInjector e;
    private Set<Object> f = new HashSet<Object>();

    protected GdInjector() {
    }

    public static GdInjector getInstance() {
        return e;
    }

    public void inject(Object object) {
        if (this.f.contains(object)) {
            return;
        }
        this.f.add(object);
        this.injectMethods(object, ReflectUtil.getMethods(object));
        this.injectFields(object, ReflectUtil.getFields(object));
    }

    public void injectMethods(Object object, Collection<Method> object2) {
        object2 = object2.iterator();
        while (object2.hasNext()) {
            Method method = (Method)object2.next();
            this.injectMethod(object, method);
        }
    }

    public boolean injectMethod(Object object, Method method) {
        if (method.getAnnotation(GdInject.class) == null) {
            return false;
        }
        if (method.getParameterTypes() == null) {
            return false;
        }
        if (method.getParameterTypes().length != 1) {
            return false;
        }
        Class<?> clazz = method.getParameterTypes()[0];
        clazz = GdInstanceFactory.getInstance().getInstance(clazz, new Object[0]);
        if (clazz == null) {
            return false;
        }
        ReflectUtil.invokeMethod(object, method, clazz);
        return true;
    }

    public void injectFields(Object object, Collection<Field> object2) {
        object2 = object2.iterator();
        while (object2.hasNext()) {
            Field field = (Field)object2.next();
            if (!this.injectField(object, field)) continue;
            this.inject(GdInstanceFactory.getInstance().getInstance(field.getType(), new Object[0]));
        }
    }

    public boolean injectField(Object object, Field field) {
        if (field.getAnnotation(GdInject.class) == null) {
            return false;
        }
        if (ReflectUtil.getFieldValue(object, field) != null) {
            return false;
        }
        Class<?> clazz = field.getType();
        clazz = GdInstanceFactory.getInstance().getInstance(clazz, new Object[0]);
        if (clazz == null) {
            return false;
        }
        ReflectUtil.setFieldValue(object, field, clazz);
        return true;
    }

    public void clear() {
        this.f.clear();
    }

    static {
        LogFactory.getLog(GdInjector.class);
        e = new GdInjector();
    }
}

