/*
 * Decompiled with CFR 0.152.
 */
package option.gad.core.dao;

import com.kt.annotation.Reflectable;
import com.kt.util.StringUtil;
import com.kt.util.tree.ObjectFolder;
import com.kt.util.tree.ObjectNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import option.gad.core.annotation.GdPrefix;
import option.gad.core.annotation.GdProperty;
import option.gad.core.annotation.GdVersion;
import option.gad.core.dao.GdSaveFileDao;
import option.gad.core.util.MathUtil;
import option.gad.core.util.ObjectFolderUtil;
import option.gad.core.util.ObjectNodeUtil;
import option.gad.core.util.ReflectUtil;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GdAbstractSaveFileDao<IN, OUT, DOC>
implements GdSaveFileDao<IN, OUT, DOC> {
    private Log b = LogFactory.getLog(GdAbstractSaveFileDao.class);
    protected HashMap<SaveFileStatus, List<String>> mMessageListMap = new HashMap();
    protected SaveFileStatus mStatus = SaveFileStatus.NORMAL;

    protected GdAbstractSaveFileDao() {
        this.init();
    }

    protected String configRowSuffix() {
        return "Row";
    }

    protected String createRowName(String string) {
        return string + this.configRowSuffix();
    }

    protected void init() {
        for (SaveFileStatus saveFileStatus : SaveFileStatus.values()) {
            this.mMessageListMap.put(saveFileStatus, new ArrayList());
        }
    }

    protected <T> void saveFolder(ObjectFolder objectFolder, String string, T t) {
        if (t == null) {
            return;
        }
        objectFolder.addChild((ObjectNode)ObjectFolderUtil.createFolder(t, string, GdProperty.class));
    }

    protected <T> void saveFoldersWithDefaultRowName(ObjectFolder objectFolder, String string, Collection<T> collection) {
        String string2 = this.createRowName(string);
        this.saveFolders(objectFolder, string, string2, collection);
    }

    protected <T> void saveFolders(ObjectFolder objectFolder, String string, String string2, Collection<T> object) {
        if (object == null || object.isEmpty()) {
            return;
        }
        string = ObjectFolderUtil.createFolder(object, string, GdProperty.class);
        object = object.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            string.addChild((ObjectNode)ObjectFolderUtil.createFolder(e, string2, GdProperty.class), true);
        }
        objectFolder.addChild((ObjectNode)string);
    }

    protected abstract Class<?>[] configLoadClasses();

    protected Class<?> findClass(String string, int n) {
        Class<?> clazz;
        String string2;
        if (n == 0) {
            string2 = string;
        } else {
            clazz = "V" + n;
            string2 = string + (String)((Object)clazz);
        }
        clazz = null;
        for (Class<?> clazz2 : this.configLoadClasses()) {
            Object object = clazz2.getAnnotation(Reflectable.class);
            assert (object != null) : "Reflectable not found from " + clazz2.getSimpleName() + ".";
            GdPrefix gdPrefix = clazz2.getAnnotation(GdPrefix.class);
            object = object.name();
            String string3 = string2;
            if (gdPrefix != null) {
                string3 = gdPrefix.name() + string2;
            }
            if (string.equals(object)) {
                clazz = clazz2;
                break;
            }
            if (string2.equals(object)) {
                clazz = clazz2;
                break;
            }
            if (!string3.equals(object)) continue;
            clazz = clazz2;
            break;
        }
        assert (!StringUtil.isEmpty((String)string)) : "clazzName is empty.";
        if (clazz == null) {
            clazz = ReflectUtil.getClass(string);
        }
        return clazz;
    }

    protected <T> T loadFolder(ObjectFolder objectFolder, String string) {
        return this.loadFolder(objectFolder, string, "");
    }

    protected <T> T loadFolder(ObjectFolder objectFolder, String string, Class<?> clazz) {
        Reflectable reflectable = clazz.getAnnotation(Reflectable.class);
        assert (reflectable != null) : "Reflectable not found from " + clazz.getSimpleName() + ".";
        return this.loadFolder(objectFolder, string, reflectable.name());
    }

    protected <T> T loadFolder(ObjectFolder object, String string, String string2) {
        if ((object = ObjectFolderUtil.findChildFolders((ObjectFolder)object, (String)string)).size() != 1) {
            return null;
        }
        object = (ObjectFolder)object.iterator().next();
        return this.createObject((ObjectFolder)object, string, string2);
    }

    protected <T> Collection<T> loadFolders(ObjectFolder objectFolder, String string, String string2) {
        return this.loadFolders(objectFolder, string, string2, null, null);
    }

    protected <T> Collection<T> loadFoldersWithDefaultRowName(ObjectFolder objectFolder, String string, Class<?> clazz) {
        return this.loadFoldersWithDefaultRowName(objectFolder, string, clazz, null);
    }

    protected <T> Collection<T> loadFoldersWithDefaultRowName(ObjectFolder objectFolder, String string, Class<?> clazz, Class<?> clazz2) {
        String string2 = this.createRowName(string);
        return this.loadFoldersByDefaultClazz(objectFolder, string, string2, clazz, clazz2);
    }

    protected <T> Collection<T> loadFolders(ObjectFolder objectFolder, String string, String string2, Class<?> clazz) {
        return this.loadFoldersByDefaultClazz(objectFolder, string, string2, null, clazz);
    }

    protected <T> Collection<T> loadFoldersByDefaultClazz(ObjectFolder objectFolder, String string, String string2, Class<?> clazz, Class<?> clazz2) {
        Object object;
        String string3 = null;
        if (clazz2 != null) {
            object = clazz2.getAnnotation(Reflectable.class);
            assert (object != null) : "Reflectable not found from " + clazz2.getSimpleName() + ".";
            string3 = object.name();
        }
        object = null;
        if (clazz != null) {
            object = clazz.getName();
        }
        return this.loadFolders(objectFolder, string, string2, (String)object, string3);
    }

    protected <T> Collection<T> loadFolders(ObjectFolder object, String string, String string2, String object2, String string3) {
        if ((object = ObjectFolderUtil.findChildFolders((ObjectFolder)object, (String)string)).size() != 1) {
            return null;
        }
        String string4 = ObjectNodeUtil.toString((object = (ObjectFolder)object.iterator().next()).getNode("type"));
        if (StringUtil.isEmpty((String)string4)) {
            string4 = object2;
        }
        if (StringUtil.isEmpty((String)string4)) {
            string4 = ArrayList.class.getName();
        }
        object2 = (Collection)ReflectUtil.newInstance(string4, new Object[0]);
        object = ObjectFolderUtil.findChildFolders((ObjectFolder)object, (String)string2);
        object = object.iterator();
        while (object.hasNext()) {
            string2 = (ObjectFolder)object.next();
            if ((string2 = this.createObject((ObjectFolder)string2, string, string3)) == null) continue;
            object2.add(string2);
        }
        return object2;
    }

    protected <T> T createObject(ObjectFolder objectFolder, String clazz, String string) {
        String string2 = ObjectNodeUtil.toString(objectFolder.getNode("type"));
        if (StringUtil.isEmpty((String)string2)) {
            string2 = string;
        }
        if (StringUtil.isEmpty((String)string2)) {
            this.b.info((Object)("type not found from '" + (String)((Object)clazz) + "' node."));
            return null;
        }
        clazz = null;
        for (int i = this.getDaoVersion(); i >= 0; --i) {
            try {
                clazz = this.findClass(string2, i);
                if (clazz == null) continue;
                break;
            }
            catch (Exception exception) {}
        }
        if (clazz == null) {
            if (StringUtil.isEmpty((String)string)) {
                this.b.info((Object)"default-type not found.");
                return null;
            }
            clazz = this.findClass(string, 0);
            if (clazz == null) {
                this.b.info((Object)("class not found from '" + string2 + "' type."));
                return null;
            }
        }
        return ObjectFolderUtil.createObject(clazz, objectFolder, GdProperty.class);
    }

    protected int getDaoVersion() {
        Object object = this.getClass().getAnnotation(GdVersion.class);
        object = object != null ? object.value().replaceAll("\\.", "") : "";
        return NumberUtils.toInt((String)object, (int)0);
    }

    public String getSaveDataVersion() {
        GdVersion gdVersion = this.getClass().getAnnotation(GdVersion.class);
        return StringUtil.emptyToDefault((String)gdVersion.value(), (String)"Unknown");
    }

    protected Integer getBuildNumber() {
        Serializable serializable;
        String string = "0";
        try {
            serializable = new Properties();
            serializable.load(this.getClass().getClassLoader().getResourceAsStream("buildnumber.properties"));
            string = (String)serializable.get("build.number");
        }
        catch (Exception exception) {}
        serializable = null;
        try {
            serializable = Integer.valueOf(new Double(MathUtil.floor(Float.parseFloat(string))).intValue());
        }
        catch (Exception exception) {}
        return serializable;
    }

    @Deprecated
    public List<String> getMessageList() {
        return this.mMessageListMap.get((Object)SaveFileStatus.NORMAL);
    }

    public List<String> getAllMessageList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SaveFileStatus saveFileStatus : SaveFileStatus.values()) {
            arrayList.addAll((Collection<String>)this.mMessageListMap.get((Object)saveFileStatus));
        }
        return arrayList;
    }

    public Map<SaveFileStatus, List<String>> getMessageListMap() {
        return this.mMessageListMap;
    }

    public void clearAllMessages() {
        for (SaveFileStatus saveFileStatus : SaveFileStatus.values()) {
            this.mMessageListMap.get((Object)saveFileStatus).clear();
        }
    }

    public void setStatus(SaveFileStatus saveFileStatus) {
        this.mStatus = saveFileStatus;
    }

    public void updateStatus(SaveFileStatus saveFileStatus) {
        if (this.mStatus.ordinal() < saveFileStatus.ordinal()) {
            this.mStatus = saveFileStatus;
        }
    }

    public SaveFileStatus getStatus() {
        return this.mStatus;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SaveFileStatus {
        NORMAL,
        WARN,
        ERROR;

    }
}

