/*
 * Decompiled with CFR 0.152.
 */
package option.gad.core.util;

import com.kt.util.StringUtil;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import option.gad.core.util.ClassInfo;
import option.gad.core.util.ClassInfoManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectUtil {
    private static final Log k = LogFactory.getLog(ReflectUtil.class);

    protected ReflectUtil() {
    }

    public static <T> T newInstance(String string, Object ... objectArray) {
        return (T)ReflectUtil.newInstance(ReflectUtil.getClass(string), objectArray);
    }

    public static <T> T newInstance(Class<T> clazz, Object ... objectArray) {
        T t = null;
        try {
            Object object = ReflectUtil.getParameterTypes(objectArray);
            object = ReflectUtil.getConstructor(clazz, object);
            if (!((AccessibleObject)object).isAccessible()) {
                ((Constructor)object).setAccessible(true);
            }
            t = ((Constructor)object).newInstance(objectArray);
        }
        catch (Exception exception) {
            k.info((Object)("class name[" + clazz.getName() + "]"), (Throwable)exception);
        }
        return t;
    }

    public static Object invokeMethod(String string, String string2, Object ... objectArray) {
        return ReflectUtil.invokeMethod(ReflectUtil.getClass(string), string2, objectArray);
    }

    public static Object invokeMethod(Class<?> clazz, String string, Object ... objectArray) {
        Object object = ReflectUtil.getParameterTypes(objectArray);
        if ((object = ReflectUtil.getMethod(clazz, string, object)) == null) {
            k.info((Object)("The method '" + string + "' not found in " + clazz.getName() + "."));
        }
        return ReflectUtil.invokeMethod(clazz, object, objectArray);
    }

    public static Object invokeMethod(Object object, String string, Object ... objectArray) {
        Object object2 = ReflectUtil.getParameterTypes(objectArray);
        if ((object2 = ReflectUtil.getMethod(object, string, object2)) == null) {
            k.info((Object)("The method '" + string + "' not found in '" + object.getClass().getName() + "'."));
        }
        return ReflectUtil.invokeMethod(object, object2, objectArray);
    }

    public static Object invokeMethod(Object object, Method method, Object ... objectArray) {
        if (object == null) {
            return null;
        }
        if (method == null) {
            return null;
        }
        Object object2 = null;
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            object2 = method.invoke(object, objectArray);
        }
        catch (Exception exception) {
            k.info((Object)"", (Throwable)exception);
        }
        return object2;
    }

    public static boolean setFieldValue(Class<?> clazz, String string, Object object) {
        return ReflectUtil.setFieldValue(null, ReflectUtil.getField(clazz, string), object);
    }

    public static boolean setFieldValue(Object object, String string, Object object2) {
        if (object == null) {
            return false;
        }
        return ReflectUtil.setFieldValue(object, ReflectUtil.getField(object, string), object2);
    }

    public static boolean setFieldValue(Object object, Field field, Object object2) {
        if (field == null) {
            return false;
        }
        if (field.getType().isPrimitive() && object2 == null) {
            return false;
        }
        boolean bl = false;
        try {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            field.set(object, object2);
            bl = true;
        }
        catch (Exception exception) {
            k.info((Object)"", (Throwable)exception);
        }
        return bl;
    }

    public static Object getFieldValue(Class<?> clazz, String string) {
        return ReflectUtil.getFieldValue(null, ReflectUtil.getField(clazz, string));
    }

    public static Object getFieldValue(Object object, String string) {
        if (object == null) {
            return null;
        }
        return ReflectUtil.getFieldValue(object, ReflectUtil.getField(object, string));
    }

    public static Object getFieldValue(Object object, Field field) {
        if (field == null) {
            return null;
        }
        Object object2 = null;
        try {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            object2 = field.get(object);
        }
        catch (Exception exception) {
            k.info((Object)"", (Throwable)exception);
        }
        return object2;
    }

    public static Class<?> getClass(String string) {
        if (string == null) {
            return null;
        }
        ClassInfo classInfo = ClassInfoManager.getInstance().getClassInfo(string);
        if (classInfo == null) {
            throw new IllegalStateException(String.valueOf(string) + " not found.");
        }
        return classInfo.getType();
    }

    public static Constructor<?> getConstructor(Class<?> clazz, Class<?> ... object) {
        if (clazz == null) {
            return null;
        }
        ClassInfo classInfo = ClassInfoManager.getInstance().getClassInfo(clazz);
        if (classInfo == null) {
            throw new IllegalStateException(clazz + " not found.");
        }
        if ((object = classInfo.getConstructor((Class<?>)object)) == null) {
            throw new IllegalStateException(clazz + "'s constructor not found.");
        }
        return object;
    }

    public static Method getMethod(Object object, String string, Class<?> ... classArray) {
        if (object == null) {
            return null;
        }
        return ReflectUtil.getMethod(object.getClass(), string, classArray);
    }

    public static Method getMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        if (clazz == null) {
            return null;
        }
        if (string == null) {
            return null;
        }
        return ClassInfoManager.getInstance().getClassInfo(clazz).getMethod(string, classArray);
    }

    public static Collection<Method> getMethods(Object object) {
        if (object == null) {
            return null;
        }
        return ClassInfoManager.getInstance().getClassInfo(object.getClass()).getMethods();
    }

    public static Collection<Method> getMethods(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return ClassInfoManager.getInstance().getClassInfo(clazz).getMethods();
    }

    public static Field getField(Object object, String string) {
        if (object == null) {
            return null;
        }
        return ReflectUtil.getField(object.getClass(), string);
    }

    public static Field getField(Class<?> clazz, String string) {
        if (clazz == null) {
            return null;
        }
        if (StringUtil.isEmpty((String)string)) {
            return null;
        }
        return ClassInfoManager.getInstance().getClassInfo(clazz).getField(string);
    }

    public static Collection<Field> getFields(Object object) {
        return ClassInfoManager.getInstance().getClassInfo(object.getClass()).getFields();
    }

    public static Collection<Field> getFields(Class<?> clazz) {
        return ClassInfoManager.getInstance().getClassInfo(clazz).getFields();
    }

    public static boolean existConstructor(Class<?> clazz, Class<?> ... classArray) {
        return ClassInfoManager.getInstance().getClassInfo(clazz).existConstructor(classArray);
    }

    public static boolean existMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        return ClassInfoManager.getInstance().getClassInfo(clazz).existMethod(string, classArray);
    }

    public static boolean existField(Class<?> clazz, String string) {
        return ClassInfoManager.getInstance().getClassInfo(clazz).existField(string);
    }

    public static Class<?>[] getParameterTypes(Object ... objectArray) {
        if (objectArray == null) {
            return null;
        }
        Class[] classArray = new Class[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] != null) {
                classArray[n] = objectArray[n].getClass();
            }
            ++n;
        }
        return classArray;
    }

    public static Collection<Class<?>> getGenericParameterClasses(Object object) {
        return ReflectUtil.getGenericParameterClasses(object.getClass());
    }

    public static Collection<Class<?>> getGenericParameterClasses(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return ClassInfoManager.getInstance().getClassInfo(clazz).getGenericParameterTypes();
    }
}

