/*
 * Decompiled with CFR 0.152.
 */
package zimaoption.deck;

import option.zima.ZimaDepth;
import option.zima.ZimaWidth;
import zima.multispan.types.ZtBalcony;
import zima.multispan.types.ZtDepth;
import zimaoption.deck.ReinForce;

public class DeckKinoki3Size {
    public static float[] W11 = new float[]{75.0f, 80.0f, 85.0f, 90.0f};
    public static float[] W9 = new float[]{70.0f, 80.0f, 90.0f, 100.0f};
    private static final float[] W5 = new float[]{2680.0f, 3590.0f, 4500.0f};
    private static final double[][] PITCH_JOIST = new double[][]{{200.0, 785.0, 785.0, 430.0}, {200.0, 725.0, 725.0, 725.0, 325.0}, {200.0, 645.0, 455.0}};
    private static final double[][] PITCH_JOIST_3SYAKUEX = new double[][]{{200.0, 825.0, 825.0, 825.0, 725.0}, {200.0, 875.0, 600.0, 800.0, 800.0, 725.0}, {200.0, 675.0, 700.0, 700.0, 700.0, 425.0}, {200.0, 875.0, 900.0, 800.0, 800.0, 725.0}};
    private static final double[][] PITCH_JOIST_3SYAKUEX_KIKAKU = new double[][]{{200.0, 825.0, 825.0, 825.0, 725.0}, {200.0, 800.0, 800.0, 600.0, 875.0, 725.0}, {200.0, 700.0, 700.0, 700.0, 675.0, 425.0}, {200.0, 800.0, 800.0, 900.0, 875.0, 725.0}};
    private static final double[][] POSITION_TSUKA_15_06_STD = new double[][]{{-2040.0, -680.0, 680.0, 2040.0}, {-2040.0, -680.0, 680.0, 2040.0}, {-2040.0, -680.0, 680.0, 2040.0, -1345.5, 1345.5}, {-2040.0, -680.0, 680.0, 2040.0}};
    private static final double[][] POSITION_TSUKA_20_06_STD = new double[][]{{-2490.0, -1350.0, -10.0, 1240.0, 2490.0}, {-2490.0, -1350.0, -10.0, 1240.0, 2490.0}, {-2490.0, -1350.0, -10.0, 1240.0, 2490.0, -1800.5, 1800.5}, {-2490.0, -1350.0, -10.0, 1240.0, 2490.0}};
    private static final double[][] POSITION_TSUKA_25_06_STD = new double[][]{{-2940.0, -1350.0, 440.0, 1690.0, 2940.0}, {-2940.0, -1350.0, 440.0, 1690.0, 2940.0}, {-2940.0, -1350.0, 440.0, 1690.0, 2940.0, -2255.5, 2255.5}, {-2940.0, -1350.0, 440.0, 1690.0, 2940.0}};
    private static final double[][] POSITION_TSUKA_15_08_STD = new double[][]{{-2040.0, -680.0, 680.0, 2040.0}, {-2040.0, -680.0, 680.0, 2040.0}, {-2040.0, -680.0, 680.0, 2040.0}, {-2040.0, -680.0, 680.0, 2040.0, -1345.5, 1345.5}, {-2040.0, -680.0, 680.0, 2040.0}};
    private static final double[][] POSITION_TSUKA_20_08_STD = new double[][]{{-2490.0, -1350.0, -10.0, 1240.0, 2490.0}, {-2490.0, -1350.0, -10.0, 1240.0, 2490.0}, {-2490.0, -1350.0, -10.0, 1240.0, 2490.0}, {-2490.0, -1350.0, -10.0, 1240.0, 2490.0, -1800.5, 1800.5}, {-2490.0, -1350.0, -10.0, 1240.0, 2490.0}};
    private static final double[][] POSITION_TSUKA_25_08_STD = new double[][]{{-2940.0, -1350.0, 440.0, 1690.0, 2940.0}, {-2940.0, -1350.0, 440.0, 1690.0, 2940.0}, {-2940.0, -1350.0, 440.0, 1690.0, 2940.0}, {-2940.0, -1350.0, 440.0, 1690.0, 2940.0, -2255.5, 2255.5}, {-2940.0, -1350.0, 440.0, 1690.0, 2940.0}};
    private static final double[][] POSITION_TSUKA_15_06_L = new double[][]{{-1225.0, 365.0, 1950.0}, {-1225.0, 365.0, 1950.0}, {-1225.0, 365.0, 1950.0, 1345.5}, {-1225.0, 365.0, 1950.0}};
    private static final double[][] POSITION_TSUKA_20_06_L = new double[][]{{-1680.0, -320.0, 1040.0, 2400.0}, {-1680.0, -320.0, 1040.0, 2400.0}, {-1680.0, -320.0, 1040.0, 2400.0, 1800.5}, {-1680.0, -320.0, 1040.0, 2400.0}};
    private static final double[][] POSITION_TSUKA_25_06_L = new double[][]{{-2135.0, -995.0, 345.0, 1595.0, 2845.0}, {-2135.0, -995.0, 345.0, 1595.0, 2845.0}, {-2135.0, -995.0, 345.0, 1595.0, 2845.0, 2255.5}, {-2135.0, -995.0, 345.0, 1595.0, 2845.0}};
    private static final double[][] POSITION_TSUKA_15_08_L = new double[][]{{-1225.0, 365.0, 1950.0}, {-1225.0, 365.0, 1950.0}, {-1225.0, 365.0, 1950.0}, {-1225.0, 365.0, 1950.0, 1345.5}, {-1225.0, 365.0, 1950.0}};
    private static final double[][] POSITION_TSUKA_20_08_L = new double[][]{{-1680.0, -320.0, 1040.0, 2400.0}, {-1680.0, -320.0, 1040.0, 2400.0}, {-1680.0, -320.0, 1040.0, 2400.0}, {-1680.0, -320.0, 1040.0, 2400.0, 1800.5}, {-1680.0, -320.0, 1040.0, 2400.0}};
    private static final double[][] POSITION_TSUKA_25_08_L = new double[][]{{-2135.0, -995.0, 345.0, 1595.0, 2845.0}, {-2135.0, -995.0, 345.0, 1595.0, 2845.0}, {-2135.0, -995.0, 345.0, 1595.0, 2845.0}, {-2135.0, -995.0, 345.0, 1595.0, 2845.0, 2255.5}, {-2135.0, -995.0, 345.0, 1595.0, 2845.0}};
    private static final double[][] POSITION_TSUKA_15_06_R = new double[][]{{-1950.0, -360.0, 1225.0}, {-1950.0, -360.0, 1225.0}, {-1950.0, -360.0, 1225.0, -1345.5}, {-1950.0, -360.0, 1225.0}};
    private static final double[][] POSITION_TSUKA_20_06_R = new double[][]{{-2400.0, -1040.0, 320.0, 1680.0}, {-2400.0, -1040.0, 320.0, 1680.0}, {-2400.0, -1040.0, 320.0, 1680.0, -1800.5}, {-2400.0, -1040.0, 320.0, 1680.0}};
    private static final double[][] POSITION_TSUKA_25_06_R = new double[][]{{-2845.0, -1705.0, -365.0, 885.0, 2135.0}, {-2845.0, -1705.0, -365.0, 885.0, 2135.0}, {-2845.0, -1705.0, -365.0, 885.0, 2135.0, -2255.5}, {-2845.0, -1705.0, -365.0, 885.0, 2135.0}};
    private static final double[][] POSITION_TSUKA_15_08_R = new double[][]{{-1950.0, -360.0, 1225.0}, {-1950.0, -360.0, 1225.0}, {-1950.0, -360.0, 1225.0}, {-1950.0, -360.0, 1225.0, -1345.5}, {-1950.0, -360.0, 1225.0}};
    private static final double[][] POSITION_TSUKA_20_08_R = new double[][]{{-2400.0, -1040.0, 320.0, 1680.0}, {-2400.0, -1040.0, 320.0, 1680.0}, {-2400.0, -1040.0, 320.0, 1680.0}, {-2400.0, -1040.0, 320.0, 1680.0, -1800.5}, {-2400.0, -1040.0, 320.0, 1680.0}};
    private static final double[][] POSITION_TSUKA_25_08_R = new double[][]{{-2845.0, -1705.0, -365.0, 885.0, 2135.0}, {-2845.0, -1705.0, -365.0, 885.0, 2135.0}, {-2845.0, -1705.0, -365.0, 885.0, 2135.0}, {-2845.0, -1705.0, -365.0, 885.0, 2135.0, -2255.5}, {-2845.0, -1705.0, -365.0, 885.0, 2135.0}};
    private static double[][][] TSUKA_STD = new double[][][]{POSITION_TSUKA_15_06_STD, POSITION_TSUKA_20_06_STD, POSITION_TSUKA_25_06_STD, POSITION_TSUKA_15_08_STD, POSITION_TSUKA_20_08_STD, POSITION_TSUKA_25_08_STD};
    private static double[][][] TSUKA_L = new double[][][]{POSITION_TSUKA_15_06_L, POSITION_TSUKA_20_06_L, POSITION_TSUKA_25_06_L, POSITION_TSUKA_15_08_L, POSITION_TSUKA_20_08_L, POSITION_TSUKA_25_08_L};
    private static double[][][] TSUKA_R = new double[][][]{POSITION_TSUKA_15_06_R, POSITION_TSUKA_20_06_R, POSITION_TSUKA_25_06_R, POSITION_TSUKA_15_08_R, POSITION_TSUKA_20_08_R, POSITION_TSUKA_25_08_R};
    private static final double[][] RF_F_15_06_R = new double[][]{{-1340.0, -200.0, -1340.0, -985.0}, {-1340.0, -985.0, -1340.0, -1770.0}, {1345.0, -985.0, 1345.0, -1770.0}, {-1352.5, -1770.0, -1352.5, -2200.0}, {1337.5, -1770.0, 1337.5, -2200.0}};
    private static final double[][] RF_F_15_06_L = new double[][]{{1340.0, -200.0, 1340.0, -985.0}, {1340.0, -985.0, 1340.0, -1770.0}, {-1345.0, -985.0, -1345.0, -1770.0}, {1352.5, -1770.0, 1352.5, -2200.0}, {-1337.5, -1770.0, -1337.5, -2200.0}};
    private static final double[][] RF_F_15_06_S = new double[][]{{-1340.0, -200.0, -1340.0, -985.0}, {-1340.0, -985.0, -1340.0, -1770.0}, {1340.0, -200.0, 1340.0, -985.0}, {1340.0, -985.0, 1340.0, -1770.0}, {-1352.5, -1770.0, -1352.5, -2200.0}, {1352.5, -1770.0, 1352.5, -2200.0}};
    private static final double[][] RF_F_15_08_R = new double[][]{{-1340.0, -200.0, -1340.0, -925.0}, {-1340.0, -925.0, -1340.0, -1650.0}, {-1340.0, -1650.0, -1340.0, -2375.0}, {1345.0, -1650.0, 1345.0, -2375.0}, {-1357.86, -2375.0, -1357.86, -2700.0}, {1337.5, -2375.0, 1337.5, -2700.0}};
    private static final double[][] RF_F_15_08_L = new double[][]{{1340.0, -200.0, 1340.0, -925.0}, {1340.0, -925.0, 1340.0, -1650.0}, {1340.0, -1650.0, 1340.0, -2375.0}, {-1345.0, -1650.0, -1345.0, -2375.0}, {1357.8599, -2375.0, 1357.8599, -2700.0}, {-1337.5, -2375.0, -1337.5, -2700.0}};
    private static final double[][] RF_F_15_08_S = new double[][]{{-1340.0, -200.0, -1340.0, -925.0}, {-1340.0, -925.0, -1340.0, -1650.0}, {-1340.0, -1650.0, -1340.0, -2375.0}, {1340.0, -200.0, 1340.0, -925.0}, {1340.0, -925.0, 1340.0, -1650.0}, {1340.0, -1650.0, 1340.0, -2375.0}, {-1353.0, -2375.0, -1353.0, -2700.0}, {1353.0, -2375.0, 1353.0, -2700.0}};
    private static final double[][] RF_F_20_06_R = new double[][]{{-1795.0, -200.0, -1795.0, -985.0}, {-1795.0, -985.0, -1795.0, -1770.0}, {1800.0, -985.0, 1800.0, -1770.0}, {-1807.5, -1770.0, -1807.5, -2200.0}, {1792.5, -1770.0, 1792.5, -2200.0}};
    private static final double[][] RF_F_20_06_L = new double[][]{{1795.0, -200.0, 1795.0, -985.0}, {1795.0, -985.0, 1795.0, -1770.0}, {-1800.0, -985.0, -1800.0, -1770.0}, {1807.5, -1770.0, 1807.5, -2200.0}, {-1792.5, -1770.0, -1792.5, -2200.0}};
    private static final double[][] RF_F_20_06_S = new double[][]{{-1795.0, -200.0, -1795.0, -985.0}, {-1795.0, -985.0, -1795.0, -1770.0}, {1795.0, -200.0, 1795.0, -985.0}, {1795.0, -985.0, 1795.0, -1770.0}, {-1807.5, -1770.0, -1807.5, -2200.0}, {1807.5, -1770.0, 1807.5, -2200.0}};
    private static final double[][] RF_F_20_08_R = new double[][]{{-1795.0, -200.0, -1795.0, -925.0}, {-1795.0, -925.0, -1795.0, -1650.0}, {-1795.0, -1650.0, -1795.0, -2375.0}, {1800.0, -1650.0, 1800.0, -2375.0}, {-1808.0, -2375.0, -1808.0, -2700.0}, {1792.5, -2375.0, 1792.5, -2700.0}};
    private static final double[][] RF_F_20_08_L = new double[][]{{1795.0, -200.0, 1795.0, -925.0}, {1795.0, -925.0, 1795.0, -1650.0}, {1795.0, -1650.0, 1795.0, -2375.0}, {-1800.0, -1650.0, -1800.0, -2375.0}, {1808.0, -2375.0, 1808.0, -2700.0}, {-1792.5, -2375.0, -1792.5, -2700.0}};
    private static final double[][] RF_F_20_08_S = new double[][]{{-1795.0, -200.0, -1795.0, -925.0}, {-1795.0, -925.0, -1795.0, -1650.0}, {-1795.0, -1650.0, -1795.0, -2375.0}, {1795.0, -200.0, 1795.0, -925.0}, {1795.0, -925.0, 1795.0, -1650.0}, {1795.0, -1650.0, 1795.0, -2375.0}, {-1808.0, -2375.0, -1808.0, -2700.0}, {1808.0, -2375.0, 1808.0, -2700.0}};
    private static final double[][] RF_F_25_06_R = new double[][]{{-2250.0, -200.0, -2250.0, -985.0}, {-2250.0, -985.0, -2250.0, -1770.0}, {2255.0, -985.0, 2255.0, -1770.0}, {-2262.5, -1770.0, -2262.5, -2200.0}, {2247.5, -1770.0, 2247.5, -2200.0}};
    private static final double[][] RF_F_25_06_L = new double[][]{{2250.0, -200.0, 2250.0, -985.0}, {2250.0, -985.0, 2250.0, -1770.0}, {-2255.0, -985.0, -2255.0, -1770.0}, {2262.5, -1770.0, 2262.5, -2200.0}, {-2247.5, -1770.0, -2247.5, -2200.0}};
    private static final double[][] RF_F_25_06_S = new double[][]{{-2250.0, -200.0, -2250.0, -985.0}, {-2250.0, -985.0, -2250.0, -1770.0}, {2250.0, -200.0, 2250.0, -985.0}, {2250.0, -985.0, 2250.0, -1770.0}, {-2262.5, -1770.0, -2262.5, -2200.0}, {2262.5, -1770.0, 2262.5, -2200.0}};
    private static final double[][] RF_F_25_08_R = new double[][]{{-2250.0, -200.0, -2250.0, -925.0}, {-2250.0, -925.0, -2250.0, -1650.0}, {-2250.0, -1650.0, -2250.0, -2375.0}, {2255.0, -1650.0, 2255.0, -2375.0}, {-2263.0, -2375.0, -2263.0, -2700.0}, {2247.5, -2375.0, 2247.5, -2700.0}};
    private static final double[][] RF_F_25_08_L = new double[][]{{2250.0, -200.0, 2250.0, -925.0}, {2250.0, -925.0, 2250.0, -1650.0}, {2250.0, -1650.0, 2250.0, -2375.0}, {-2255.0, -1650.0, -2255.0, -2375.0}, {2263.0, -2375.0, 2263.0, -2700.0}, {-2247.5, -2375.0, -2247.5, -2700.0}};
    private static final double[][] RF_F_25_08_S = new double[][]{{-2250.0, -200.0, -2250.0, -925.0}, {-2250.0, -925.0, -2250.0, -1650.0}, {-2250.0, -1650.0, -2250.0, -2375.0}, {2250.0, -200.0, 2250.0, -925.0}, {2250.0, -925.0, 2250.0, -1650.0}, {2250.0, -1650.0, 2250.0, -2375.0}, {-2263.36, -2375.0, -2263.36, -2700.0}, {2262.44, -2375.0, 2262.44, -2700.0}};
    private static final double[][] RF_N_15_06_R = new double[][]{{-1340.0, -200.0, -1340.0, -985.0}, {-1340.0, -985.0, -1340.0, -1770.0}, {-803.0, -985.0, -803.0, -1770.0}, {-266.0, -985.0, -266.0, -1770.0}, {1345.0, -985.0, 1345.0, -1770.0}, {808.0, -985.0, 808.0, -1770.0}, {271.0, -985.0, 271.0, -1770.0}, {-1352.5, -1770.0, -1352.5, -2200.0}, {1337.5, -1770.0, 1337.5, -2200.0}};
    private static final double[][] RF_N_15_06_L = new double[][]{{1340.0, -200.0, 1340.0, -985.0}, {1340.0, -985.0, 1340.0, -1770.0}, {803.0, -985.0, 803.0, -1770.0}, {266.0, -985.0, 266.0, -1770.0}, {-1345.0, -985.0, -1345.0, -1770.0}, {-808.0, -985.0, -808.0, -1770.0}, {-271.0, -985.0, -271.0, -1770.0}, {1352.5, -1770.0, 1352.5, -2200.0}, {-1337.5, -1770.0, -1337.5, -2200.0}};
    private static final double[][] RF_N_15_06_S = new double[][]{{-1340.0, -200.0, -1340.0, -985.0}, {-1340.0, -985.0, -1340.0, -1770.0}, {-804.0, -985.0, -804.0, -1770.0}, {-268.0, -985.0, -268.0, -1770.0}, {1340.0, -200.0, 1340.0, -985.0}, {1340.0, -985.0, 1340.0, -1770.0}, {804.0, -985.0, 804.0, -1770.0}, {268.0, -985.0, 268.0, -1770.0}, {-1352.5, -1770.0, -1352.5, -2200.0}, {1352.5, -1770.0, 1352.5, -2200.0}};
    private static final double[][] RF_N_15_08_R = new double[][]{{-1340.0, -200.0, -1340.0, -925.0}, {-1340.0, -925.0, -1340.0, -1650.0}, {-1340.0, -1650.0, -1340.0, -2375.0}, {-803.0, -1650.0, -803.0, -2375.0}, {-266.0, -1650.0, -266.0, -2375.0}, {1345.0, -1650.0, 1345.0, -2375.0}, {808.0, -1650.0, 808.0, -2375.0}, {271.0, -1650.0, 271.0, -2375.0}, {-1357.86, -2375.0, -1357.86, -2700.0}, {1337.5, -2375.0, 1337.5, -2700.0}};
    private static final double[][] RF_N_15_08_L = new double[][]{{1340.0, -200.0, 1340.0, -925.0}, {1340.0, -925.0, 1340.0, -1650.0}, {1340.0, -1650.0, 1340.0, -2375.0}, {803.0, -1650.0, 803.0, -2375.0}, {266.0, -1650.0, 266.0, -2375.0}, {-1345.0, -1650.0, -1345.0, -2375.0}, {-808.0, -1650.0, -808.0, -2375.0}, {-271.0, -1650.0, -271.0, -2375.0}, {1357.86, -2375.0, 1357.86, -2700.0}, {-1337.5, -2375.0, -1337.5, -2700.0}};
    private static final double[][] RF_N_15_08_S = new double[][]{{-1340.0, -200.0, -1340.0, -925.0}, {-1340.0, -925.0, -1340.0, -1650.0}, {-1340.0, -1650.0, -1340.0, -2375.0}, {-804.0, -1650.0, -804.0, -2375.0}, {-268.0, -1650.0, -268.0, -2375.0}, {1340.0, -200.0, 1340.0, -925.0}, {1340.0, -925.0, 1340.0, -1650.0}, {1340.0, -1650.0, 1340.0, -2375.0}, {804.0, -1650.0, 804.0, -2375.0}, {268.0, -1650.0, 268.0, -2375.0}, {-1353.0, -2375.0, -1353.0, -2700.0}, {1353.0, -2375.0, 1353.0, -2700.0}};
    private static final double[][] RF_N_20_06_R = new double[][]{{-1795.0, -200.0, -1795.0, -985.0}, {-1795.0, -985.0, -1795.0, -1770.0}, {-1189.88, -985.0, -1189.88, -1770.0}, {-590.72, -985.0, -590.72, -1770.0}, {8.449951, -985.0, 8.449951, -1770.0}, {1800.0, -985.0, 1800.0, -1770.0}, {1206.78, -985.0, 1206.78, -1770.0}, {607.62, -985.0, 607.62, -1770.0}, {-1807.5, -1770.0, -1807.5, -2200.0}, {1792.5, -1770.0, 1792.5, -2200.0}};
    private static final double[][] RF_N_20_06_L = new double[][]{{1795.0, -200.0, 1795.0, -985.0}, {1795.0, -985.0, 1795.0, -1770.0}, {1189.88, -985.0, 1189.88, -1770.0}, {590.72, -985.0, 590.72, -1770.0}, {-8.450012, -985.0, -8.450012, -1770.0}, {-1800.0, -985.0, -1800.0, -1770.0}, {-1206.78, -985.0, -1206.78, -1770.0}, {-607.62, -985.0, -607.62, -1770.0}, {1807.5, -1770.0, 1807.5, -2200.0}, {-1792.5, -1770.0, -1792.5, -2200.0}};
    private static final double[][] RF_N_20_06_S = new double[][]{{-1795.0, -200.0, -1795.0, -985.0}, {-1795.0, -985.0, -1795.0, -1770.0}, {-1196.67, -985.0, -1196.67, -1770.0}, {-598.33, -985.0, -598.33, -1770.0}, {0.0, -985.0, 0.0, -1770.0}, {1795.0, -200.0, 1795.0, -985.0}, {1795.0, -985.0, 1795.0, -1770.0}, {1196.6699, -985.0, 1196.6699, -1770.0}, {598.3301, -985.0, 598.3301, -1770.0}, {-1807.5, -1770.0, -1807.5, -2200.0}, {1807.5, -1770.0, 1807.5, -2200.0}};
    private static final double[][] RF_N_20_08_R = new double[][]{{-1795.0, -200.0, -1795.0, -925.0}, {-1795.0, -925.0, -1795.0, -1650.0}, {-1795.0, -1650.0, -1795.0, -2375.0}, {-1195.83, -1650.0, -1195.83, -2375.0}, {-596.67, -1650.0, -596.67, -2375.0}, {2.5, -1650.0, 2.5, -2375.0}, {1800.0, -1650.0, 1800.0, -2375.0}, {1200.8301, -1650.0, 1200.8301, -2375.0}, {601.6699, -1650.0, 601.6699, -2375.0}, {-1808.0, -2375.0, -1808.0, -2700.0}, {1792.5, -2375.0, 1792.5, -2700.0}};
    private static final double[][] RF_N_20_08_L = new double[][]{{1795.0, -200.0, 1795.0, -925.0}, {1795.0, -925.0, 1795.0, -1650.0}, {1795.0, -1650.0, 1795.0, -2375.0}, {1195.83, -1650.0, 1195.83, -2375.0}, {596.6699, -1650.0, 596.6699, -2375.0}, {-2.5, -1650.0, -2.5, -2375.0}, {-1800.0, -1650.0, -1800.0, -2375.0}, {-1200.83, -1650.0, -1200.83, -2375.0}, {-601.67, -1650.0, -601.67, -2375.0}, {1808.0, -2375.0, 1808.0, -2700.0}, {-1792.5, -2375.0, -1792.5, -2700.0}};
    private static final double[][] RF_N_20_08_S = new double[][]{{-1795.0, -200.0, -1795.0, -925.0}, {-1795.0, -925.0, -1795.0, -1650.0}, {-1795.0, -1650.0, -1795.0, -2375.0}, {-1196.67, -1650.0, -1196.67, -2375.0}, {-598.33, -1650.0, -598.33, -2375.0}, {0.0, -1650.0, 0.0, -2375.0}, {1795.0, -200.0, 1795.0, -925.0}, {1795.0, -925.0, 1795.0, -1650.0}, {1795.0, -1650.0, 1795.0, -2375.0}, {1196.6699, -1650.0, 1196.6699, -2375.0}, {598.3301, -1650.0, 598.3301, -2375.0}, {-1808.0, -2375.0, -1808.0, -2700.0}, {1808.0, -2375.0, 1808.0, -2700.0}};
    private static final double[][] RF_N_25_06_R = new double[][]{{-2250.0, -200.0, -2250.0, -985.0}, {-2250.0, -985.0, -2250.0, -1770.0}, {-1686.87, -985.0, -1686.87, -1770.0}, {-1123.75, -985.0, -1123.75, -1770.0}, {-560.62, -985.0, -560.62, -1770.0}, {2.5, -985.0, 2.5, -1770.0}, {2255.0, -985.0, 2255.0, -1770.0}, {1691.8799, -985.0, 1691.8799, -1770.0}, {1128.75, -985.0, 1128.75, -1770.0}, {565.6299, -985.0, 565.6299, -1770.0}, {-2262.5, -1770.0, -2262.5, -2200.0}, {2247.5, -1770.0, 2247.5, -2200.0}};
    private static final double[][] RF_N_25_06_L = new double[][]{{2250.0, -200.0, 2250.0, -985.0}, {2250.0, -985.0, 2250.0, -1770.0}, {1686.8701, -985.0, 1686.8701, -1770.0}, {1123.75, -985.0, 1123.75, -1770.0}, {560.62, -985.0, 560.62, -1770.0}, {-2.5, -985.0, -2.5, -1770.0}, {-2255.0, -985.0, -2255.0, -1770.0}, {-1691.88, -985.0, -1691.88, -1770.0}, {-1128.75, -985.0, -1128.75, -1770.0}, {-565.63, -985.0, -565.63, -1770.0}, {2262.5, -1770.0, 2262.5, -2200.0}, {-2247.5, -1770.0, -2247.5, -2200.0}};
    private static final double[][] RF_N_25_06_S = new double[][]{{-2250.0, -200.0, -2250.0, -985.0}, {-2250.0, -985.0, -2250.0, -1770.0}, {-1687.5, -985.0, -1687.5, -1770.0}, {-1125.0, -985.0, -1125.0, -1770.0}, {-562.5, -985.0, -562.5, -1770.0}, {0.0, -985.0, 0.0, -1770.0}, {2250.0, -200.0, 2250.0, -985.0}, {2250.0, -985.0, 2250.0, -1770.0}, {1687.5, -985.0, 1687.5, -1770.0}, {1125.0, -985.0, 1125.0, -1770.0}, {562.5, -985.0, 562.5, -1770.0}, {-2262.5, -1770.0, -2262.5, -2200.0}, {2262.5, -1770.0, 2262.5, -2200.0}};
    private static final double[][] RF_N_25_08_R = new double[][]{{-2250.0, -200.0, -2250.0, -925.0}, {-2250.0, -925.0, -2250.0, -1650.0}, {-2250.0, -1650.0, -2250.0, -2375.0}, {-1686.88, -1650.0, -1686.88, -2375.0}, {-1123.75, -1650.0, -1123.75, -2375.0}, {-560.63, -1650.0, -560.63, -2375.0}, {2.5, -1650.0, 2.5, -2375.0}, {2255.0, -1650.0, 2255.0, -2375.0}, {1691.8701, -1650.0, 1691.8701, -2375.0}, {1128.75, -1650.0, 1128.75, -2375.0}, {565.6201, -1650.0, 565.6201, -2375.0}, {-2263.0, -2375.0, -2263.0, -2700.0}, {2247.5, -2375.0, 2247.5, -2700.0}};
    private static final double[][] RF_N_25_08_L = new double[][]{{2250.0, -200.0, 2250.0, -925.0}, {2250.0, -925.0, 2250.0, -1650.0}, {2250.0, -1650.0, 2250.0, -2375.0}, {1686.8799, -1650.0, 1686.8799, -2375.0}, {1123.75, -1650.0, 1123.75, -2375.0}, {560.63, -1650.0, 560.63, -2375.0}, {-2.5, -1650.0, -2.5, -2375.0}, {-2255.0, -1650.0, -2255.0, -2375.0}, {-1691.87, -1650.0, -1691.87, -2375.0}, {-1128.75, -1650.0, -1128.75, -2375.0}, {-565.62, -1650.0, -565.62, -2375.0}, {2263.0, -2375.0, 2263.0, -2700.0}, {-2247.5, -2375.0, -2247.5, -2700.0}};
    private static final double[][] RF_N_25_08_S = new double[][]{{-2250.0, -200.0, -2250.0, -925.0}, {-2250.0, -925.0, -2250.0, -1650.0}, {-2250.0, -1650.0, -2250.0, -2375.0}, {-1687.5, -1650.0, -1687.5, -2375.0}, {-1125.0, -1650.0, -1125.0, -2375.0}, {-562.5, -1650.0, -562.5, -2375.0}, {0.0, -1650.0, 0.0, -2375.0}, {2250.0, -200.0, 2250.0, -925.0}, {2250.0, -925.0, 2250.0, -1650.0}, {2250.0, -1650.0, 2250.0, -2375.0}, {1687.5, -1650.0, 1687.5, -2375.0}, {1125.0, -1650.0, 1125.0, -2375.0}, {562.5, -1650.0, 562.5, -2375.0}, {-2263.36, -2375.0, -2263.36, -2700.0}, {2262.44, -2375.0, 2262.44, -2700.0}};
    private static ReinForce[] reinforce;

    public static float getDepth(int n) {
        if (n == 0) {
            return 2400.0f;
        }
        if (n == 3) {
            return 2900.0f;
        }
        return 2900.0f;
    }

    public static float getMaguchi(int n, int n2) {
        switch (n2) {
            case 0: {
                switch (n) {
                    case 0: {
                        return 4495.0f;
                    }
                    case 1: {
                        return 5395.0f;
                    }
                    case 2: {
                        return 6295.0f;
                    }
                }
                return 6295.0f;
            }
            case 1: 
            case 2: {
                switch (n) {
                    case 0: {
                        return 3595.0f;
                    }
                    case 1: {
                        return 4495.0f;
                    }
                    case 2: {
                        return 5395.0f;
                    }
                }
                return 5395.0f;
            }
        }
        return 6295.0f;
    }

    private static final float getW5(int n) {
        switch (n) {
            case 0: {
                return W5[0];
            }
            case 1: {
                return W5[1];
            }
            case 2: {
                return W5[2];
            }
        }
        return W5[2];
    }

    public static final float getMinX(int n, int n2) {
        float f = DeckKinoki3Size.getMaguchi(n, n2);
        if (n2 == 0) {
            return -f / 2.0f;
        }
        if (n2 == 1) {
            float f2 = -ZimaWidth.getWidth(n) / 2.0f - 125.0f;
            return f2;
        }
        if (n2 == 2) {
            float f3 = ZimaWidth.getWidth(n) / 2.0f + 125.0f - f;
            if (n == 0) {
                f3 += 5.0f;
            }
            return f3;
        }
        return -f / 2.0f;
    }

    public static final float getMaxX(int n, int n2) {
        float f = DeckKinoki3Size.getMaguchi(n, n2);
        if (n2 == 0) {
            return f / 2.0f;
        }
        if (n2 == 0) {
            return f / 2.0f;
        }
        if (n2 == 1) {
            float f2 = -ZimaWidth.getWidth(n) / 2.0f - 125.0f + f;
            if (n == 0) {
                f2 -= 5.0f;
            }
            return f2;
        }
        if (n2 == 2) {
            float f3 = ZimaWidth.getWidth(n) / 2.0f + 125.0f;
            return f3;
        }
        return f / 2.0f;
    }

    public static double[] getOobikiPitch(int n, float f) {
        double[] dArray = null;
        if (n == 6) {
            dArray = PITCH_JOIST[2];
        } else if (n == 0) {
            dArray = PITCH_JOIST[0];
        } else if (n == 3) {
            dArray = PITCH_JOIST[1];
        }
        if (dArray == null || f == 0.0f) {
            return dArray;
        }
        double d = 0.0;
        int n2 = 0;
        while (n2 < dArray.length - 1) {
            d += dArray[n2];
            ++n2;
        }
        double d2 = (d -= (double)f) - 200.0;
        double[] dArray2 = DeckKinoki3Size.getDivide(d2, 900.0);
        double[] dArray3 = new double[dArray2.length + 2];
        dArray3[0] = 200.0;
        dArray3[dArray3.length - 1] = dArray[dArray.length - 1];
        int n3 = 0;
        while (n3 < dArray2.length) {
            dArray3[n3 + 1] = dArray2[n3];
            ++n3;
        }
        return dArray3;
    }

    public static double[] getOobikiPitch(ZtBalcony ztBalcony, ZtDepth ztDepth, float f) {
        double[][] dArray = PITCH_JOIST_3SYAKUEX_KIKAKU;
        double[] dArray2 = null;
        double d = 0.0;
        if (ztBalcony == ZtBalcony.NONE || ztBalcony == ZtBalcony.UNDER) {
            d = 900.0f - f;
        } else if (ztBalcony == ZtBalcony.FORE) {
            d = 1200.0f - f;
        }
        if (ztBalcony == ZtBalcony.NONE || ztBalcony == ZtBalcony.UNDER) {
            if (ztDepth == ZtDepth.D_6) {
                dArray2 = dArray[0];
            } else if (ztDepth == ZtDepth.D_8) {
                dArray2 = dArray[1];
            }
        } else if (ztBalcony == ZtBalcony.FORE) {
            if (ztDepth == ZtDepth.D_6) {
                dArray2 = dArray[2];
            } else if (ztDepth == ZtDepth.D_8) {
                dArray2 = dArray[3];
            }
        }
        if (dArray2 == null || d == 0.0) {
            return dArray2;
        }
        double d2 = 0.0;
        int n = 0;
        while (n < dArray2.length - 1) {
            d2 += dArray2[n];
            ++n;
        }
        double d3 = (d2 -= d) - 200.0;
        double[] dArray3 = DeckKinoki3Size.getDivide(d3, 900.0);
        double[] dArray4 = new double[dArray3.length + 2];
        dArray4[0] = 200.0;
        dArray4[dArray4.length - 1] = dArray2[dArray2.length - 1];
        int n2 = 0;
        while (n2 < dArray3.length) {
            dArray4[n2 + 1] = dArray3[n2];
            ++n2;
        }
        return dArray4;
    }

    private static double[] getDivide(double d, double d2) {
        if (d <= d2) {
            return new double[]{d};
        }
        double d3 = Math.floor(d);
        double d4 = d - d3;
        int n = (int)Math.ceil(d / d2);
        double[] dArray = new double[n];
        int n2 = (int)(d3 % (double)n);
        double d5 = Math.floor(d3 / (double)n);
        int n3 = 0;
        while (n3 < dArray.length) {
            dArray[n3] = d5;
            ++n3;
        }
        if (n2 > 0) {
            n3 = 0;
            while (n3 < n2) {
                int n4 = dArray.length - 1 - n3;
                dArray[n4] = dArray[n4] + 1.0;
                ++n3;
            }
        }
        if (d4 != 0.0) {
            int n5 = dArray.length - 1 - n2;
            dArray[n5] = dArray[n5] + d4;
        }
        return dArray;
    }

    public static double[][] getTsukaBashira(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n7 < ZimaWidth.VALUES_FULL.length) {
            if (ZimaWidth.VALUES_FULL[n7] == n) {
                n5 = n7;
                break;
            }
            ++n7;
        }
        n7 = 0;
        while (n7 < ZimaDepth.avail.length) {
            if (ZimaDepth.avail[n7] == n2) {
                n6 = n7;
                break;
            }
            ++n7;
        }
        n4 = n5 + n6 * 3;
        if (n3 == 0) {
            return TSUKA_STD[n4];
        }
        if (n3 == 1) {
            return TSUKA_L[n4];
        }
        if (n3 == 2) {
            return TSUKA_R[n4];
        }
        return null;
    }

    private static void createReinforce() {
        reinforce = new ReinForce[]{new ReinForce(0, 0, 0, 1, RF_F_15_06_S), new ReinForce(1, 0, 0, 1, RF_F_20_06_S), new ReinForce(2, 0, 0, 1, RF_F_25_06_S), new ReinForce(0, 3, 0, 1, RF_F_15_08_S), new ReinForce(1, 3, 0, 1, RF_F_20_08_S), new ReinForce(2, 3, 0, 1, RF_F_25_08_S), new ReinForce(0, 0, 1, 1, RF_F_15_06_L), new ReinForce(1, 0, 1, 1, RF_F_20_06_L), new ReinForce(2, 0, 1, 1, RF_F_25_06_L), new ReinForce(0, 3, 1, 1, RF_F_15_08_L), new ReinForce(1, 3, 1, 1, RF_F_20_08_L), new ReinForce(2, 3, 1, 1, RF_F_25_08_L), new ReinForce(0, 0, 2, 1, RF_F_15_06_R), new ReinForce(1, 0, 2, 1, RF_F_20_06_R), new ReinForce(2, 0, 2, 1, RF_F_25_06_R), new ReinForce(0, 3, 2, 1, RF_F_15_08_R), new ReinForce(1, 3, 2, 1, RF_F_20_08_R), new ReinForce(2, 3, 2, 1, RF_F_25_08_R), new ReinForce(0, 0, 0, 0, RF_N_15_06_S), new ReinForce(1, 0, 0, 0, RF_N_20_06_S), new ReinForce(2, 0, 0, 0, RF_N_25_06_S), new ReinForce(0, 3, 0, 0, RF_N_15_08_S), new ReinForce(1, 3, 0, 0, RF_N_20_08_S), new ReinForce(2, 3, 0, 0, RF_N_25_08_S), new ReinForce(0, 0, 1, 0, RF_N_15_06_L), new ReinForce(1, 0, 1, 0, RF_N_20_06_L), new ReinForce(2, 0, 1, 0, RF_N_25_06_L), new ReinForce(0, 3, 1, 0, RF_N_15_08_L), new ReinForce(1, 3, 1, 0, RF_N_20_08_L), new ReinForce(2, 3, 1, 0, RF_N_25_08_L), new ReinForce(0, 0, 2, 0, RF_N_15_06_R), new ReinForce(1, 0, 2, 0, RF_N_20_06_R), new ReinForce(2, 0, 2, 0, RF_N_25_06_R), new ReinForce(0, 3, 2, 0, RF_N_15_08_R), new ReinForce(1, 3, 2, 0, RF_N_20_08_R), new ReinForce(2, 3, 2, 0, RF_N_25_08_R)};
    }

    public static final double[][] getRF(int n, int n2, int n3, int n4) {
        if (reinforce == null) {
            DeckKinoki3Size.createReinforce();
        }
        int n5 = 0;
        while (n5 < reinforce.length) {
            if (reinforce[n5].equals(n, n2, n3, n4)) {
                return reinforce[n5].getLines();
            }
            ++n5;
        }
        return reinforce[0].getLines();
    }

    public static float getNaimenWidth(int n, int n2) {
        if (n2 == 0) {
            if (n == 0) {
                return 2345.0f;
            }
            if (n == 1) {
                return 3245.0f;
            }
            if (n == 2) {
                return 4145.0f;
            }
        } else {
            if (n == 0) {
                return 2695.0f;
            }
            if (n == 1) {
                return 3600.0f;
            }
            if (n == 2) {
                return 4500.0f;
            }
        }
        return 2345.0f;
    }

    public static float getNaimenDepth(int n) {
        if (n == 0) {
            return 1665.0f;
        }
        if (n == 3) {
            return 2265.0f;
        }
        return 1665.0f;
    }

    public static final float getW11(int n) {
        int n2 = 0;
        while (n2 < ZimaWidth.VALUES_FULL.length) {
            if (ZimaWidth.VALUES_FULL[n2] == n) {
                return W11[n2];
            }
            ++n2;
        }
        return W11[0];
    }

    public static final float getW9(int n) {
        int n2 = 0;
        while (n2 < ZimaWidth.VALUES_FULL.length) {
            if (ZimaWidth.VALUES_FULL[n2] == n) {
                return W9[n2];
            }
            ++n2;
        }
        return W9[0];
    }

    public static final float getPlate() {
        return 175.0f;
    }

    public static final float getMeji() {
        return 5.0f;
    }
}

