/*
 * Decompiled with CFR 0.152.
 */
package zima.multispan.types;

import zima.multispan.types.ZtDepth;

public enum ZtHeight {
    H_2100(2100.0f, 0),
    H_2300(2300.0f, 1),
    H_2500(2500.0f, 2),
    H_3300(3215.0f, 3),
    H_3080(2995.0f, -1);

    private float value;
    private int legCode = 0;

    private ZtHeight(float f, int n2) {
        this.value = f;
        this.legCode = n2;
    }

    public float getH() {
        return this.value;
    }

    public float getH2(float f) {
        double d = (double)f - 52.2;
        double d2 = d * Math.tan(Math.toRadians(5.0));
        d2 += 86.5;
        d2 += 3.5;
        d2 += 134.99;
        return (float)(d2 -= 1.0);
    }

    public float getH3(float f) {
        double d = (double)f - 52.2;
        double d2 = d * Math.tan(Math.toRadians(5.0));
        d2 -= 134.99;
        d2 += 13.55;
        d2 += 134.99;
        return (float)(d2 -= 0.9);
    }

    public float getDefaultHeight(ZtDepth ztDepth) {
        return this.value + ztDepth.getD1();
    }

    public int getLegCode() {
        return this.legCode;
    }
}

