/*
 * Decompiled with CFR 0.152.
 */
package zima.multispan;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import model.item.Item;
import model.shape.primitive.TransForm2f;
import option.zima.ZimaColor;
import option.zima.ZimaPanelColor;
import zima.multispan.AbstractTerraceUnit;
import zima.multispan.RailProperty;
import zima.multispan.types.ZtBalcony;
import zima.multispan.types.ZtDeckOsamari;
import zima.multispan.types.ZtDeckType;
import zima.multispan.types.ZtDepth;
import zima.multispan.types.ZtHeight;
import zima.multispan.types.ZtOsamari;
import zima.multispan.types.ZtPanel;
import zima.multispan.types.ZtPanelState;
import zima.multispan.types.ZtPillarType;

public class MultiSpanTerrace
extends Item
implements Serializable {
    private static final int INDEX_GROUP_PILLAR = 0;
    private static final int INDEX_GROUP_KETA = 1;
    private static final int INDEX_GROUP_OTHER = 2;
    private static final int INDEX_GROUP_PANEL = 3;
    private static final int INDEX_GROUP_YANE = 4;
    private static final int INDEX_GROUP_FIX_L = 5;
    private static final int INDEX_GROUP_FIX_R = 6;
    private static final int INDEX_GROUP_FIX_ROOM_L = 7;
    private static final int INDEX_GROUP_FIX_ROOM_R = 8;
    private ZtHeight height = ZtHeight.H_2100;
    protected ZtDepth depth = ZtDepth.D_6;
    private float heightMM = 0.0f;
    private float totalHeight = 0.0f;
    private ZtDeckOsamari deck = ZtDeckOsamari.FLAT;
    private ZtPillarType pillarType = ZtPillarType.STANDARD;
    private ZtDeckType deckType = ZtDeckType.KINOKI3;
    protected ZtOsamari osamari = ZtOsamari.STD;
    protected ZtBalcony balcony = ZtBalcony.NONE;
    private boolean isThreeSyakuEx = false;
    private float floorlevel = 400.0f;
    private TransForm2f trans;
    private List<AbstractTerraceUnit> units = null;

    public MultiSpanTerrace() {
        super(9);
        this.color_group[0] = 0;
        this.color_group[1] = 1;
        this.color_group[2] = 2;
        this.color_group[3] = 3;
        this.color_group[4] = 4;
        this.color_group[5] = 6;
        this.color_group[6] = 7;
        this.color_group[7] = 9;
        this.color_group[8] = 10;
        this.trans = new TransForm2f();
        this.setColorChanged(true);
        this.units = new ArrayList<AbstractTerraceUnit>();
    }

    public List<AbstractTerraceUnit> getUnits() {
        return this.units;
    }

    public float getFloorlevel() {
        return this.floorlevel;
    }

    public TransForm2f getTrans() {
        return this.trans;
    }

    public void setFL(float f) {
        this.setFloorlevel(f);
    }

    public void setFloorlevel(float f) {
        this.floorlevel = f;
    }

    public void setAxis(float f, float f2, float f3) {
        this.trans.x = f;
        this.trans.y = f2;
        this.trans.angle = f3;
    }

    public ZtHeight getHeight() {
        return this.height;
    }

    public ZtDepth getDepth() {
        return this.depth;
    }

    public float getHeightMM() {
        return this.heightMM;
    }

    public float getTotalHeight() {
        return this.totalHeight;
    }

    public ZtDeckOsamari getDeck() {
        return this.deck;
    }

    public ZtPillarType getPillarType() {
        return this.pillarType;
    }

    public ZtDeckType getDeckType() {
        return this.deckType;
    }

    public ZtOsamari getOsamari() {
        return this.osamari;
    }

    public ZtBalcony getBalcony() {
        return this.balcony;
    }

    public boolean isThreeSyakuEx() {
        return this.isThreeSyakuEx;
    }

    public void setHeight(ZtHeight ztHeight) {
        this.height = ztHeight;
    }

    public void setDepth(ZtDepth ztDepth) {
        this.depth = ztDepth;
    }

    public void setHeightMM(float f) {
        this.heightMM = f;
    }

    public void setTotalHeight(float f) {
        this.totalHeight = f;
    }

    public void setDeck(ZtDeckOsamari ztDeckOsamari) {
        this.deck = ztDeckOsamari;
    }

    public void setPillarType(ZtPillarType ztPillarType) {
        this.pillarType = ztPillarType;
    }

    public void setDeckType(ZtDeckType ztDeckType) {
        this.deckType = ztDeckType;
    }

    public void setOsamari(ZtOsamari ztOsamari) {
        this.osamari = ztOsamari;
    }

    public void setBalcony(ZtBalcony ztBalcony) {
        if (ztBalcony == null) {
            ztBalcony = ZtBalcony.NONE;
        }
        this.balcony = ztBalcony;
    }

    public void setThreeSyakuEx(boolean bl) {
        this.isThreeSyakuEx = bl;
    }

    public int getGroup_color_keta_taruki() {
        return this.color_code[1];
    }

    public void setGroup_color_keta_taruki(int n) {
        this.setColor(1, n);
    }

    public int getGroup_color_other() {
        return this.color_code[2];
    }

    public void setGroup_color_other(int n) {
        this.setColor(2, n);
    }

    public int getGroup_color_panel() {
        return this.color_code[3];
    }

    public void setGroup_color_panel(int n) {
        this.setColor(3, n);
    }

    public int getGroup_color_pillar() {
        return this.color_code[0];
    }

    public void setGroup_color_pillar(int n) {
        this.setColor(0, n);
    }

    public int getYanezai() {
        return this.color_code[4];
    }

    public void setYanezai(int n) {
        this.setColor(4, n);
    }

    public void setFixLeft(int n) {
        this.setColor(5, n);
    }

    public void setFixRight(int n) {
        this.setColor(6, n);
    }

    public void setFixRoomLeft(int n) {
        this.setColor(7, n);
    }

    public void setFixRoomRight(int n) {
        this.setColor(8, n);
    }

    public int getFixLeft() {
        return this.color_code[5];
    }

    public int getFixRight() {
        return this.color_code[6];
    }

    public int getFixRoomLeft() {
        return this.color_code[7];
    }

    public int getFixRoomRight() {
        return this.color_code[8];
    }

    public Color getIndexColor(int n) {
        if (n >= 4) {
            return ZimaPanelColor.getColor(this.color_code[n]);
        }
        return ZimaColor.getColor(this.color_code[n]);
    }

    public float getTotalWidthInLength() {
        float f = 0.0f;
        for (AbstractTerraceUnit abstractTerraceUnit : this.units) {
            f += abstractTerraceUnit.getWidth().getW();
        }
        return f -= (float)((this.units.size() - 1) * 10);
    }

    public float getTotalRailII() {
        if (this.units.size() == 1) {
            return this.units.get(0).getWidth().getWidthForRail();
        }
        float f = this.getTotalWidthInLength();
        return f - 245.0f;
    }

    public void setClosePanel(boolean bl) {
        for (AbstractTerraceUnit abstractTerraceUnit : this.units) {
            this.setClosePanel(abstractTerraceUnit.getFrontRail(), bl, ZtPanelState.OPEN_NEXT);
            this.setClosePanel(abstractTerraceUnit.getLeftRail(), bl, ZtPanelState.OPEN_NEXT);
            this.setClosePanel(abstractTerraceUnit.getRightRail(), bl, ZtPanelState.OPEN_PREV);
        }
    }

    private void setClosePanel(RailProperty railProperty, boolean bl, ZtPanelState ztPanelState) {
        if (railProperty == null) {
            return;
        }
        ZtPanelState ztPanelState2 = ZtPanelState.CLOSE;
        if (!bl) {
            ztPanelState2 = ztPanelState;
        }
        if (!railProperty.getPanel().equals((Object)ZtPanel.ORIDO)) {
            ztPanelState2 = ZtPanelState.CLOSE;
        }
        railProperty.setPanelState(ztPanelState2);
    }

    public AbstractTerraceUnit getFirstUnit() {
        if (this.units.size() == 0) {
            return null;
        }
        return this.units.get(0);
    }

    public AbstractTerraceUnit getLastUnit() {
        if (this.units.size() == 0) {
            return null;
        }
        return this.units.get(this.units.size() - 1);
    }
}

