/*
 * Decompiled with CFR 0.152.
 */
package zima.multispan;

import com.kt.util.tree.ObjectFolder;
import com.kt.util.tree.ObjectNode;
import kinoki3exchange.KxModule;
import kinoki3exchange.KxModuleUtil;
import model.item.Item;
import zima.multispan.FrontRailProperty;
import zima.multispan.MidPillarProperty;
import zima.multispan.MultiSpanNodeName;
import zima.multispan.MultiSpanTerrace;
import zima.multispan.MultiSpanZimaUnitType;
import zima.multispan.SidePanelProperty;
import zima.multispan.SideRailProperty;
import zima.multispan.types.ZtOsamari;
import zima.multispan.types.ZtWidth;

public abstract class AbstractTerraceUnit
extends Item
implements KxModule {
    protected MultiSpanTerrace terrace = null;
    protected AbstractTerraceUnit prev = null;
    protected AbstractTerraceUnit next = null;
    protected SideRailProperty leftRail = null;
    protected SideRailProperty rightRail = null;
    protected FrontRailProperty frontRail = null;
    protected SidePanelProperty leftSide = null;
    protected SidePanelProperty rightSide = null;
    protected ZtWidth width = ZtWidth.W_15;
    protected ZtOsamari osamari = ZtOsamari.STD;
    protected float cx;
    protected float threeSyakuExLeftRoofWidth;
    protected float threeSyakuExRightRoofWidth;
    protected float frameDepthCut = 0.0f;
    protected float threeSyakuExDepth = 0.0f;
    protected float underBalconyHeight;
    protected float underMizukiriHeight;
    protected float balconyUnderFixHeight = 0.0f;
    protected float balconyDepth = 0.0f;
    private float tsumabariUpperFixHeight = 0.0f;
    protected MidPillarProperty midPillar = MidPillarProperty.NONE;
    protected MultiSpanZimaUnitType unitType = MultiSpanZimaUnitType.GENERIC;

    public AbstractTerraceUnit(MultiSpanTerrace multiSpanTerrace) {
        this.terrace = multiSpanTerrace;
    }

    public AbstractTerraceUnit() {
    }

    public MultiSpanTerrace getTerrace() {
        return this.terrace;
    }

    public void setTerrace(MultiSpanTerrace multiSpanTerrace) {
        this.terrace = multiSpanTerrace;
    }

    public AbstractTerraceUnit getPrev() {
        return this.prev;
    }

    public AbstractTerraceUnit getNext() {
        return this.next;
    }

    public void setPrev(AbstractTerraceUnit abstractTerraceUnit) {
        this.prev = abstractTerraceUnit;
    }

    public void setNext(AbstractTerraceUnit abstractTerraceUnit) {
        this.next = abstractTerraceUnit;
    }

    public void clear() {
        this.terrace = null;
        this.next = null;
        this.prev = null;
        this.rightRail = null;
        this.leftRail = null;
        this.rightSide = null;
        this.leftSide = null;
        this.osamari = null;
        this.width = null;
        this.frontRail = null;
    }

    public SideRailProperty getLeftRail() {
        return this.leftRail;
    }

    public SidePanelProperty getLeftSide() {
        return this.leftSide;
    }

    public SideRailProperty getRightRail() {
        return this.rightRail;
    }

    public SidePanelProperty getRightSide() {
        return this.rightSide;
    }

    public FrontRailProperty getFrontRail() {
        return this.frontRail;
    }

    public ZtWidth getWidth() {
        return this.width;
    }

    public float getX1() {
        float f = -this.width.getW() / 2.0f;
        if (this.prev != null) {
            f += 5.0f;
        }
        return f;
    }

    public float getX2() {
        float f = this.width.getW() / 2.0f;
        if (this.next != null) {
            f -= 5.0f;
        }
        return f;
    }

    public ZtOsamari getOsamari() {
        return this.osamari;
    }

    public float getCx() {
        return this.cx;
    }

    public float getThreeSyakuExLeftRoofWidth() {
        return this.threeSyakuExLeftRoofWidth;
    }

    public float getThreeSyakuExRightRoofWidth() {
        return this.threeSyakuExRightRoofWidth;
    }

    public float getFrameDepthCut() {
        return this.frameDepthCut;
    }

    public float getThreeSyakuExDepth() {
        return this.threeSyakuExDepth;
    }

    public float getUnderBalconyHeight() {
        return this.underBalconyHeight;
    }

    public float getUnderMizukiriHeight() {
        return this.underMizukiriHeight;
    }

    public float getBalconyUnderFixHeight() {
        return this.balconyUnderFixHeight;
    }

    public float getBalconyDepth() {
        return this.balconyDepth;
    }

    public float getTsumabariUpperFixHeight() {
        return this.tsumabariUpperFixHeight;
    }

    public void setLeftRail(SideRailProperty sideRailProperty) {
        this.leftRail = sideRailProperty;
    }

    public void setLeftSide(SidePanelProperty sidePanelProperty) {
        this.leftSide = sidePanelProperty;
    }

    public void setRightRail(SideRailProperty sideRailProperty) {
        this.rightRail = sideRailProperty;
    }

    public void setRightSide(SidePanelProperty sidePanelProperty) {
        this.rightSide = sidePanelProperty;
    }

    public void setFrontRail(FrontRailProperty frontRailProperty) {
        this.frontRail = frontRailProperty;
    }

    public void setWidth(ZtWidth ztWidth) {
        this.width = ztWidth;
    }

    public void setOsamari(ZtOsamari ztOsamari) {
        this.osamari = ztOsamari;
    }

    public void setCx(float f) {
        this.cx = f;
    }

    public void setThreeSyakuExLeftRoofWidth(float f) {
        this.threeSyakuExLeftRoofWidth = f;
    }

    public void setThreeSyakuExRightRoofWidth(float f) {
        this.threeSyakuExRightRoofWidth = f;
    }

    public void setFrameDepthCut(float f) {
        this.frameDepthCut = f;
    }

    public void setThreeSyakuExDepth(float f) {
        this.threeSyakuExDepth = f;
    }

    public void setUnderBalconyHeight(float f) {
        this.underBalconyHeight = f;
    }

    public void setUnderMizukiriHeight(float f) {
        this.underMizukiriHeight = f;
    }

    public void setBalconyUnderFixHeight(float f) {
        this.balconyUnderFixHeight = f;
    }

    public void setBalconyDepth(float f) {
        this.balconyDepth = f;
    }

    public void setTsumabariUpperFixHeight(float f) {
        this.tsumabariUpperFixHeight = f;
    }

    public ZtWidth getPanelWidth() {
        return this.width;
    }

    public void setMidPillar(MidPillarProperty midPillarProperty) {
        this.midPillar = midPillarProperty;
    }

    public MidPillarProperty getMidPillar() {
        return this.midPillar;
    }

    public MultiSpanZimaUnitType getUnitType() {
        return this.unitType;
    }

    public void setUnitType(MultiSpanZimaUnitType multiSpanZimaUnitType) {
        this.unitType = multiSpanZimaUnitType;
    }

    public void saveCommon(ObjectFolder objectFolder) {
        ObjectFolder objectFolder2;
        KxModuleUtil.addString((ObjectFolder)objectFolder, (Enum)MultiSpanNodeName.unitType, (String)this.unitType.name());
        KxModuleUtil.addString((ObjectFolder)objectFolder, (Enum)MultiSpanNodeName.width, (String)this.width.name());
        KxModuleUtil.addString((ObjectFolder)objectFolder, (Enum)MultiSpanNodeName.osamari, (String)this.osamari.name());
        KxModuleUtil.addString((ObjectFolder)objectFolder, (Enum)MultiSpanNodeName.midPillar, (String)this.midPillar.name());
        KxModuleUtil.addFloat((ObjectFolder)objectFolder, (Enum)MultiSpanNodeName.cx, (float)this.cx);
        KxModuleUtil.addFloat((ObjectFolder)objectFolder, (Enum)MultiSpanNodeName.threeSyakuExLeftRoofWidth, (float)this.threeSyakuExLeftRoofWidth);
        KxModuleUtil.addFloat((ObjectFolder)objectFolder, (Enum)MultiSpanNodeName.threeSyakuExRightRoofWidth, (float)this.threeSyakuExRightRoofWidth);
        KxModuleUtil.addFloat((ObjectFolder)objectFolder, (Enum)MultiSpanNodeName.threeSyakuExDepth, (float)this.threeSyakuExDepth);
        KxModuleUtil.addFloat((ObjectFolder)objectFolder, (Enum)MultiSpanNodeName.underBalconyHeight, (float)this.underBalconyHeight);
        KxModuleUtil.addFloat((ObjectFolder)objectFolder, (Enum)MultiSpanNodeName.underMizukiriHeight, (float)this.underMizukiriHeight);
        KxModuleUtil.addFloat((ObjectFolder)objectFolder, (Enum)MultiSpanNodeName.balconyUnderFixHeight, (float)this.balconyUnderFixHeight);
        KxModuleUtil.addFloat((ObjectFolder)objectFolder, (Enum)MultiSpanNodeName.balconyDepth, (float)this.balconyDepth);
        KxModuleUtil.addFloat((ObjectFolder)objectFolder, (Enum)MultiSpanNodeName.tsumabariUpperFixHeight, (float)this.tsumabariUpperFixHeight);
        KxModuleUtil.addFloat((ObjectFolder)objectFolder, (Enum)MultiSpanNodeName.frameDepthCut, (float)this.frameDepthCut);
        if (this.leftRail != null) {
            objectFolder2 = KxModuleUtil.createNode((Enum)MultiSpanNodeName.leftRail);
            this.leftRail.save(objectFolder2);
            objectFolder.addChild((ObjectNode)objectFolder2, true);
        }
        if (this.rightRail != null) {
            objectFolder2 = KxModuleUtil.createNode((Enum)MultiSpanNodeName.rightRail);
            this.rightRail.save(objectFolder2);
            objectFolder.addChild((ObjectNode)objectFolder2, true);
        }
        if (this.frontRail != null) {
            objectFolder2 = KxModuleUtil.createNode((Enum)MultiSpanNodeName.frontRail);
            this.frontRail.save(objectFolder2);
            objectFolder.addChild((ObjectNode)objectFolder2, true);
        }
        if (this.leftSide != null) {
            objectFolder2 = KxModuleUtil.createNode((Enum)MultiSpanNodeName.leftSide);
            this.leftSide.save(objectFolder2);
            objectFolder.addChild((ObjectNode)objectFolder2, true);
        }
        if (this.rightSide != null) {
            objectFolder2 = KxModuleUtil.createNode((Enum)MultiSpanNodeName.rightSide);
            this.rightSide.save(objectFolder2);
            objectFolder.addChild((ObjectNode)objectFolder2, true);
        }
    }

    public void loadCommon(ObjectFolder objectFolder) {
        if (this.unitType == null) {
            this.unitType = MultiSpanZimaUnitType.valueOf(KxModuleUtil.getString((ObjectFolder)objectFolder, (Enum)MultiSpanNodeName.unitType));
        }
        this.width = ZtWidth.valueOf(KxModuleUtil.getString((ObjectFolder)objectFolder, (Enum)MultiSpanNodeName.width));
        this.osamari = ZtOsamari.valueOf(KxModuleUtil.getString((ObjectFolder)objectFolder, (Enum)MultiSpanNodeName.osamari));
        this.midPillar = MidPillarProperty.valueOf(KxModuleUtil.getString((ObjectFolder)objectFolder, (Enum)MultiSpanNodeName.midPillar));
        this.cx = KxModuleUtil.getFloat((ObjectFolder)objectFolder, (Enum)MultiSpanNodeName.cx);
        this.threeSyakuExLeftRoofWidth = KxModuleUtil.getFloat((ObjectFolder)objectFolder, (Enum)MultiSpanNodeName.threeSyakuExLeftRoofWidth);
        this.threeSyakuExRightRoofWidth = KxModuleUtil.getFloat((ObjectFolder)objectFolder, (Enum)MultiSpanNodeName.threeSyakuExRightRoofWidth);
        this.threeSyakuExDepth = KxModuleUtil.getFloat((ObjectFolder)objectFolder, (Enum)MultiSpanNodeName.threeSyakuExDepth);
        this.underBalconyHeight = KxModuleUtil.getFloat((ObjectFolder)objectFolder, (Enum)MultiSpanNodeName.underBalconyHeight);
        this.underMizukiriHeight = KxModuleUtil.getFloat((ObjectFolder)objectFolder, (Enum)MultiSpanNodeName.underMizukiriHeight);
        this.balconyUnderFixHeight = KxModuleUtil.getFloat((ObjectFolder)objectFolder, (Enum)MultiSpanNodeName.balconyUnderFixHeight);
        this.balconyDepth = KxModuleUtil.getFloat((ObjectFolder)objectFolder, (Enum)MultiSpanNodeName.balconyDepth);
        this.tsumabariUpperFixHeight = KxModuleUtil.getFloat((ObjectFolder)objectFolder, (Enum)MultiSpanNodeName.tsumabariUpperFixHeight);
        this.frameDepthCut = KxModuleUtil.getFloat((ObjectFolder)objectFolder, (Enum)MultiSpanNodeName.frameDepthCut);
        ObjectNode objectNode = null;
        objectNode = objectFolder.getNode(MultiSpanNodeName.leftRail.name());
        if (objectNode != null && objectNode instanceof ObjectFolder) {
            this.leftRail = new SideRailProperty();
            this.leftRail.load((ObjectFolder)objectNode);
        }
        if ((objectNode = objectFolder.getNode(MultiSpanNodeName.rightRail.name())) != null && objectNode instanceof ObjectFolder) {
            this.rightRail = new SideRailProperty();
            this.rightRail.load((ObjectFolder)objectNode);
        }
        if ((objectNode = objectFolder.getNode(MultiSpanNodeName.frontRail.name())) != null && objectNode instanceof ObjectFolder) {
            this.frontRail = new FrontRailProperty();
            this.frontRail.load((ObjectFolder)objectNode);
        }
        if ((objectNode = objectFolder.getNode(MultiSpanNodeName.leftSide.name())) != null && objectNode instanceof ObjectFolder) {
            this.leftSide = new SidePanelProperty();
            this.leftSide.load((ObjectFolder)objectNode);
        }
        if ((objectNode = objectFolder.getNode(MultiSpanNodeName.rightSide.name())) != null && objectNode instanceof ObjectFolder) {
            this.rightSide = new SidePanelProperty();
            this.rightSide.load((ObjectFolder)objectNode);
        }
    }

    public float getLeftKutaiBase() {
        return 0.0f;
    }

    public float getRightKutaiBase() {
        return 0.0f;
    }
}

