/*
 * Decompiled with CFR 0.152.
 */
package zima;

import exsior.ZeProperty;
import exsior.types.ZeDepth;
import java.util.List;
import kinoki3exchange.figure.KxPoint;
import kinoki3exchange.shape.KxBaseZaiInner;
import kinoki3exchange.shape.KxDimension;
import kinoki3exchange.shape.KxEdgeConstraints;
import kinoki3exchange.shape.KxExsiorEdge;
import kinoki3exchange.shape.KxFloorBoard;
import kinoki3exchange.shape.KxFloorReinforceSet;
import kinoki3exchange.shape.KxGenericEdge;
import kinoki3exchange.shape.KxNaimen;
import kinoki3exchange.shape.KxOobiki;
import kinoki3exchange.shape.KxOobikiInner;
import kinoki3exchange.shape.KxPillar;
import kinoki3exchange.shape.KxPillarInner;
import kinoki3exchange.shape.KxPillarSet;
import kinoki3exchange.shape.KxShape;
import kinoki3exchange.shape.KxSizeSet;

public class DepthCutForShape {
    public static void process(KxShape kxShape, ZeProperty zeProperty, float f) {
        if (kxShape == null) {
            return;
        }
        kxShape.standard = false;
        KxExsiorEdge kxExsiorEdge = kxShape.getEdge();
        KxOobiki kxOobiki = kxShape.getOobiki();
        KxFloorReinforceSet kxFloorReinforceSet = kxShape.getFloorReinforce();
        KxSizeSet kxSizeSet = kxShape.getSize();
        KxNaimen kxNaimen = kxShape.getNaimen1003();
        KxPillarSet kxPillarSet = kxShape.getPillarset();
        if (kxExsiorEdge != null) {
            DepthCutForShape.processExsiorEdge(kxExsiorEdge, f);
        }
        if (kxOobiki != null) {
            DepthCutForShape.processOobiki(kxOobiki, f, kxNaimen != null);
        }
        if (kxFloorReinforceSet != null) {
            DepthCutForShape.processReinforce(kxFloorReinforceSet, f);
        }
        if (kxSizeSet != null) {
            DepthCutForShape.processSize(kxSizeSet, f);
        }
        if (kxNaimen != null) {
            DepthCutForShape.processNaimen(kxNaimen, zeProperty, f);
        }
        if (kxPillarSet != null) {
            DepthCutForShape.processPillar(kxPillarSet, f);
        }
    }

    private static void processExsiorEdge(KxExsiorEdge kxExsiorEdge, float f) {
        if (kxExsiorEdge.getPrev() != null) {
            DepthCutForShape.processGenericEdge(kxExsiorEdge.getPrev(), f);
        } else if (kxExsiorEdge.getNext() != null) {
            DepthCutForShape.processGenericEdge(kxExsiorEdge.getNext(), f);
        }
    }

    private static void processGenericEdge(KxGenericEdge kxGenericEdge, float f) {
        for (KxEdgeConstraints kxEdgeConstraints : kxGenericEdge.getList()) {
            if (!(kxEdgeConstraints instanceof KxEdgeConstraints.Length)) continue;
            KxEdgeConstraints.Length length = (KxEdgeConstraints.Length)kxEdgeConstraints;
            length.setLength(length.getLength() - f);
        }
    }

    private static void processOobiki(KxOobiki kxOobiki, float f, boolean bl) {
        float[] fArray = kxOobiki.getPitch();
        float f2 = 0.0f;
        float f3 = 0.0f;
        int n = fArray.length - (bl ? 1 : 0);
        int n2 = 1;
        int n3 = 1;
        while (n3 < n) {
            f2 += fArray[n3];
            ++n3;
        }
        f3 = bl ? f2 : f2 - fArray[n - 1];
        f3 -= f;
        if (!bl) {
            while (f3 / (float)n2 > 900.0f) {
                ++n2;
            }
        } else {
            n2 = n - 1;
        }
        float f4 = f3 / (float)n2;
        float[] fArray2 = new float[n2 + 2];
        fArray2[0] = fArray[0];
        fArray2[fArray2.length - 1] = fArray[fArray.length - 1];
        fArray = fArray2;
        kxOobiki.setPitch(fArray2);
        int n4 = 1;
        while (n4 < n2 + 2 - 1) {
            fArray[n4] = f4;
            ++n4;
        }
    }

    private static void processReinforce(KxFloorReinforceSet kxFloorReinforceSet, float f) {
    }

    private static void processSize(KxSizeSet kxSizeSet, float f) {
        KxDimension kxDimension = kxSizeSet.getMinimum();
        float f2 = Float.MAX_VALUE;
        for (KxPoint kxPoint : kxDimension.getPoints()) {
            if (!(kxPoint.y < f2)) continue;
            f2 = kxPoint.y;
        }
        for (KxPoint kxPoint : kxDimension.getPoints()) {
            if (f2 != kxPoint.y) continue;
            kxPoint.y += f;
        }
        kxDimension.setDepth(kxDimension.getDepth() - f);
    }

    private static void processPillar(KxPillarSet kxPillarSet, float f) {
        for (KxPillar kxPillar : kxPillarSet.getList()) {
            kxPillar.setCy(kxPillar.getCy());
        }
    }

    public static void processNaimen(KxNaimen kxNaimen, ZeProperty zeProperty, float f) {
        float[] fArray = DepthCutForShape.processBaseZai(kxNaimen.getBaseCollection(), zeProperty, f);
        DepthCutForShape.processBoard(kxNaimen.getList(), f);
        DepthCutForShape.processOobiki(kxNaimen.getOobikiCollection(), f, fArray[0], fArray[1]);
        DepthCutForShape.processNaimenEdge(kxNaimen.getPoints(), f);
        DepthCutForShape.processNaimenEdge(kxNaimen.getPointsForBase(), f);
    }

    private static float[] processBaseZai(List<KxBaseZaiInner> list, ZeProperty zeProperty, float f) {
        float f2 = Float.MAX_VALUE;
        float f3 = -3.4028235E38f;
        float f4 = 0.0f;
        if (zeProperty.depth.compareTo(ZeDepth.D6Fore) == 0 || zeProperty.depth.compareTo(ZeDepth.D8Fore) == 0) {
            f4 = 1200.0f - f;
        } else if (zeProperty.depth.compareTo(ZeDepth.D6Under) == 0 || zeProperty.depth.compareTo(ZeDepth.D8Under) == 0) {
            f4 = 900.0f - f;
        }
        for (KxBaseZaiInner kxBaseZaiInner : list) {
            if (kxBaseZaiInner.y1 == kxBaseZaiInner.y2) continue;
            if (f2 > kxBaseZaiInner.y1) {
                f2 = kxBaseZaiInner.y1;
            }
            if (f2 > kxBaseZaiInner.y2) {
                f2 = kxBaseZaiInner.y2;
            }
            if (f3 < kxBaseZaiInner.y1) {
                f3 = kxBaseZaiInner.y1;
            }
            if (!(f3 < kxBaseZaiInner.y2)) continue;
            f3 = kxBaseZaiInner.y2;
        }
        for (KxBaseZaiInner kxBaseZaiInner : list) {
            if (kxBaseZaiInner.y1 == f2) {
                kxBaseZaiInner.y1 += f;
                DepthCutForShape.processBaseZaiTsukaPillar(kxBaseZaiInner, f4, f);
                continue;
            }
            if (kxBaseZaiInner.y2 == f2) {
                kxBaseZaiInner.y2 += f;
                DepthCutForShape.processBaseZaiTsukaPillar(kxBaseZaiInner, f4, f);
                continue;
            }
            if (kxBaseZaiInner.y1 != kxBaseZaiInner.y2) continue;
            kxBaseZaiInner.y1 += f;
            kxBaseZaiInner.y2 += f;
            DepthCutForShape.processBaseZaiTsukaPillar(kxBaseZaiInner, f4, f);
        }
        return new float[]{f2, f3};
    }

    private static void processBaseZaiTsukaPillar(KxBaseZaiInner kxBaseZaiInner, float f, float f2) {
        List list = kxBaseZaiInner.getList();
        float f3 = 200.0f;
        float f4 = 900.0f;
        if (kxBaseZaiInner.y1 == kxBaseZaiInner.y2) {
            for (KxPillarInner kxPillarInner : list) {
                kxPillarInner.y += f2;
            }
        } else {
            float f5 = Math.abs(kxBaseZaiInner.y2 - kxBaseZaiInner.y1);
            if (f == 0.0f) {
                float f6 = (f5 - 900.0f) / (float)(list.size() - 1);
                float f7 = (f5 - 650.0f) / (float)(list.size() - 1);
                float f8 = (f5 - 400.0f) / (float)(list.size() - 1);
                float f9 = 0.0f;
                float f10 = 0.0f;
                float f11 = 0.0f;
                float f12 = 0.0f;
                if (f6 >= f3 && f6 >= 450.0f) {
                    f10 = 450.0f;
                    f11 = 450.0f;
                    f12 = 450.0f;
                    f9 = f6;
                } else if (f7 >= f3 && f7 <= f4) {
                    f10 = 450.0f;
                    f11 = 200.0f;
                    f12 = 450.0f;
                    f9 = f7;
                } else {
                    f10 = 200.0f;
                    f11 = 200.0f;
                    f12 = 200.0f;
                    f9 = f8;
                }
                KxPillarInner kxPillarInner = (KxPillarInner)list.get(0);
                kxPillarInner.y = Math.max(kxBaseZaiInner.y1, kxBaseZaiInner.y2) - f10;
                kxPillarInner = (KxPillarInner)list.get(list.size() - 1);
                kxPillarInner.y = Math.min(kxBaseZaiInner.y1, kxBaseZaiInner.y2) + f11;
                int n = 1;
                while (n < list.size() - 1) {
                    kxPillarInner = (KxPillarInner)list.get(n);
                    kxPillarInner.y = Math.max(kxBaseZaiInner.y1, kxBaseZaiInner.y2) - f12 - f9 * (float)n;
                    ++n;
                }
            } else {
                float f13;
                float f14;
                KxPillarInner kxPillarInner;
                int n = 2;
                if (f < 520.0f) {
                    n = 1;
                } else {
                    kxPillarInner = (KxPillarInner)list.get(1);
                    kxPillarInner.y = Math.max(kxBaseZaiInner.y1, kxBaseZaiInner.y2) - f + (f - 400.0f >= 200.0f ? 200.0f : f - 400.0f);
                }
                kxPillarInner = (KxPillarInner)list.get(0);
                kxPillarInner.y = Math.max(kxBaseZaiInner.y1, kxBaseZaiInner.y2) - 200.0f;
                float f15 = ((f5 -= f) - 900.0f) / (float)(list.size() - n - 1);
                float f16 = (f5 - 650.0f) / (float)(list.size() - n - 1);
                float f17 = (f5 - 400.0f) / (float)(list.size() - n - 1);
                float f18 = 0.0f;
                if (f15 >= f3 && f15 >= 450.0f) {
                    f14 = 450.0f;
                    f13 = 450.0f;
                    f18 = f15;
                } else if (f16 >= f3 && f16 <= f4) {
                    f14 = 200.0f;
                    f13 = 450.0f;
                    f18 = f16;
                } else {
                    f14 = 200.0f;
                    f13 = 200.0f;
                    f18 = f17;
                }
                kxPillarInner = (KxPillarInner)list.get(n);
                kxPillarInner.y = Math.max(kxBaseZaiInner.y1, kxBaseZaiInner.y2) - f - f14;
                kxPillarInner = (KxPillarInner)list.get(list.size() - 1);
                kxPillarInner.y = Math.min(kxBaseZaiInner.y1, kxBaseZaiInner.y2) + f13;
                int n2 = n;
                while (n2 < list.size() - 1) {
                    kxPillarInner = (KxPillarInner)list.get(n2);
                    kxPillarInner.y = Math.max(kxBaseZaiInner.y1, kxBaseZaiInner.y2) - f - f14 - f18 * (float)(n2 - n);
                    ++n2;
                }
            }
        }
    }

    private static void processBoard(List<KxFloorBoard> list, float f) {
        for (KxFloorBoard kxFloorBoard : list) {
            kxFloorBoard.setLength(kxFloorBoard.getLength() - f);
            float[] fArray = kxFloorBoard.getPoints();
            fArray[3] = fArray[3] + f;
            fArray[5] = fArray[5] + f;
        }
    }

    private static void processOobiki(List<KxOobikiInner> list, float f, float f2, float f3) {
        int n = list.size();
        float f4 = (Math.abs(f3 - f2) - 200.0f - f) / (float)n;
        int n2 = 1;
        while (n2 < list.size()) {
            KxOobikiInner kxOobikiInner = list.get(n2);
            kxOobikiInner.y1 = kxOobikiInner.y2 = f3 - 200.0f - f4 * (float)n2;
            for (KxPillarInner kxPillarInner : kxOobikiInner.getList()) {
                kxPillarInner.y = kxOobikiInner.y1;
            }
            ++n2;
        }
    }

    private static void processNaimenEdge(List<KxPoint> list, float f) {
        float f2 = Float.MAX_VALUE;
        for (KxPoint kxPoint : list) {
            if (!(kxPoint.y < f2)) continue;
            f2 = kxPoint.y;
        }
        for (KxPoint kxPoint : list) {
            if (kxPoint.y != f2) continue;
            kxPoint.y += f;
        }
    }
}

