/*
 * Decompiled with CFR 0.152.
 */
package option.zima2.shape.main.service;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import option.gad.core.inject.GdInject;
import option.gad.core.inject.GdInjector;
import option.gad.core.util.ObjectUtil;
import option.zima2.common.dao.cache.type.TypeTerraceWidthCacheDao;
import option.zima2.common.entity.BasicInfo;
import option.zima2.common.entity.TerraceInfo;
import option.zima2.common.entity.TerracesInfo;
import option.zima2.common.entity.ZM2Entities;
import option.zima2.common.entity.type.TypeTerraceWidthInfo;
import option.zima2.shape.common.service.AbstractTerraceUpdater;
import option.zima2.shape.main.item.AbstractTerraceUnitItem;
import option.zima2.shape.main.item.ItemTerraceUnitGeneric;
import option.zima2.shape.main.item.MsItemTerrace;
import option.zima2.shape.main.parts.MsPartsTerrace;
import option.zima2.shape.main.service.PartsFigureService;

public class ZM2TerraceUpdater
extends AbstractTerraceUpdater {
    @GdInject
    protected PartsFigureService mPartsFigureService;
    @GdInject
    protected TypeTerraceWidthCacheDao mTypeTerraceWidthCacheDao;

    public ZM2TerraceUpdater() {
        GdInjector.getInstance().inject((Object)this);
    }

    @Override
    public void update(MsItemTerrace msItemTerrace) {
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        TerracesInfo terracesInfo = zM2Entities.mTerracesInfo;
        this.updateUnitItems(msItemTerrace);
        this.updateSpanPitches(msItemTerrace.getUnits(), terracesInfo);
        this.updatePartsFigureInfo(msItemTerrace);
    }

    protected void updateUnitItems(MsItemTerrace msItemTerrace) {
        Object object;
        int n;
        List<AbstractTerraceUnitItem> list = msItemTerrace.getUnits();
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        LinkedList<TerraceInfo> linkedList = zM2Entities.mTerraceInfoList;
        if (list.size() != 0) {
            for (AbstractTerraceUnitItem abstractTerraceUnitItem : list) {
                abstractTerraceUnitItem.clear();
            }
            list.clear();
        }
        int n2 = 0;
        while (n2 < linkedList.size()) {
            ItemTerraceUnitGeneric itemTerraceUnitGeneric = new ItemTerraceUnitGeneric();
            itemTerraceUnitGeneric.setTerraceItem(msItemTerrace);
            list.add(itemTerraceUnitGeneric);
            ++n2;
        }
        float f = msItemTerrace.getTotalWidthInLength();
        float f2 = -f / 2.0f;
        if (linkedList != null) {
            Iterator iterator = linkedList.iterator();
            n = 0;
            while (n < list.size()) {
                object = (TerraceInfo)iterator.next();
                TerraceInfo terraceInfo = new TerraceInfo();
                ObjectUtil.shallowCopy((Object)object, (Object)terraceInfo);
                list.get(n).setTerraceInfo(terraceInfo);
                ++n;
            }
        }
        float f3 = f2;
        n = 0;
        while (n < linkedList.size()) {
            boolean bl;
            float f4;
            object = list.get(n);
            float f5 = f4 = ((AbstractTerraceUnitItem)((Object)object)).getTerraceInfo().mWidth.floatValue();
            float f6 = f4 / 2.0f;
            boolean bl2 = n > 0;
            boolean bl3 = bl = n < linkedList.size() - 1;
            if (bl2) {
                ((AbstractTerraceUnitItem)((Object)object)).setPrev(list.get(n - 1));
            }
            if (bl) {
                ((AbstractTerraceUnitItem)((Object)object)).setNext(list.get(n + 1));
            }
            ((AbstractTerraceUnitItem)((Object)object)).setCx(f3 + f6);
            f3 += f5;
            ++n;
        }
    }

    private void updateSpanPitches(List<AbstractTerraceUnitItem> list, TerracesInfo terracesInfo) {
        int n = 0;
        while (n < list.size()) {
            AbstractTerraceUnitItem abstractTerraceUnitItem = list.get(n);
            abstractTerraceUnitItem.setPitches(this.calcSpanPitches(abstractTerraceUnitItem, terracesInfo));
            ++n;
        }
    }

    private float[] calcSpanPitches(AbstractTerraceUnitItem abstractTerraceUnitItem, TerracesInfo terracesInfo) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        ZM2Entities zM2Entities = msItemTerrace.getEntities();
        BasicInfo basicInfo = zM2Entities.mBasicInfo;
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        int n = abstractTerraceUnitItem.getSpanNum();
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = basicInfo.mKenLen.floatValue();
            ++n2;
        }
        if (n > 0) {
            TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(terraceInfo.mWidthType);
            float f = typeTerraceWidthInfo.length.floatValue();
            float f2 = f - terraceInfo.mWidth.floatValue();
            if (abstractTerraceUnitItem.getPrev() == null) {
                fArray[0] = abstractTerraceUnitItem.getNext() == null ? fArray[0] - f2 / 2.0f : fArray[0] - f2;
            }
            if (abstractTerraceUnitItem.getNext() == null) {
                if (abstractTerraceUnitItem.getPrev() == null) {
                    int n3 = n - 1;
                    fArray[n3] = fArray[n3] - f2 / 2.0f;
                } else {
                    int n4 = n - 1;
                    fArray[n4] = fArray[n4] - f2;
                }
            }
        }
        return fArray;
    }

    protected void updatePartsFigureInfo(MsItemTerrace msItemTerrace) {
        this.mPartsFigureService.initPartsFigureInfo(msItemTerrace);
    }

    @Override
    public void updateAfter(MsItemTerrace msItemTerrace, MsPartsTerrace msPartsTerrace) {
        this.mPartsFigureService.initPartsFigureInfoAfter(msItemTerrace, msPartsTerrace);
    }
}

