/*
 * Decompiled with CFR 0.152.
 */
package option.zima2.shape.main.item;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import model.shape.primitive.TransForm2f;
import option.gad.core.inject.GdInstanceFactory;
import option.zima2.common.entity.TerraceInfo;
import option.zima2.common.entity.ZM2Entities;
import option.zima2.common.service.common.ZM2Color;
import option.zima2.common.type.SubProductType;
import option.zima2.common.type.TileUsedType;
import option.zima2.shape.common.item.ZM2Item;
import option.zima2.shape.common.service.CommonShapeService;
import option.zima2.shape.main.item.AbstractTerraceUnitItem;
import option.zima2.shape.main.service.ZM2ShapeColorManager;
import org.apache.commons.lang3.math.NumberUtils;

public class MsItemTerrace
extends ZM2Item
implements Serializable {
    private String mVersion;
    private ZM2Entities entities;
    private List<AbstractTerraceUnitItem> units = null;
    private float floorlevel = 400.0f;
    private TransForm2f trans = new TransForm2f();
    private boolean mVisibleKutai = false;
    private boolean closePanel = true;

    public MsItemTerrace() {
        super(NumberUtils.max((int[])ZM2ShapeColorManager.IDS) + 1);
        this.setColorChanged(true);
        this.entities = new ZM2Entities();
        this.units = new ArrayList<AbstractTerraceUnitItem>();
    }

    public List<AbstractTerraceUnitItem> getUnits() {
        return this.units;
    }

    public void setVersion(String string) {
        this.mVersion = string;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public void setEntities(ZM2Entities zM2Entities) {
        this.entities = zM2Entities;
    }

    public ZM2Entities getEntities() {
        return this.entities;
    }

    public float getFloorlevel() {
        return this.floorlevel;
    }

    public TransForm2f getTrans() {
        return this.trans;
    }

    public void setFL(float f) {
        this.setFloorlevel(f);
    }

    public void setFloorlevel(float f) {
        this.floorlevel = f;
    }

    public void setAxis(float f, float f2, float f3) {
        this.trans.x = f;
        this.trans.y = f2;
        this.trans.angle = f3;
    }

    public float getheightTumabari() {
        return this.entities.mTerracesInfo.mHeight.floatValue();
    }

    public float getDepthInner() {
        return this.entities.mTerracesInfo.mDepth.floatValue() - 125.0f;
    }

    public float getTotalHeight() {
        CommonShapeService commonShapeService = (CommonShapeService)GdInstanceFactory.getInstance().getInstance(CommonShapeService.class, new Object[0]);
        return commonShapeService.getHeight(this) + commonShapeService.getH2(this);
    }

    public Color getIndexColor(int n) {
        return ZM2Color.getColor(this.color_code[n]);
    }

    public float getTotalWidthInLength() {
        float f = 0.0f;
        for (TerraceInfo terraceInfo : this.entities.mTerraceInfoList) {
            f += terraceInfo.mWidth.floatValue();
        }
        return f;
    }

    public void setClosePanel(boolean bl) {
        this.closePanel = bl;
    }

    public boolean getClosePanel() {
        return this.closePanel;
    }

    public AbstractTerraceUnitItem getFirstUnit() {
        if (this.units.size() == 0) {
            return null;
        }
        for (AbstractTerraceUnitItem abstractTerraceUnitItem : this.getUnits()) {
            if (!abstractTerraceUnitItem.getTerraceInfo().mIsLeftEnd.booleanValue()) continue;
            return abstractTerraceUnitItem;
        }
        return null;
    }

    public AbstractTerraceUnitItem getLastUnit() {
        if (this.units.size() == 0) {
            return null;
        }
        for (AbstractTerraceUnitItem abstractTerraceUnitItem : this.getUnits()) {
            if (!abstractTerraceUnitItem.getTerraceInfo().mIsRightEnd.booleanValue()) continue;
            return abstractTerraceUnitItem;
        }
        return null;
    }

    public AbstractTerraceUnitItem findUnitById(int n) {
        for (AbstractTerraceUnitItem abstractTerraceUnitItem : this.getUnits()) {
            if (abstractTerraceUnitItem.getTerraceInfo().mId != n) continue;
            return abstractTerraceUnitItem;
        }
        return null;
    }

    public boolean isVisibleKutai() {
        return this.mVisibleKutai;
    }

    public void setVisibleKutai(boolean bl) {
        this.mVisibleKutai = bl;
    }

    public void updateFloorLevel() {
        if (this.entities.mBasicInfo.mSubProductType == SubProductType.DOMA && this.entities.mDomaTileInfo.mTileUsedType == TileUsedType.ON) {
            this.setFL(this.entities.mDomaTileInfo.mFloorLevel.floatValue());
        } else if (this.entities.mBasicInfo.mSubProductType == SubProductType.INNER_DECK) {
            this.setFL(this.entities.mInnerDeckInfo.mFloorLevel.floatValue());
        } else {
            this.setFL(0.0f);
        }
    }

    public void updateUsed() {
        this.setUsed(true);
        this.setColorChanged(false);
    }
}

